/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.network;

import java.awt.EventQueue;
import javax.swing.AbstractListModel;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.event.ContainerEvent;
import phex.host.FavoriteHost;
import phex.host.FavoritesContainer;
import phex.servent.Servent;

public class FavoritesListModel
extends AbstractListModel {
    private final FavoritesContainer favoritesContainer;

    public FavoritesListModel(FavoritesContainer favoritesContainer) {
        Servent.getInstance().getEventService().processAnnotations(this);
        this.favoritesContainer = favoritesContainer;
    }

    @Override
    public int getSize() {
        return this.favoritesContainer.getBookmarkedHostsCount();
    }

    @Override
    public Object getElementAt(int row) {
        FavoriteHost host = this.favoritesContainer.getBookmarkedHostAt(row);
        if (host == null) {
            this.fireIntervalRemoved(this, row, row);
            return "";
        }
        return host;
    }

    @EventTopicSubscriber(topic="phex:net/favorites")
    public void onBookmarkedHostEventAdded(String topic, final ContainerEvent event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event.getType() == ContainerEvent.Type.ADDED) {
                    FavoritesListModel.this.fireIntervalAdded(this, event.getPosition(), event.getPosition());
                } else if (event.getType() == ContainerEvent.Type.REMOVED) {
                    FavoritesListModel.this.fireIntervalRemoved(this, event.getPosition(), event.getPosition());
                }
            }
        });
    }
}

