/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.GUIRegistry;
import phex.gui.tabs.library.LibraryNode;
import phex.servent.Servent;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.Localizer;

public class SharingTreeModel
implements TreeModel {
    private final SharedFilesService fileService;
    private final FileFilter dirFilter = new DirectoryOnlyFileFilter();
    protected final EventListenerList listenerList = new EventListenerList();
    private final RootTreeNode root;
    private final FileSystemView fsv;

    public SharingTreeModel() {
        Servent servent = Servent.getInstance();
        this.fileService = servent.getSharedFilesService();
        this.root = new RootTreeNode();
        this.fsv = FileSystemView.getFileSystemView();
        this.updateFileSystem();
        servent.getEventService().processAnnotations(this);
    }

    public void updateFileSystem() {
        this.root.updateChilds();
        this.fireTreeStructureChanged();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    @Override
    public Object getChild(Object node, int index) {
        return ((TreeNode)node).getChildAt(index);
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    private void fireTreeStructureChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, new TreePath(new Object[]{this.root, this.root.childs[0]}));
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    @EventTopicSubscriber(topic="phex:share/update")
    public void onShareUpdateEvent(String topic, Object event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SharingTreeModel.this.updateFileSystem();
            }
        });
    }

    private class SharedDirectoryTreeNode
    implements TreeNode,
    LibraryNode {
        private SharedDirectory sharedDirectory;
        private TreeNode[] childs;
        private TreeNode parent;

        public SharedDirectoryTreeNode(SharedDirectory dir, TreeNode parent) {
            this.sharedDirectory = dir;
            this.parent = parent;
        }

        @Override
        public String getDisplayName() {
            return SharingTreeModel.this.fsv.getSystemDisplayName(this.sharedDirectory.getSystemFile());
        }

        @Override
        public String getTooltipText() {
            return this.sharedDirectory.getSystemFile().getAbsolutePath();
        }

        @Override
        public Icon getDisplayIcon() {
            try {
                return SharingTreeModel.this.fsv.getSystemIcon(this.sharedDirectory.getSystemFile());
            }
            catch (NullPointerException exp) {
                GUIActionPerformer.rescanSharedFiles();
                return null;
            }
        }

        @Override
        public File getSystemFile() {
            return this.sharedDirectory.getSystemFile();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            this.initChilds();
            return this.childs[childIndex];
        }

        @Override
        public int getChildCount() {
            this.initChilds();
            return this.childs.length;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            this.initChilds();
            return this.childs.length == 0;
        }

        @Override
        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] != node) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            throw new UnsupportedOperationException();
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }

        private void initChilds() {
            if (this.childs != null) {
                return;
            }
            ArrayList<SharedDirectoryTreeNode> childsList = new ArrayList<SharedDirectoryTreeNode>();
            File dir = this.sharedDirectory.getSystemFile();
            File[] childDirs = dir.listFiles(SharingTreeModel.this.dirFilter);
            if (childDirs != null) {
                for (int i = 0; i < childDirs.length; ++i) {
                    SharedDirectory sharedDir = SharingTreeModel.this.fileService.getSharedDirectory(childDirs[i]);
                    if (sharedDir == null || sharedDir.getType() != 1) continue;
                    childsList.add(new SharedDirectoryTreeNode(sharedDir, this));
                }
            }
            this.childs = childsList.toArray(new TreeNode[childsList.size()]);
        }
    }

    private class SharedFilesTreeNode
    implements TreeNode,
    LibraryNode {
        private TreeNode[] childs;

        public SharedFilesTreeNode() {
            this.updateChilds();
        }

        @Override
        public String getDisplayName() {
            return Localizer.getString("LibraryTab_SharedFiles");
        }

        @Override
        public String getTooltipText() {
            return Localizer.getString("LibraryTab_SharedFiles");
        }

        @Override
        public Icon getDisplayIcon() {
            return GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.ShareFolder");
        }

        @Override
        public File getSystemFile() {
            return null;
        }

        public void updateChilds() {
            ArrayList<SharedDirectoryTreeNode> childsList = new ArrayList<SharedDirectoryTreeNode>();
            SharedDirectory[] sharedDirs = SharingTreeModel.this.fileService.getSharedDirectories();
            for (int i = 0; i < sharedDirs.length; ++i) {
                if (sharedDirs[i].getType() == 2) continue;
                File parent = sharedDirs[i].getSystemFile().getParentFile();
                SharedDirectory sharedDirectory = null;
                if (parent != null) {
                    sharedDirectory = SharingTreeModel.this.fileService.getSharedDirectory(parent);
                }
                if (parent != null && sharedDirectory != null && sharedDirectory.getType() != 2) continue;
                childsList.add(new SharedDirectoryTreeNode(sharedDirs[i], this));
            }
            this.childs = childsList.toArray(new TreeNode[childsList.size()]);
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.childs[childIndex];
        }

        @Override
        public int getChildCount() {
            return this.childs.length;
        }

        @Override
        public TreeNode getParent() {
            return SharingTreeModel.this.root;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] != node) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            throw new UnsupportedOperationException();
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }
    }

    private class RootTreeNode
    implements TreeNode {
        private TreeNode[] childs;

        public RootTreeNode() {
            this.childs = new TreeNode[]{new SharedFilesTreeNode()};
            this.updateChilds();
        }

        public void updateChilds() {
            ((SharedFilesTreeNode)this.childs[0]).updateChilds();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.childs[childIndex];
        }

        @Override
        public int getChildCount() {
            return this.childs.length;
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] != node) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            throw new UnsupportedOperationException();
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }
    }
}

