/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeCellRenderer;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconPack;
import phex.gui.common.ImageFilterUtils;
import phex.gui.tabs.library.HalfGrayedImageFilter;
import phex.servent.Servent;
import phex.share.SharedDirectory;

public class FileSystemTreeRenderer
extends DefaultTreeCellRenderer {
    private Icon sharedOpenIcon;
    private Icon sharedClosedIcon;
    private Icon unsharedOpenIcon;
    private Icon unsharedClosedIcon;
    private Icon partlySharedOpenIcon;
    private Icon partlySharedClosedIcon;
    private FileSystemView fsv;

    public FileSystemTreeRenderer() {
        IconPack factory = GUIRegistry.getInstance().getPlafIconPack();
        this.setOpenIcon(factory.getIcon("Library.FileTreeOpen"));
        this.setClosedIcon(factory.getIcon("Library.FileTreeClosed"));
        this.sharedOpenIcon = factory.getIcon("Library.FileTreeClosed");
        this.sharedClosedIcon = factory.getIcon("Library.FileTreeClosed");
        this.partlySharedOpenIcon = HalfGrayedImageFilter.createHalfGrayIcon(factory.getIcon("Library.FileTreeClosed"));
        this.partlySharedClosedIcon = HalfGrayedImageFilter.createHalfGrayIcon(factory.getIcon("Library.FileTreeClosed"));
        this.unsharedOpenIcon = ImageFilterUtils.createGrayIcon(factory.getIcon("Library.FileTreeClosed"));
        this.unsharedClosedIcon = ImageFilterUtils.createGrayIcon(factory.getIcon("Library.FileTreeClosed"));
        this.fsv = FileSystemView.getFileSystemView();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value == tree.getModel().getRoot()) {
            this.setIcon(null);
            this.setText("");
            this.setMinimumSize(new Dimension(0, 0));
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
            return this;
        }
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.setMaximumSize(null);
        File file = (File)value;
        String fname = this.fsv.getSystemDisplayName(file);
        if (fname == null || fname.length() == 0) {
            fname = file.getPath();
        }
        this.setText(fname);
        SharedDirectory sharedDir = Servent.getInstance().getSharedFilesService().getSharedDirectory(file);
        if (sharedDir == null) {
            Icon icon = this.fsv.getSystemIcon(file);
            this.setIcon(ImageFilterUtils.createGrayIcon(icon));
        } else if (sharedDir.getType() == 2) {
            Icon icon = this.fsv.getSystemIcon(file);
            this.setIcon(HalfGrayedImageFilter.createHalfGrayIcon(icon));
        } else if (sharedDir.getType() == 1) {
            if (expanded) {
                this.setIcon(this.sharedOpenIcon);
            } else {
                this.setIcon(this.sharedClosedIcon);
            }
        }
        return this;
    }
}

