/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phex.utils.Localizer;

public abstract class OptionsSettingsPane
extends JPanel {
    protected static final String NUMBER_FORMAT_ERROR_KEY = "NumberFormatError";
    protected static final String IS_INPUT_VALID_KEY = "IsInputValid";
    protected static final String SAVE_CONFIG_TRIGGER = "SaveConfigTrigger";
    protected static final String RESCAN_FILES_TRIGGER = "RescanFilesTrigger";
    private final String treeRepresentation;
    private boolean isPreparedForDisplay;

    public OptionsSettingsPane(String aTreeRepresentation) {
        this.treeRepresentation = aTreeRepresentation;
        this.isPreparedForDisplay = false;
    }

    public void prepareForDisplay() {
        if (!this.isPreparedForDisplay) {
            this.prepareComponent();
            this.isPreparedForDisplay = true;
        }
    }

    public boolean isSettingsPaneDisplayed() {
        return this.isPreparedForDisplay;
    }

    protected abstract void prepareComponent();

    public void checkInput(HashMap<String, Object> inputDic) {
        this.setInputValid(inputDic, true);
    }

    public void displayErrorMessage(HashMap<String, Object> inputDic) {
    }

    public void saveAndApplyChanges(HashMap<String, Object> inputDic) {
    }

    protected String getOptionTreeRepresentation() {
        return this.treeRepresentation;
    }

    protected void setInputValid(HashMap<String, Object> inputDic, boolean isValid) {
        inputDic.put(IS_INPUT_VALID_KEY, isValid);
    }

    public boolean isInputValid(HashMap<String, Object> inputDic) {
        Boolean status = (Boolean)inputDic.get(IS_INPUT_VALID_KEY);
        return status;
    }

    public static void triggerSharedFilesRescan(HashMap<String, Object> inputDic) {
        if (!inputDic.containsKey(RESCAN_FILES_TRIGGER)) {
            inputDic.put(RESCAN_FILES_TRIGGER, RESCAN_FILES_TRIGGER);
        }
    }

    public static boolean isSharedFilesRescanTriggered(HashMap<String, Object> inputDic) {
        return inputDic.containsKey(RESCAN_FILES_TRIGGER);
    }

    protected void displayNumberFormatError(HashMap<String, Object> inputDic) {
        Component comp = (Component)inputDic.get(NUMBER_FORMAT_ERROR_KEY);
        if (comp == null) {
            return;
        }
        comp.requestFocus();
        if (comp instanceof JTextField) {
            ((JTextField)comp).selectAll();
        }
        JOptionPane.showMessageDialog(this, Localizer.getString("WrongNumberFormat"), Localizer.getString("FormatError"), 0);
    }
}

