/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTextField;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.prefs.core.I2PPrefs;
import phex.utils.Localizer;

public class I2PPane
extends OptionsSettingsPane {
    private static final String I2CP_PORT_KEY = "I2CPPort";
    private static final String INBOUND_LENGTH_KEY = "InboundLength";
    private static final String OUTBOUND_LENGTH_KEY = "OutboundLength";
    private static final String INBOUND_LENGTH_VARIANCE_KEY = "InboundLengthVariance";
    private static final String OUTBOUND_LENGTH_VARIANCE_KEY = "OutboundLengthVariance";
    private static final String INBOUND_QUANTITY_KEY = "InboundQuantity";
    private static final String OUTBOUND_QUANTITY_KEY = "OutboundQuantity";
    private static final String INBOUND_BACKUP_QUANTITY_KEY = "InboundBackupQuantity";
    private static final String OUTBOUND_BACKUP_QUANTITY_KEY = "OutboundBackupQuantity";
    private JLabel i2cpHostLabel;
    private JTextField i2cpHostTF;
    private JLabel i2cpPortLabel;
    private IntegerTextField i2cpPortTF;
    private JLabel inboundLengthLabel;
    private JTextField inboundLengthTF;
    private JLabel outboundLengthLabel;
    private JTextField outboundLengthTF;
    private JLabel inboundLengthVarianceLabel;
    private JTextField inboundLengthVarianceTF;
    private JLabel outboundLengthVarianceLabel;
    private JTextField outboundLengthVarianceTF;
    private JLabel inboundQuantityLabel;
    private JTextField inboundQuantityTF;
    private JLabel outboundQuantityLabel;
    private JTextField outboundQuantityTF;
    private JLabel inboundBackupQuantityLabel;
    private JTextField inboundBackupQuantityTF;
    private JLabel outboundBackupQuantityLabel;
    private JTextField outboundBackupQuantityTF;

    public I2PPane() {
        super("I2P");
    }

    @Override
    protected void prepareComponent() {
        FormLayout layout = new FormLayout("10dlu, right:d, 2dlu, 50dlu, 10dlu, right:d, 2dlu, 50dlu, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu");
        layout.setRowGroups(new int[][]{{3, 5, 9, 11, 13, 15, 21}});
        layout.setColumnGroups(new int[][]{{4, 8}, {2, 6}});
        this.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, this);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("I2CPSettings"), cc.xywh(1, 1, 9, 1));
        this.i2cpHostLabel = builder.addLabel(Localizer.getString("I2CPHost") + ": ", cc.xy(2, 3));
        this.i2cpHostTF = new JTextField(I2PPrefs.I2CPHost.get(), 15);
        builder.add((Component)this.i2cpHostTF, cc.xy(4, 3));
        this.i2cpPortLabel = builder.addLabel(Localizer.getString(I2CP_PORT_KEY) + ": ", cc.xy(6, 3));
        this.i2cpPortTF = new IntegerTextField(I2PPrefs.I2CPPort.get().toString(), 5, 5);
        builder.add((Component)this.i2cpPortTF, cc.xy(8, 3));
        builder.addSeparator(Localizer.getString("I2PTunnelSettings"), cc.xywh(1, 5, 9, 1));
        this.inboundLengthLabel = builder.addLabel(Localizer.getString(INBOUND_LENGTH_KEY) + ": ", cc.xy(2, 9));
        this.inboundLengthTF = new IntegerTextField(I2PPrefs.InboundLength.get().toString(), 1, 1);
        builder.add((Component)this.inboundLengthTF, cc.xy(4, 9));
        this.outboundLengthLabel = builder.addLabel(Localizer.getString(OUTBOUND_LENGTH_KEY) + ": ", cc.xy(6, 9));
        this.outboundLengthTF = new IntegerTextField(I2PPrefs.OutboundLength.get().toString(), 1, 1);
        builder.add((Component)this.outboundLengthTF, cc.xy(8, 9));
        this.inboundLengthVarianceLabel = builder.addLabel(Localizer.getString(INBOUND_LENGTH_VARIANCE_KEY) + ": ", cc.xy(2, 11));
        this.inboundLengthVarianceTF = new IntegerTextField(I2PPrefs.InboundLengthVariance.get().toString(), 1, 1);
        builder.add((Component)this.inboundLengthVarianceTF, cc.xy(4, 11));
        this.outboundLengthVarianceLabel = builder.addLabel(Localizer.getString(OUTBOUND_LENGTH_VARIANCE_KEY) + ": ", cc.xy(6, 11));
        this.outboundLengthVarianceTF = new IntegerTextField(I2PPrefs.OutboundLengthVariance.get().toString(), 1, 1);
        builder.add((Component)this.outboundLengthVarianceTF, cc.xy(8, 11));
        this.inboundQuantityLabel = builder.addLabel(Localizer.getString(INBOUND_QUANTITY_KEY) + ": ", cc.xy(2, 13));
        this.inboundQuantityTF = new IntegerTextField(I2PPrefs.InboundQuantity.get().toString(), 1, 1);
        builder.add((Component)this.inboundQuantityTF, cc.xy(4, 13));
        this.outboundQuantityLabel = builder.addLabel(Localizer.getString(OUTBOUND_QUANTITY_KEY) + ": ", cc.xy(6, 13));
        this.outboundQuantityTF = new IntegerTextField(I2PPrefs.OutboundQuantity.get().toString(), 1, 1);
        builder.add((Component)this.outboundQuantityTF, cc.xy(8, 13));
        this.inboundBackupQuantityLabel = builder.addLabel(Localizer.getString(INBOUND_BACKUP_QUANTITY_KEY) + ": ", cc.xy(2, 15));
        this.inboundBackupQuantityTF = new IntegerTextField(I2PPrefs.InboundBackupQuantity.get().toString(), 1, 1);
        builder.add((Component)this.inboundBackupQuantityTF, cc.xy(4, 15));
        this.outboundBackupQuantityLabel = builder.addLabel(Localizer.getString(OUTBOUND_BACKUP_QUANTITY_KEY) + ": ", cc.xy(6, 15));
        this.outboundBackupQuantityTF = new IntegerTextField(I2PPrefs.OutboundBackupQuantity.get().toString(), 1, 1);
        builder.add((Component)this.outboundBackupQuantityTF, cc.xy(8, 15));
        this.refreshEnableState();
    }

    public void checkInput(HashMap inputDic) {
        try {
            Integer i2cpPort = new Integer(this.i2cpPortTF.getText());
            inputDic.put(I2CP_PORT_KEY, i2cpPort);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        try {
            Integer inboundLength = new Integer(this.inboundLengthTF.getText());
            inputDic.put(INBOUND_LENGTH_KEY, inboundLength);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        try {
            Integer outboundLength = new Integer(this.outboundLengthTF.getText());
            inputDic.put(OUTBOUND_LENGTH_KEY, outboundLength);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        try {
            Integer inboundLengthVariance = new Integer(this.inboundLengthVarianceTF.getText());
            inputDic.put(INBOUND_LENGTH_VARIANCE_KEY, inboundLengthVariance);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        try {
            Integer outboundLengthVariance = new Integer(this.outboundLengthVarianceTF.getText());
            inputDic.put(OUTBOUND_LENGTH_VARIANCE_KEY, outboundLengthVariance);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        try {
            Integer inboundQuantity = new Integer(this.inboundQuantityTF.getText());
            inputDic.put(INBOUND_QUANTITY_KEY, inboundQuantity);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        try {
            Integer outboundQuantity = new Integer(this.outboundQuantityTF.getText());
            inputDic.put(OUTBOUND_QUANTITY_KEY, outboundQuantity);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        try {
            Integer inboundBackupQuantity = new Integer(this.inboundBackupQuantityTF.getText());
            inputDic.put(INBOUND_BACKUP_QUANTITY_KEY, inboundBackupQuantity);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        try {
            Integer outboundBackupQuantity = new Integer(this.outboundBackupQuantityTF.getText());
            inputDic.put(OUTBOUND_BACKUP_QUANTITY_KEY, outboundBackupQuantity);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setInputValid(inputDic, true);
    }

    public void displayErrorMessage(HashMap inputDic) {
        if (inputDic.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(inputDic);
        }
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        String i2cpHost = this.i2cpHostTF.getText();
        I2PPrefs.I2CPHost.set(i2cpHost);
        Integer i2cpPortInt = (Integer)inputDic.get(I2CP_PORT_KEY);
        int i2cpPort = 7654;
        if (i2cpPortInt != null) {
            i2cpPort = i2cpPortInt;
        }
        I2PPrefs.I2CPPort.set(new Integer(i2cpPort));
        Integer inboundLengthInt = (Integer)inputDic.get(INBOUND_LENGTH_KEY);
        int inboundLength = 1;
        if (inboundLengthInt != null) {
            inboundLength = inboundLengthInt;
        }
        I2PPrefs.InboundLength.set(new Integer(inboundLength));
        Integer outboundLengthInt = (Integer)inputDic.get(OUTBOUND_LENGTH_KEY);
        int outboundLength = 1;
        if (outboundLengthInt != null) {
            outboundLength = outboundLengthInt;
        }
        I2PPrefs.OutboundLength.set(new Integer(outboundLength));
        Integer inboundLengthVarianceInt = (Integer)inputDic.get(INBOUND_LENGTH_VARIANCE_KEY);
        int inboundLengthVariance = 1;
        if (inboundLengthVarianceInt != null) {
            inboundLengthVariance = inboundLengthVarianceInt;
        }
        I2PPrefs.InboundLengthVariance.set(new Integer(inboundLengthVariance));
        Integer outboundLengthVarianceInt = (Integer)inputDic.get(OUTBOUND_LENGTH_VARIANCE_KEY);
        int outboundLengthVariance = 1;
        if (outboundLengthVarianceInt != null) {
            outboundLengthVariance = outboundLengthVarianceInt;
        }
        I2PPrefs.OutboundLengthVariance.set(new Integer(outboundLengthVariance));
        Integer inboundQuantityInt = (Integer)inputDic.get(INBOUND_QUANTITY_KEY);
        int inboundQuantity = 2;
        if (inboundQuantityInt != null) {
            inboundQuantity = inboundQuantityInt;
        }
        I2PPrefs.InboundQuantity.set(new Integer(inboundQuantity));
        Integer outboundQuantityInt = (Integer)inputDic.get(OUTBOUND_QUANTITY_KEY);
        int outboundQuantity = 2;
        if (outboundQuantityInt != null) {
            outboundQuantity = outboundQuantityInt;
        }
        I2PPrefs.OutboundQuantity.set(new Integer(outboundQuantity));
        Integer inboundBackupQuantityInt = (Integer)inputDic.get(INBOUND_BACKUP_QUANTITY_KEY);
        int inboundBackupQuantity = 0;
        if (inboundBackupQuantityInt != null) {
            inboundBackupQuantity = inboundBackupQuantityInt;
        }
        I2PPrefs.InboundBackupQuantity.set(new Integer(inboundBackupQuantity));
        Integer outboundBackupQuantityInt = (Integer)inputDic.get(OUTBOUND_BACKUP_QUANTITY_KEY);
        int outboundBackupQuantity = 0;
        if (outboundBackupQuantityInt != null) {
            outboundBackupQuantity = outboundBackupQuantityInt;
        }
        I2PPrefs.OutboundBackupQuantity.set(new Integer(outboundBackupQuantity));
    }

    private void refreshEnableState() {
    }

    class CheckboxActionListener
    implements ActionListener {
        CheckboxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            I2PPane.this.refreshEnableState();
        }
    }
}

