/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import phex.common.log.NLogger;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconPack;
import phex.gui.common.LookAndFeelFailedException;
import phex.gui.common.LookAndFeelUtils;
import phex.gui.common.MainFrame;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.gui.prefs.InterfacePrefs;
import phex.gui.renderer.LAFListCellRenderer;
import phex.gui.renderer.LAFThemeListCellRenderer;
import phex.gui.tabs.search.SearchTab;
import phex.utils.Localizer;
import phex.utils.StringUtils;

public class GeneralUIPane
extends OptionsSettingsPane {
    private static final String INSTANCIATED_LAF_KEY = "InstanciatedLAF";
    private static final String INSTANCIATED_THEME_KEY = "InstanciatedLAFTheme";
    private static final String LAF_ERROR_KEY = "LAFError";
    private static final String LAF_NOT_SUPPORTED = "LAFNotSupported";
    private static final String LAF_NOT_FOUND = "LAFNotFound";
    private static final String LAF_ACCESS_ERROR = "LAFAccessError";
    private static final String LAF_INSTANTIATION_ERROR = "LAFInstantiationError";
    private static final String THEME_NOT_FOUND = "ThemeNotFound";
    private static final String THEME_ACCESS_ERROR = "ThemeAccessError";
    private static final String THEME_INSTANTIATION_ERROR = "ThemeInstantiationError";
    private GUIRegistry guiRegistry = GUIRegistry.getInstance();
    private JComboBox lafBox;
    private DefaultComboBoxModel themeModel;
    private JComboBox themeBox;
    private JComboBox iconPackBox;
    private JCheckBox displayTooltipChkbx;
    private JCheckBox showTableHorizontalLinesChkbx;
    private JCheckBox showTableVerticalLinesChkbx;
    private JCheckBox minimizeWhenClosingChkbx;

    public GeneralUIPane() {
        super("General");
    }

    @Override
    public void checkInput(HashMap<String, Object> inputDic) {
        inputDic.remove(INSTANCIATED_LAF_KEY);
        inputDic.remove(LAF_ERROR_KEY);
        inputDic.remove(INSTANCIATED_THEME_KEY);
        UIManager.LookAndFeelInfo lafInfo = (UIManager.LookAndFeelInfo)this.lafBox.getSelectedItem();
        try {
            Class<?> lnfClass = Class.forName(lafInfo.getClassName());
            LookAndFeel laf = (LookAndFeel)lnfClass.newInstance();
            if (!laf.isSupportedLookAndFeel()) {
                inputDic.put(LAF_ERROR_KEY, LAF_NOT_SUPPORTED);
                this.setInputValid(inputDic, false);
                return;
            }
            inputDic.put(INSTANCIATED_LAF_KEY, laf);
        }
        catch (ClassNotFoundException exp) {
            inputDic.put(LAF_ERROR_KEY, LAF_NOT_FOUND);
            this.setInputValid(inputDic, false);
            return;
        }
        catch (IllegalAccessException exp) {
            inputDic.put(LAF_ERROR_KEY, LAF_ACCESS_ERROR);
            this.setInputValid(inputDic, false);
            return;
        }
        catch (InstantiationException exp) {
            inputDic.put(LAF_ERROR_KEY, LAF_INSTANTIATION_ERROR);
            this.setInputValid(inputDic, false);
            return;
        }
        LookAndFeelUtils.ThemeInfo themeInfo = (LookAndFeelUtils.ThemeInfo)this.themeBox.getSelectedItem();
        LookAndFeelUtils.ThemeInfo currentTheme = LookAndFeelUtils.getCurrentTheme(UIManager.getLookAndFeel().getClass().getName());
        if (themeInfo != null && currentTheme != null && themeInfo.getClassName().equals(currentTheme.getClassName())) {
            themeInfo = null;
        }
        if (themeInfo != null) {
            try {
                Class<?> themeClass = Class.forName(themeInfo.getClassName());
                Object theme = themeClass.newInstance();
                inputDic.put(INSTANCIATED_THEME_KEY, theme);
            }
            catch (ClassNotFoundException exp) {
                inputDic.put(LAF_ERROR_KEY, THEME_NOT_FOUND);
                this.setInputValid(inputDic, false);
                return;
            }
            catch (IllegalAccessException exp) {
                inputDic.put(LAF_ERROR_KEY, THEME_ACCESS_ERROR);
                this.setInputValid(inputDic, false);
                return;
            }
            catch (InstantiationException exp) {
                inputDic.put(LAF_ERROR_KEY, THEME_INSTANTIATION_ERROR);
                this.setInputValid(inputDic, false);
                return;
            }
        }
        this.setInputValid(inputDic, true);
    }

    @Override
    public void displayErrorMessage(HashMap<String, Object> inputDic) {
        Object value = inputDic.get(LAF_ERROR_KEY);
        if (value != null) {
            JOptionPane.showMessageDialog(this, Localizer.getString((String)value), Localizer.getString(LAF_ERROR_KEY), 0);
        }
    }

    @Override
    public void saveAndApplyChanges(HashMap<String, Object> inputDic) {
        IconPack currentPack;
        Object theme;
        LookAndFeel laf = (LookAndFeel)inputDic.get(INSTANCIATED_LAF_KEY);
        if (!UIManager.getLookAndFeel().getClass().getName().equals(laf.getClass().getName())) {
            try {
                LookAndFeelUtils.setLookAndFeel(laf);
            }
            catch (LookAndFeelFailedException exp) {
                JOptionPane.showMessageDialog(this.guiRegistry.getMainFrame(), "Error loading Look & Feel " + laf.getName(), "Error", 0);
            }
        }
        if ((theme = inputDic.get(INSTANCIATED_THEME_KEY)) != null) {
            LookAndFeelUtils.setCurrentTheme(laf.getClass().getName(), theme);
        }
        boolean triggerUIUpdate = false;
        String iconPackName = (String)this.iconPackBox.getSelectedItem();
        if (!StringUtils.isEmpty(iconPackName) && !iconPackName.equals((currentPack = this.guiRegistry.getPlafIconPack()).getName())) {
            this.guiRegistry.setPlafIconPack(IconPack.createIconPack(iconPackName));
            triggerUIUpdate = true;
        }
        boolean tooltip = this.displayTooltipChkbx.isSelected();
        if (InterfacePrefs.DisplayTooltip.get() != tooltip) {
            InterfacePrefs.DisplayTooltip.set(tooltip);
            ToolTipManager.sharedInstance().setEnabled(tooltip);
        }
        boolean minimizeOnClose = this.minimizeWhenClosingChkbx.isSelected();
        InterfacePrefs.MinimizeToBackground.set(minimizeOnClose);
        boolean showHorizontalLines = this.showTableHorizontalLinesChkbx.isSelected();
        if (this.guiRegistry.getShowTableHorizontalLines() != showHorizontalLines) {
            this.guiRegistry.setShowTableHorizontalLines(showHorizontalLines);
            triggerUIUpdate = true;
        }
        boolean showVerticalLines = this.showTableVerticalLinesChkbx.isSelected();
        if (this.guiRegistry.getShowTableVerticalLines() != showVerticalLines) {
            this.guiRegistry.setShowTableVerticalLines(showVerticalLines);
            triggerUIUpdate = true;
        }
        if (triggerUIUpdate) {
            GUIUtils.updateComponentsUI();
        }
    }

    @Override
    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        this.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("10dlu, d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 5dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 5dlu, p");
        layout.setRowGroups(new int[][]{{3, 5, 7, 9, 11}});
        contentPanel.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("GeneralUserInterfaceSettings"), cc.xywh(1, 1, 5, 1));
        JLabel lafLabel = builder.addLabel(Localizer.getString("LookAndFeel"), cc.xy(2, 3));
        lafLabel.setToolTipText(Localizer.getString("TTTLookAndFeel"));
        UIManager.LookAndFeelInfo[] lafs = LookAndFeelUtils.getAvailableLAFs();
        this.lafBox = new JComboBox<UIManager.LookAndFeelInfo>(lafs);
        this.lafBox.addItemListener(new LAFItemListener());
        int currentLAFIndex = this.determineCurrentLAFIndex(lafs);
        this.lafBox.setSelectedIndex(currentLAFIndex);
        this.lafBox.setRenderer(new LAFListCellRenderer());
        this.lafBox.setToolTipText(Localizer.getString("TTTLookAndFeel"));
        builder.add((Component)this.lafBox, cc.xy(4, 3));
        JLabel themeLabel = builder.addLabel(Localizer.getString("ColorTheme"), cc.xy(2, 5));
        themeLabel.setToolTipText(Localizer.getString("TTTColorTheme"));
        this.themeModel = new DefaultComboBoxModel();
        this.themeBox = new JComboBox(this.themeModel);
        this.themeBox.setToolTipText(Localizer.getString("TTTColorTheme"));
        builder.add((Component)this.themeBox, cc.xy(4, 5));
        UIManager.LookAndFeelInfo laf = (UIManager.LookAndFeelInfo)this.lafBox.getSelectedItem();
        this.updateThemes(laf);
        this.themeBox.setRenderer(new LAFThemeListCellRenderer());
        JLabel iconPackLabel = builder.addLabel(Localizer.getString("UISettings_IconPack"), cc.xy(2, 7));
        iconPackLabel.setToolTipText(Localizer.getString("UISettings_TTTIconPack"));
        DefaultComboBoxModel<Object> iconPackModel = new DefaultComboBoxModel<Object>(IconPack.getAllIconPackIds().toArray());
        this.iconPackBox = new JComboBox<Object>(iconPackModel);
        this.iconPackBox.setToolTipText(Localizer.getString("UISettings_TTTIconPack"));
        this.iconPackBox.setSelectedItem(GUIRegistry.getInstance().getPlafIconPack().getName());
        builder.add((Component)this.iconPackBox, cc.xy(4, 7));
        this.displayTooltipChkbx = new JCheckBox(Localizer.getString("DisplayTooltipText"), (boolean)InterfacePrefs.DisplayTooltip.get());
        this.displayTooltipChkbx.setToolTipText(Localizer.getString("TTTDisplayTooltipText"));
        builder.add((Component)this.displayTooltipChkbx, cc.xywh(2, 9, 3, 1));
        this.showTableHorizontalLinesChkbx = new JCheckBox(Localizer.getString("ShowTableHorizontalLines"), this.guiRegistry.getShowTableHorizontalLines());
        this.showTableHorizontalLinesChkbx.setToolTipText(Localizer.getString("TTTShowTableHorizontalLines"));
        builder.add((Component)this.showTableHorizontalLinesChkbx, cc.xywh(2, 11, 3, 1));
        this.showTableVerticalLinesChkbx = new JCheckBox(Localizer.getString("ShowTableVerticalLines"), this.guiRegistry.getShowTableVerticalLines());
        this.showTableVerticalLinesChkbx.setToolTipText(Localizer.getString("TTTShowTableVerticalLines"));
        builder.add((Component)this.showTableVerticalLinesChkbx, cc.xywh(2, 13, 3, 1));
        String backgroundText = GUIRegistry.getInstance().getDesktopIndicator() != null ? Localizer.getString("WhenClosingMinToSysTray") : Localizer.getString("WhenClosingMinToBackground");
        this.minimizeWhenClosingChkbx = new JCheckBox(backgroundText, (boolean)InterfacePrefs.MinimizeToBackground.get());
        builder.add((Component)this.minimizeWhenClosingChkbx, cc.xywh(2, 15, 3, 1));
        JButton clearSearchHistory = new JButton(Localizer.getString("UISettings_ClearSearchHistory"));
        clearSearchHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
                SearchTab searchTab = (SearchTab)mainFrame.getTab(1101);
                searchTab.clearSearchHistory();
            }
        });
        builder.add((Component)clearSearchHistory, cc.xywh(2, 17, 3, 1, "left,center"));
    }

    private int determineCurrentLAFIndex(UIManager.LookAndFeelInfo[] lafs) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        String lafClassName = laf.getClass().getName();
        for (int i = 0; i < lafs.length; ++i) {
            if (!lafClassName.equals(lafs[i].getClassName())) continue;
            return i;
        }
        return -1;
    }

    private int determineCurrentThemeIndex(UIManager.LookAndFeelInfo lafs) {
        LookAndFeelUtils.ThemeInfo themeInfo = LookAndFeelUtils.getCurrentTheme(lafs.getClassName());
        if (themeInfo == null) {
            return -1;
        }
        return this.themeModel.getIndexOf(themeInfo);
    }

    private void updateThemes(UIManager.LookAndFeelInfo lafInfo) {
        LookAndFeelUtils.ThemeInfo[] themes = LookAndFeelUtils.getAvailableThemes(lafInfo.getClassName());
        this.themeModel = new DefaultComboBoxModel<LookAndFeelUtils.ThemeInfo>(themes);
        if (this.themeBox != null) {
            this.themeBox.setModel(this.themeModel);
            int currentThemeIndex = this.determineCurrentThemeIndex(lafInfo);
            this.themeBox.setSelectedIndex(currentThemeIndex);
        }
    }

    private class LAFItemListener
    implements ItemListener {
        private LAFItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                UIManager.LookAndFeelInfo lafInfo;
                if (e.getStateChange() == 1 && (lafInfo = (UIManager.LookAndFeelInfo)e.getItem()) != null) {
                    GeneralUIPane.this.updateThemes(lafInfo);
                }
            }
            catch (Throwable th) {
                NLogger.error(LAFItemListener.class, (Object)th, th);
            }
        }
    }
}

