/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.configwizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import phex.common.log.NLogger;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.configwizard.BandwidthPanel;
import phex.gui.dialogs.configwizard.ContentCommunityPanel;
import phex.gui.dialogs.configwizard.DirectoryPanel;
import phex.gui.dialogs.configwizard.GoodbyePanel;
import phex.gui.dialogs.configwizard.SharingPanel;
import phex.gui.dialogs.configwizard.WelcomePanel;
import phex.gui.dialogs.options.OptionsDialog;
import phex.gui.prefs.UpdatePrefs;
import phex.utils.Localizer;

public class ConfigurationWizardDialog
extends JDialog {
    private static final int WELCOME_PAGE = 1;
    private static final int BANDWIDTH_PAGE = 2;
    private static final int DIRECTORY_PAGE = 3;
    private static final int CONTENTCOMMUNITY_PAGE = 4;
    private static final int SHARING_PAGE = 5;
    private static final int GOODBYE_PAGE = 6;
    private JPanel wizardContentPanel;
    private WelcomePanel welcomePanel;
    private BandwidthPanel bandwidthPanel;
    private DirectoryPanel directoryPanel;
    private SharingPanel sharingPanel;
    private ContentCommunityPanel contentCommunityPanel;
    private GoodbyePanel goodbyePanel;
    private int currentPage = 1;
    private JButton finishBtn;
    private JButton backBtn;
    private JButton nextBtn;

    public ConfigurationWizardDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ConfigWizard_DialogTitle"), false);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, fill:d:grow, 4dlu", "p, p, 4dlu, fill:p:grow, 8dlu,p, 2dlu, p 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        DialogBanner banner = new DialogBanner(Localizer.getString("ConfigWizard_BannerHeader"), Localizer.getString("ConfigWizard_BannerSubHeader"));
        contentPB.add((Component)banner, cc.xywh(1, 1, columnCount, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, 2, columnCount, 1));
        this.wizardContentPanel = new JPanel(new GridLayout(1, 1));
        contentPB.add((Component)this.wizardContentPanel, cc.xywh(2, 4, 1, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
        this.backBtn = new JButton(Localizer.getString("WizardDialog_Back"));
        this.backBtn.addActionListener(new BackBtnListener());
        this.nextBtn = new JButton(Localizer.getString("WizardDialog_Next"));
        this.nextBtn.setDefaultCapable(true);
        this.nextBtn.setRequestFocusEnabled(true);
        this.nextBtn.addActionListener(new NextBtnListener());
        this.finishBtn = new JButton(Localizer.getString("WizardDialog_Finish"));
        this.finishBtn.addActionListener(new FinishBtnListener());
        JButton cancelBtn = new JButton(Localizer.getString("WizardDialog_Cancel"));
        cancelBtn.addActionListener(closeEventHandler);
        JPanel btnPanel = ButtonBarFactory.buildWizardBar(this.backBtn, this.nextBtn, this.finishBtn, cancelBtn);
        contentPB.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.nextBtn);
        this.updatePage();
        this.pack();
        int height = Math.max(400, this.getHeight());
        this.setSize(height * 5 / 4, height);
        this.setLocationRelativeTo(this.getParent());
    }

    public void setFinishBtnEnabled(boolean state) {
        this.finishBtn.setEnabled(state);
    }

    private void closeDialog() {
        UpdatePrefs.ShowConfigWizard.set(Boolean.FALSE);
        this.setVisible(false);
        this.dispose();
    }

    private void updatePage() {
        this.wizardContentPanel.removeAll();
        JPanel newPage = null;
        switch (this.currentPage) {
            case 1: {
                if (this.welcomePanel == null) {
                    this.welcomePanel = new WelcomePanel(this);
                }
                newPage = this.welcomePanel;
                this.backBtn.setEnabled(false);
                this.nextBtn.setEnabled(true);
                break;
            }
            case 2: {
                if (this.bandwidthPanel == null) {
                    this.bandwidthPanel = new BandwidthPanel(this);
                }
                newPage = this.bandwidthPanel;
                this.backBtn.setEnabled(true);
                this.nextBtn.setEnabled(true);
                break;
            }
            case 3: {
                if (this.directoryPanel == null) {
                    this.directoryPanel = new DirectoryPanel(this);
                }
                newPage = this.directoryPanel;
                this.backBtn.setEnabled(true);
                this.nextBtn.setEnabled(true);
                break;
            }
            case 5: {
                if (this.sharingPanel == null) {
                    this.sharingPanel = new SharingPanel(this);
                }
                newPage = this.sharingPanel;
                this.nextBtn.setEnabled(true);
                this.backBtn.setEnabled(true);
                break;
            }
            case 4: {
                if (this.contentCommunityPanel == null) {
                    this.contentCommunityPanel = new ContentCommunityPanel(this);
                }
                newPage = this.contentCommunityPanel;
                this.nextBtn.setEnabled(true);
                this.backBtn.setEnabled(true);
                break;
            }
            case 6: {
                if (this.goodbyePanel == null) {
                    this.goodbyePanel = new GoodbyePanel(this);
                }
                newPage = this.goodbyePanel;
                this.nextBtn.setEnabled(false);
                this.backBtn.setEnabled(true);
            }
        }
        this.wizardContentPanel.add(newPage, "Center");
        this.wizardContentPanel.doLayout();
        this.wizardContentPanel.revalidate();
        this.wizardContentPanel.repaint();
        Dimension prefSize = this.getPreferredSize();
        Dimension currSize = this.getSize();
        if (prefSize.height > currSize.height) {
            int height = Math.max(prefSize.height, currSize.height);
            this.setSize(height * 5 / 4, height);
            this.doLayout();
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            ConfigurationWizardDialog.this.closeDialog();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigurationWizardDialog.this.closeDialog();
        }
    }

    private final class FinishBtnListener
    implements ActionListener {
        private FinishBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (ConfigurationWizardDialog.this.bandwidthPanel != null) {
                    ConfigurationWizardDialog.this.bandwidthPanel.saveSettings();
                }
                if (ConfigurationWizardDialog.this.directoryPanel != null) {
                    if (!ConfigurationWizardDialog.this.directoryPanel.checkInput()) {
                        ConfigurationWizardDialog.this.currentPage = 3;
                        ConfigurationWizardDialog.this.updatePage();
                        return;
                    }
                    ConfigurationWizardDialog.this.directoryPanel.saveSettings();
                }
                if (ConfigurationWizardDialog.this.contentCommunityPanel != null) {
                    ConfigurationWizardDialog.this.contentCommunityPanel.saveSettings();
                }
                boolean openOptions = false;
                if (ConfigurationWizardDialog.this.goodbyePanel != null) {
                    openOptions = ConfigurationWizardDialog.this.goodbyePanel.isOpenOptionsSelected();
                }
                ConfigurationWizardDialog.this.closeDialog();
                if (openOptions) {
                    OptionsDialog dialog = new OptionsDialog();
                    dialog.setVisible(true);
                }
            }
            catch (Throwable th) {
                NLogger.error(FinishBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class BackBtnListener
    implements ActionListener {
        private BackBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                switch (ConfigurationWizardDialog.this.currentPage) {
                    case 2: {
                        ConfigurationWizardDialog.this.currentPage = 1;
                        break;
                    }
                    case 3: {
                        ConfigurationWizardDialog.this.currentPage = 2;
                        break;
                    }
                    case 4: {
                        ConfigurationWizardDialog.this.currentPage = 3;
                        break;
                    }
                    case 5: {
                        ConfigurationWizardDialog.this.currentPage = 4;
                        break;
                    }
                    case 6: {
                        ConfigurationWizardDialog.this.currentPage = 5;
                    }
                }
                ConfigurationWizardDialog.this.updatePage();
            }
            catch (Throwable th) {
                NLogger.error(BackBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class NextBtnListener
    implements ActionListener {
        private NextBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                switch (ConfigurationWizardDialog.this.currentPage) {
                    case 1: {
                        ConfigurationWizardDialog.this.currentPage = 2;
                        break;
                    }
                    case 2: {
                        ConfigurationWizardDialog.this.currentPage = 3;
                        break;
                    }
                    case 3: {
                        if (!ConfigurationWizardDialog.this.directoryPanel.checkInput()) {
                            ConfigurationWizardDialog.this.currentPage = 3;
                            break;
                        }
                        ConfigurationWizardDialog.this.currentPage = 4;
                        break;
                    }
                    case 4: {
                        ConfigurationWizardDialog.this.currentPage = 5;
                        break;
                    }
                    case 5: {
                        ConfigurationWizardDialog.this.currentPage = 6;
                    }
                }
                ConfigurationWizardDialog.this.updatePage();
            }
            catch (Throwable th) {
                NLogger.error(NextBtnListener.class, (Object)th, th);
            }
        }
    }
}

