/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.commons.httpclient.URIException;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.update.UpdateCheckRunner;
import phex.update.UpdateDownloader;
import phex.utils.Localizer;
import phex.utils.VersionUtils;

public class UpdateNotificationDialog
extends JDialog {
    private UpdateCheckRunner updateChecker;
    private JCheckBox dontDisplayAgainChkBox;

    public UpdateNotificationDialog(UpdateCheckRunner aChecker) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("UpdateNotification_DialogTitle"), false);
        this.updateChecker = aChecker;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("2dlu, fill:d:grow, 2dlu", "p, p, 16dlu, fill:p:grow, 16dlu,p, 2dlu, p 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        DialogBanner banner = new DialogBanner(Localizer.getString("UpdateNotification_BannerHeader"), Localizer.getString("UpdateNotification_BannerSubHeader"));
        contentPB.add((Component)banner, cc.xywh(1, 1, columnCount, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, 2, columnCount, 1));
        JPanel notifyPanel = this.buildNotificationPanel();
        contentPB.add((Component)notifyPanel, cc.xy(2, 4, "center, center"));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
        JButton closeBtn = new JButton(Localizer.getString("Close"));
        closeBtn.addActionListener(closeEventHandler);
        JButton downloadBtn = new JButton(Localizer.getString("Download"));
        downloadBtn.setDefaultCapable(true);
        downloadBtn.setRequestFocusEnabled(true);
        downloadBtn.addActionListener(new DownloadBtnListener());
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(downloadBtn, closeBtn);
        contentPB.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(downloadBtn);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel buildNotificationPanel() {
        JPanel panel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("16dlu, d, 8dlu, right:d, 16dlu", "p, 8dlu, p");
        layout.setRowGroups(new int[][]{{1, 3}});
        PanelBuilder builder = new PanelBuilder(layout, panel);
        builder.addLabel(Localizer.getString("UpdateNotification_YourVersion"), cc.xy(2, 1));
        builder.addLabel(VersionUtils.getFullProgramVersion(), cc.xy(4, 1));
        String releaseVersion = this.updateChecker.getReleaseVersion();
        String betaVersion = this.updateChecker.getBetaVersion();
        if (releaseVersion != null) {
            builder.addLabel(Localizer.getString("UpdateNotification_AvailableStableVersion"), cc.xy(2, 3));
            JLabel label = builder.addLabel(releaseVersion, cc.xy(4, 3));
            label.setFont(label.getFont().deriveFont(1));
        } else if (betaVersion != null) {
            builder.addLabel(Localizer.getString("UpdateNotification_AvailableBetaVersion"), cc.xy(2, 3));
            JLabel label = builder.addLabel(betaVersion, cc.xy(4, 3));
            label.setFont(label.getFont().deriveFont(1));
        }
        return panel;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            UpdateNotificationDialog.this.closeDialog();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UpdateNotificationDialog.this.closeDialog();
        }
    }

    private final class DownloadBtnListener
    implements ActionListener {
        private DownloadBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UpdateDownloader.createUpdateDownload();
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            UpdateNotificationDialog.this.closeDialog();
        }
    }
}

