/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import phex.common.GnutellaNetwork;
import phex.gui.common.GUIRegistry;
import phex.gui.common.PlainMultiLinePanel;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.prefs.core.PhexCorePrefs;
import phex.prefs.core.PrivateNetworkConstants;
import phex.servent.Servent;
import phex.utils.Localizer;

public class SelectNetworkDialog
extends JDialog {
    private JComboBox networkCbx;
    private JCheckBox autoConnectChkbx;

    public SelectNetworkDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("SelectNet_SelectNetwork"), true);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SelectNetworkDialog.this.closeDialog(false);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("10dlu, right:d, 4dlu, max(200dlu;d):grow", "p, 3dlu, p:grow, 6dlu, p, 3dlu, p, 3dlu, p, 9dlu, p");
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        builder.addSeparator(Localizer.getString("SelectNet_SelectNetworkToJoin"), cc.xywh(1, 1, 4, 1));
        PlainMultiLinePanel multiLineText = new PlainMultiLinePanel(Localizer.getString("SelectNet_NetworkSelectionText"));
        builder.add((Component)multiLineText, cc.xywh(2, 3, 3, 1));
        this.networkCbx = new JComboBox();
        this.networkCbx.setEditable(true);
        this.networkCbx.addItem(PrivateNetworkConstants.DEFAULT_NETWORK_TO_USE);
        if (!PrivateNetworkConstants.DEFAULT_NETWORK_TO_USE.equals("<General Gnutella Network>")) {
            this.networkCbx.addItem("<General Gnutella Network>");
        }
        for (String item : NetworkPrefs.NetworkHistory.get()) {
            this.networkCbx.addItem(item);
        }
        Servent servent = Servent.getInstance();
        this.networkCbx.setSelectedItem(servent.getGnutellaNetwork().getName());
        builder.addLabel(Localizer.getString("SelectNet_NetworkName"), cc.xy(2, 5));
        builder.add((Component)this.networkCbx, cc.xy(4, 5));
        this.autoConnectChkbx = new JCheckBox(Localizer.getString("SelectNet_AutoConnectNetwork"), (boolean)ConnectionPrefs.AutoConnectOnStartup.get());
        builder.add((Component)this.autoConnectChkbx, cc.xywh(2, 9, 3, 1));
        ButtonActionHandler actionHandler = new ButtonActionHandler();
        JButton okButton = new JButton(Localizer.getString("OK"));
        okButton.setDefaultCapable(true);
        okButton.addActionListener(actionHandler);
        okButton.setActionCommand("OK");
        JButton cancelButton = new JButton(Localizer.getString("Cancel"));
        cancelButton.addActionListener(actionHandler);
        cancelButton.setActionCommand("CANCEL");
        JPanel buttonPanel = ButtonBarFactory.buildOKCancelBar(okButton, cancelButton);
        builder.add((Component)buttonPanel, cc.xywh(1, 11, 4, 1));
        contentPane.validate();
        contentPanel.doLayout();
        contentPanel.revalidate();
        this.doLayout();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog(boolean triggerSave) {
        if (triggerSave) {
            PhexCorePrefs.save(false);
            GnutellaNetwork network = GnutellaNetwork.getGnutellaNetworkFromString(NetworkPrefs.CurrentNetwork.get());
            Servent.getInstance().setGnutellaNetwork(network);
        }
        this.setVisible(false);
        this.dispose();
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean triggerSave = false;
            if (e.getActionCommand().equals("OK")) {
                String networkName = (String)SelectNetworkDialog.this.networkCbx.getEditor().getItem();
                if ((networkName = networkName.trim()).length() == 0) {
                    networkName = PrivateNetworkConstants.DEFAULT_NETWORK_TO_USE;
                }
                if (!NetworkPrefs.CurrentNetwork.get().equals(networkName)) {
                    NetworkPrefs.CurrentNetwork.set(networkName);
                    triggerSave = true;
                }
                boolean autoConnect = SelectNetworkDialog.this.autoConnectChkbx.isSelected();
                ConnectionPrefs.AutoConnectOnStartup.set(new Boolean(autoConnect));
                if (!networkName.equals("<General Gnutella Network>")) {
                    NetworkPrefs.NetworkHistory.get().remove(networkName);
                    NetworkPrefs.NetworkHistory.get().add(0, networkName);
                    if (NetworkPrefs.NetworkHistory.get().size() > 20) {
                        NetworkPrefs.NetworkHistory.get().remove(20);
                    }
                    triggerSave = true;
                }
            }
            SelectNetworkDialog.this.closeDialog(triggerSave);
        }
    }
}

