/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.apache.commons.lang.SystemUtils;
import phex.common.log.LogRecord;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.utils.Localizer;

public class LogBufferDialog
extends JDialog {
    private Collection logEntries;
    private DateFormat dateFormat;

    public LogBufferDialog(Collection logEntries) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("LogBufferDialog_DialogTitle"), false);
        this.logEntries = logEntries;
        this.dateFormat = new SimpleDateFormat("yyMMdd HH:mm:ss,SSSS");
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, fill:d:grow, 4dlu", "p, p, 2dlu, fill:p:grow, 4dlu, p, 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        DialogBanner banner = new DialogBanner(Localizer.getString("LogBufferDialog_Log"), Localizer.getString("LogBufferDialog_DisplayLog"));
        contentPB.add((Component)banner, cc.xywh(1, 1, 3, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, 2, 3, 1));
        JTextArea logArea = new JTextArea(40, 100);
        logArea.setEditable(false);
        contentPB.add((Component)new JScrollPane(logArea), cc.xy(2, 4));
        JButton closeBtn = new JButton(Localizer.getString("Close"));
        closeBtn.addActionListener(closeEventHandler);
        contentPB.add((Component)ButtonBarFactory.buildCloseBar(closeBtn), cc.xy(2, 6));
        StringBuffer textBuffer = new StringBuffer();
        for (LogRecord record : this.logEntries) {
            textBuffer.append(this.dateFormat.format(new Date(record.getTimestamp()))).append("::").append(record.getMessage()).append(SystemUtils.LINE_SEPARATOR);
        }
        logArea.setText(textBuffer.toString());
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            LogBufferDialog.this.closeDialog();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogBufferDialog.this.closeDialog();
        }
    }
}

