/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.common.log.NLogger;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.gui.models.CollectionsListModel;
import phex.prefs.core.LibraryPrefs;
import phex.prefs.core.PhexCorePrefs;
import phex.utils.Localizer;
import phex.utils.StringUtils;

public class FilterLibraryDialog
extends JDialog {
    private CollectionsListModel filterListModel;
    private JList filterList;

    public FilterLibraryDialog() throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("FilterLibraryDialog_DialogTitle"), false);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FilterLibraryDialog.this.closeDialog();
            }
        });
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("4dlu, fill:d:grow, 4dlu, d, 4dlu", "p, 10dlu, p, 3dlu, p, 3dlu, p, fill:p:grow, 10dlu, p, 6dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p 6dlu");
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        DialogBanner banner = new DialogBanner(Localizer.getString("FilterLibraryDialog_BannerHeader"), Localizer.getString("FilterLibraryDialog_BannerSubHeader"));
        builder.add((Component)banner, cc.xywh(1, 1, columnCount, 1));
        this.filterListModel = new CollectionsListModel();
        this.filterListModel.addAll(LibraryPrefs.LibraryExclusionRegExList.get());
        this.filterList = new JList(this.filterListModel);
        builder.add((Component)new JScrollPane(this.filterList), cc.xywh(2, 3, 1, 6));
        JButton addBtn = new JButton(Localizer.getString("FilterLibraryDialog_Add"));
        addBtn.addActionListener(new AddBtnListener());
        builder.add((Component)addBtn, cc.xy(4, 3));
        JButton editBtn = new JButton(Localizer.getString("FilterLibraryDialog_Edit"));
        editBtn.addActionListener(new EditBtnListener());
        builder.add((Component)editBtn, cc.xy(4, 5));
        JButton removeBtn = new JButton(Localizer.getString("FilterLibraryDialog_Remove"));
        removeBtn.addActionListener(new RemoveBtnListener());
        builder.add((Component)removeBtn, cc.xy(4, 7));
        builder.addSeparator(Localizer.getString("FilterLibraryDialog_Examples"), cc.xywh(2, 10, 3, 1));
        builder.addLabel(Localizer.getString("FilterLibraryDialog_Example1"), cc.xywh(2, 12, 3, 1));
        builder.addLabel(Localizer.getString("FilterLibraryDialog_Example2"), cc.xywh(2, 14, 3, 1));
        builder.addLabel(Localizer.getString("FilterLibraryDialog_Example3"), cc.xywh(2, 16, 3, 1));
        builder.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(new CancelBtnListener());
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.addActionListener(new OkBtnListener());
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(okBtn, cancelBtn);
        builder.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void addFilter(String filter) {
        if (!this.filterListModel.contains(filter)) {
            this.filterListModel.add(filter);
        }
    }

    private void updateFilter(String oldFilter, String newFilter) {
        if (this.filterListModel.contains(newFilter)) {
            this.filterListModel.remove(oldFilter);
        } else {
            int idx = this.filterListModel.indexOf(oldFilter);
            this.filterListModel.set(idx, newFilter);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public class EditFilterDialog
    extends JDialog {
        private JTextField filterField;
        private JLabel errorLabel;
        private String editFilter;

        public EditFilterDialog() throws HeadlessException {
            super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("FilterLibraryDialogAdd_DialogTitle"), false);
            this.editFilter = null;
            this.prepareComponent();
        }

        public EditFilterDialog(String filter) throws HeadlessException {
            super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("FilterLibraryDialogAdd_DialogTitle"), false);
            this.editFilter = filter;
            this.prepareComponent();
        }

        private void prepareComponent() {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    EditFilterDialog.this.closeDialog();
                }
            });
            CellConstraints cc = new CellConstraints();
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            JPanel contentPanel = new JPanel();
            contentPane.add((Component)contentPanel, "Center");
            FormLayout layout = new FormLayout("4dlu, d, 3dlu, fill:d:grow, 4dlu", "p, 10dlu, p, 2dlu, p, 10dlu, p, 6dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p 6dlu");
            PanelBuilder builder = new PanelBuilder(layout, contentPanel);
            int columnCount = layout.getColumnCount();
            int rowCount = layout.getRowCount();
            DialogBanner banner = new DialogBanner(Localizer.getString("FilterLibraryDialogAdd_BannerHeader"), Localizer.getString("FilterLibraryDialogAdd_BannerSubHeader"));
            builder.add((Component)banner, cc.xywh(1, 1, columnCount, 1));
            builder.addLabel(Localizer.getString("FilterLibraryDialogAdd_Filter"), cc.xy(2, 3));
            this.filterField = new JTextField(40);
            if (this.editFilter != null) {
                this.filterField.setText(this.editFilter);
            }
            builder.add((Component)this.filterField, cc.xy(4, 3));
            this.errorLabel = new JLabel(" ");
            builder.add((Component)this.errorLabel, cc.xy(4, 5));
            builder.addSeparator(Localizer.getString("FilterLibraryDialog_Examples"), cc.xywh(2, 7, 3, 1));
            builder.addLabel(Localizer.getString("FilterLibraryDialog_Example1"), cc.xywh(2, 9, 3, 1));
            builder.addLabel(Localizer.getString("FilterLibraryDialog_Example2"), cc.xywh(2, 11, 3, 1));
            builder.addLabel(Localizer.getString("FilterLibraryDialog_Example3"), cc.xywh(2, 13, 3, 1));
            builder.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
            JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
            cancelBtn.addActionListener(new CancelBtnListener());
            JButton okBtn = new JButton(Localizer.getString("OK"));
            okBtn.addActionListener(new OkBtnListener());
            JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(okBtn, cancelBtn);
            builder.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        private void showErrorLabel(String text) {
            this.errorLabel.setText(text);
            this.errorLabel.setIcon(GUIRegistry.getInstance().getPlafIconPack().getIcon("LibraryFilterDialog.Error"));
        }

        private void closeDialog() {
            this.setVisible(false);
            this.dispose();
        }

        private final class CancelBtnListener
        implements ActionListener {
            private CancelBtnListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EditFilterDialog.this.closeDialog();
                }
                catch (Throwable th) {
                    NLogger.error(CancelBtnListener.class, (Object)th, th);
                }
            }
        }

        private final class OkBtnListener
        implements ActionListener {
            private OkBtnListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String filter = EditFilterDialog.this.filterField.getText();
                    if (StringUtils.isEmpty(filter)) {
                        EditFilterDialog.this.closeDialog();
                        return;
                    }
                    boolean isValid = this.validate(filter);
                    if (isValid) {
                        if (EditFilterDialog.this.editFilter == null) {
                            FilterLibraryDialog.this.addFilter(filter);
                        } else {
                            FilterLibraryDialog.this.updateFilter(EditFilterDialog.this.editFilter, filter);
                        }
                        EditFilterDialog.this.closeDialog();
                    } else {
                        EditFilterDialog.this.showErrorLabel(Localizer.getString("FilterLibraryDialogAdd_InvalidRegExp"));
                    }
                }
                catch (Throwable th) {
                    NLogger.error(OkBtnListener.class, (Object)th, th);
                }
            }

            private boolean validate(String filter) {
                try {
                    Pattern pattern = Pattern.compile(filter);
                    return true;
                }
                catch (PatternSyntaxException exp) {
                    return false;
                }
            }
        }
    }

    private final class CancelBtnListener
    implements ActionListener {
        private CancelBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FilterLibraryDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error(CancelBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                LinkedHashSet uniqueSet = new LinkedHashSet();
                uniqueSet.addAll(FilterLibraryDialog.this.filterListModel);
                LibraryPrefs.LibraryExclusionRegExList.get().clear();
                LibraryPrefs.LibraryExclusionRegExList.get().addAll(uniqueSet);
                FilterLibraryDialog.this.closeDialog();
                PhexCorePrefs.save(false);
                GUIActionPerformer.rescanSharedFiles();
            }
            catch (Throwable th) {
                NLogger.error(OkBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class RemoveBtnListener
    implements ActionListener {
        private RemoveBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int i = FilterLibraryDialog.this.filterList.getSelectedIndex();
                FilterLibraryDialog.this.filterListModel.remove(i);
            }
            catch (Throwable th) {
                NLogger.error(RemoveBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class EditBtnListener
    implements ActionListener {
        private EditBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String filter = (String)FilterLibraryDialog.this.filterList.getSelectedValue();
                if (StringUtils.isEmpty(filter)) {
                    return;
                }
                EditFilterDialog dialog = new EditFilterDialog(filter);
                dialog.setVisible(true);
            }
            catch (Throwable th) {
                NLogger.error(EditBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class AddBtnListener
    implements ActionListener {
        private AddBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                EditFilterDialog dialog = new EditFilterDialog();
                dialog.setVisible(true);
            }
            catch (Throwable th) {
                NLogger.error(AddBtnListener.class, (Object)th, th);
            }
        }
    }
}

