/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.commons.lang.SystemUtils;
import phex.Res;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.gui.common.HTMLMultiLinePanel;
import phex.utils.Localizer;
import phex.utils.VersionUtils;

public class AboutDialog
extends JDialog {
    private JTextArea environmentInfo;

    public AboutDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("AboutPhex_DialogTitle"), false);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, fill:d:grow, 4dlu", "p, p, 2dlu, p, 4dlu, p, 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        Object[] objArr = new Object[]{"" + VersionUtils.getProgramVersion(), VersionUtils.getBuild()};
        DialogBanner banner = new DialogBanner("Phex", Localizer.getFormatedString("AboutPhex_VersionInfo", objArr));
        contentPB.add((Component)banner, cc.xywh(1, 1, 3, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, 2, 3, 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        contentPB.add((Component)tabbedPane, cc.xy(2, 4));
        JButton closeBtn = new JButton(Localizer.getString("Close"));
        closeBtn.addActionListener(closeEventHandler);
        contentPB.add((Component)ButtonBarFactory.buildCloseBar(closeBtn), cc.xy(2, 6));
        JPanel aboutPanel = new JPanel();
        layout = new FormLayout("4dlu, fill:d:grow, 4dlu", "4dlu, p, 4dlu");
        PanelBuilder aboutPB = new PanelBuilder(layout, aboutPanel);
        tabbedPane.addTab(Localizer.getString("AboutPhex_About"), aboutPanel);
        Object[] objArr2 = new Object[]{Res.getStr("Program.Url")};
        HTMLMultiLinePanel aboutHtml = new HTMLMultiLinePanel(Localizer.getFormatedString("AboutPhex_AboutText", objArr2));
        aboutPB.add((Component)aboutHtml, cc.xy(2, 2));
        JPanel envPanel = new JPanel();
        layout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, p, 2dlu, p, 2dlu");
        PanelBuilder envPB = new PanelBuilder(layout, envPanel);
        tabbedPane.addTab(Localizer.getString("AboutPhex_Environment"), envPanel);
        this.environmentInfo = new JTextArea(12, 55);
        this.environmentInfo.setEditable(false);
        envPB.add((Component)new JScrollPane(this.environmentInfo), cc.xy(2, 2));
        StringBuffer envTextBuffer = new StringBuffer();
        Properties pros = System.getProperties();
        ArrayList<Object> list = new ArrayList<Object>(pros.keySet());
        Collections.sort(list);
        for (String string : list) {
            String value = (String)pros.get(string);
            envTextBuffer.append(string).append(" = ").append(value).append(SystemUtils.LINE_SEPARATOR);
        }
        this.environmentInfo.setText(envTextBuffer.toString());
        this.environmentInfo.setCaretPosition(0);
        JButton jButton = new JButton(Localizer.getString("Copy"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(AboutDialog.this.environmentInfo.getText()), null);
            }
        });
        envPB.add((Component)ButtonBarFactory.buildLeftAlignedBar(jButton), cc.xy(2, 4));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    protected final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        protected CloseEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            AboutDialog.this.closeDialog();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog.this.closeDialog();
        }
    }
}

