/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.comparator;

import java.util.Comparator;
import phex.common.TransferDataProvider;
import phex.common.log.NLogger;

public class ETAComparator
implements Comparator<TransferDataProvider> {
    @Override
    public int compare(TransferDataProvider provider1, TransferDataProvider provider2) {
        try {
            if (provider1 == provider2 || provider1.equals(provider2)) {
                return 0;
            }
            long diff = this.calcTimeRemaining(provider2) - this.calcTimeRemaining(provider1);
            if (diff == 0L) {
                diff = provider2.hashCode() - provider1.hashCode();
            }
            if (diff < 0L) {
                return -1;
            }
            return 1;
        }
        catch (RuntimeException exp) {
            NLogger.error(ETAComparator.class, (Object)("Exception during compare: provider1: " + provider1 + " - provider2:" + provider2), (Throwable)exp);
            throw exp;
        }
    }

    public long calcTimeRemaining(TransferDataProvider provider) {
        long transferredSize = provider.getTransferredDataSize();
        long totalTransferSize = provider.getTransferDataSize();
        long transferRate = provider.getLongTermTransferRate();
        if (totalTransferSize == -1L || provider.getDataTransferStatus() != 10) {
            return 31536000L;
        }
        if (transferRate == 0L) {
            return 31536000L;
        }
        long timeRemaining = (totalTransferSize - transferredSize) / transferRate;
        timeRemaining = Math.max(0L, timeRemaining);
        return timeRemaining;
    }
}

