/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.treetable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import phex.gui.common.table.FWTableModel;
import phex.gui.common.treetable.JTreeTable;
import phex.gui.common.treetable.TreeTableModel;
import phex.gui.models.ISortableModel;

public class TreeTableModelAdapter
extends FWTableModel
implements ISortableModel {
    protected final JTree tree;
    private JTreeTable treeTable = null;
    private TreeModelListener treeModelListener;

    TreeTableModelAdapter(JTree tree) {
        assert (tree != null);
        this.tree = tree;
        tree.getModel().addTreeModelListener(this.getTreeModelListener());
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        tree.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TreeTableModel model = (TreeTableModel)evt.getOldValue();
                model.removeTreeModelListener(TreeTableModelAdapter.this.getTreeModelListener());
                model = (TreeTableModel)evt.getNewValue();
                model.addTreeModelListener(TreeTableModelAdapter.this.getTreeModelListener());
                TreeTableModelAdapter.this.fireTableStructureChanged();
            }
        });
    }

    protected JTreeTable getTreeTable() {
        return this.treeTable;
    }

    protected final void bind(JTreeTable treeTable) {
        if (treeTable == null) {
            throw new IllegalArgumentException("null treeTable");
        }
        if (this.treeTable != null) {
            throw new IllegalArgumentException("adapter already bound");
        }
        this.treeTable = treeTable;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return ((TreeTableModel)this.tree.getModel()).getColumnClass(column);
    }

    @Override
    public int getColumnCount() {
        return ((TreeTableModel)this.tree.getModel()).getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return ((TreeTableModel)this.tree.getModel()).getColumnName(column);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object node = this.nodeForRow(row);
        return node != null ? ((TreeTableModel)this.tree.getModel()).getValueAt(node, column) : null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Object node = this.nodeForRow(row);
        return node != null ? ((TreeTableModel)this.tree.getModel()).isCellEditable(node, column) : false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        Object node = this.nodeForRow(row);
        if (node != null) {
            ((TreeTableModel)this.tree.getModel()).setValueAt(value, node, column);
        }
    }

    protected Object nodeForRow(int row) {
        TreePath path = this.tree.getPathForRow(row);
        return path != null ? path.getLastPathComponent() : null;
    }

    private TreeModelListener getTreeModelListener() {
        if (this.treeModelListener == null) {
            this.treeModelListener = new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataUpdated(e);
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 1);
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 2);
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }
            };
        }
        return this.treeModelListener;
    }

    private boolean isTableStructureChanged(TreeModelEvent e) {
        return e.getTreePath() == null || e.getTreePath().getParentPath() == null;
    }

    private void delayedFireTableStructureChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableStructureChanged();
            }
        });
    }

    private void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    private void delayedFireTableDataChanged(final TreeModelEvent tme, final int typeChange) {
        if (typeChange < 1 || typeChange > 2) {
            throw new IllegalArgumentException("Event type must be 1 or 2, was " + typeChange);
        }
        final boolean expanded = this.tree.isExpanded(tme.getTreePath());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int[] indices = tme.getChildIndices();
                TreePath path = tme.getTreePath();
                if (indices != null) {
                    if (expanded) {
                        int min = indices[0];
                        int max = indices[indices.length - 1];
                        int startingRow = TreeTableModelAdapter.this.tree.getRowForPath(path) + 1;
                        min = startingRow + min;
                        max = startingRow + max;
                        switch (typeChange) {
                            case 1: {
                                TreeTableModelAdapter.this.fireTableRowsInserted(min, max);
                                break;
                            }
                            case 2: {
                                TreeTableModelAdapter.this.fireTableRowsDeleted(min, max);
                            }
                        }
                    } else {
                        int row = TreeTableModelAdapter.this.tree.getRowForPath(path);
                        if (row >= 0) {
                            TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                        }
                    }
                } else {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            }
        });
    }

    protected void delayedFireTableDataUpdated(final TreeModelEvent tme) {
        final boolean expanded = this.tree.isExpanded(tme.getTreePath());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int[] indices = tme.getChildIndices();
                TreePath path = tme.getTreePath();
                if (indices != null) {
                    if (expanded) {
                        Object[] children = tme.getChildren();
                        int min = Integer.MAX_VALUE;
                        int max = Integer.MIN_VALUE;
                        for (int i = 0; i < indices.length; ++i) {
                            Object child = children[i];
                            TreePath childPath = path.pathByAddingChild(child);
                            int index = TreeTableModelAdapter.this.tree.getRowForPath(childPath);
                            if (index < min) {
                                min = index;
                            }
                            if (index <= max) continue;
                            max = index;
                        }
                        TreeTableModelAdapter.this.fireTableRowsUpdated(Math.max(0, min), Math.max(0, max));
                    } else {
                        int row = TreeTableModelAdapter.this.tree.getRowForPath(path);
                        if (row >= 0) {
                            TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                        }
                    }
                } else {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            }
        });
    }

    public Comparator getColumnComparator(int column) {
        return ((TreeTableModel)this.tree.getModel()).getColumnComparator(column);
    }

    public Object getComparableValueAt(int row, int column) {
        return ((TreeTableModel)this.tree.getModel()).getComparableValueAt(this.nodeForRow(row), column);
    }

    @Override
    public boolean isColumnHideable(int columnIndex) {
        return ((TreeTableModel)this.tree.getModel()).isColumnHideable(columnIndex);
    }

    @Override
    public boolean isColumnDefaultVisible(int columnIndex) {
        return ((TreeTableModel)this.tree.getModel()).isColumnDefaultVisible(columnIndex);
    }

    @Override
    public Object getColumnId(int columnIndex) {
        return ((TreeTableModel)this.tree.getModel()).getColumnId(columnIndex);
    }

    @Override
    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }

    @Override
    public int getSortByColumn() {
        if (this.tree.getModel() instanceof ISortableModel) {
            return ((ISortableModel)((Object)this.tree.getModel())).getSortByColumn();
        }
        throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
    }

    @Override
    public boolean isSortedAscending() {
        if (this.tree.getModel() instanceof ISortableModel) {
            return ((ISortableModel)((Object)this.tree.getModel())).isSortedAscending();
        }
        throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
    }

    @Override
    public void sortByColumn(int column, boolean isSortedAscending) {
        if (!(this.tree.getModel() instanceof ISortableModel)) {
            throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
        }
        ((ISortableModel)((Object)this.tree.getModel())).sortByColumn(column, isSortedAscending);
    }
}

