/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.treetable;

import java.util.Comparator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import phex.gui.common.treetable.TreeTableModel;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    public static final Class hierarchicalColumnClass = TreeTableModel.class;
    protected String[] tableColumns;
    protected Class[] tableClasses;
    protected Object[] columnIds;
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractTreeTableModel(Object root, Object[] theColumnIds, String[] theTableColumns, Class[] theTableClasses) {
        this.tableColumns = theTableColumns;
        this.tableClasses = theTableClasses;
        this.columnIds = theColumnIds;
        assert (this.tableClasses[0] == hierarchicalColumnClass);
        this.root = root;
    }

    @Override
    public String getColumnName(int column) {
        return this.tableColumns[column];
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.length;
    }

    @Override
    public Class getColumnClass(int column) {
        Class<String> clazz = this.tableClasses[column];
        if (clazz == null) {
            clazz = String.class;
        }
        return clazz;
    }

    @Override
    public Comparator getColumnComparator(int column) {
        return null;
    }

    @Override
    public Object getComparableValueAt(Object node, int column) {
        return this.getValueAt(node, column);
    }

    @Override
    public boolean isColumnHideable(int columnIndex) {
        return true;
    }

    @Override
    public boolean isColumnDefaultVisible(int columnIndex) {
        return true;
    }

    @Override
    public Object getColumnId(int columnIndex) {
        return this.columnIds[columnIndex];
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    public void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
    }
}

