/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import phex.common.ThreadPool;
import phex.common.ThreadTracking;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GradientPanel;
import phex.gui.common.PhexColors;
import phex.utils.Localizer;

public class SlideInWindow
extends JWindow {
    private boolean closeAfterAnimation = false;
    private long autoCloseDelay;
    private String title;
    private boolean isHTML;
    private String shortMessage;
    private boolean isHideBtnShown;
    private JButton hideBtn;

    public SlideInWindow(String title, long autoCloseDelay) {
        super(GUIRegistry.getInstance().getMainFrame());
        this.title = title;
        this.autoCloseDelay = autoCloseDelay;
        this.isHideBtnShown = true;
    }

    public void setShortMessage(String text, boolean isHTML) {
        this.shortMessage = text;
        this.isHTML = isHTML;
    }

    public void setHideBtnShown(boolean status) {
        this.isHideBtnShown = status;
    }

    public void initializeComponent() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setDoubleBuffered(true);
        panel.setBorder(BorderFactory.createLineBorder(PhexColors.getBoxPanelBorderColor(), 2));
        panel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        DialogBanner dialogBanner = new DialogBanner(this.title, null);
        dialogBanner.setImageIcon(null);
        panel.add((Component)dialogBanner, "North");
        GradientPanel backgrundPanel = new GradientPanel(Color.WHITE, PhexColors.getBoxHeaderGradientTo());
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4px, fill:d:grow, 4px", "4px, fill:d:grow, 10px, p, 4px");
        PanelBuilder contentPB = new PanelBuilder(layout, backgrundPanel);
        JEditorPane editorPane = new JEditorPane();
        if (this.isHTML) {
            editorPane.setContentType("text/html");
        }
        Font font = editorPane.getFont();
        font = font.deriveFont(0, font.getSize() + 1);
        editorPane.setFont(font);
        editorPane.setOpaque(false);
        editorPane.setText(this.shortMessage);
        editorPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setViewportView(editorPane);
        backgrundPanel.add((Component)scrollPane, cc.xy(2, 2));
        if (this.isHideBtnShown) {
            this.hideBtn = new JButton(Localizer.getString("SlideInWindow_Hide"));
            this.hideBtn.setMargin(new Insets(1, 1, 1, 3));
            this.hideBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThreadPool.getInstance().addJob(new Runnable(){

                        @Override
                        public void run() {
                            SlideInWindow.this.slideOut();
                        }
                    }, "SlideOutJob");
                }
            });
            JPanel buttonPanel = ButtonBarFactory.buildRightAlignedBar(this.hideBtn);
            buttonPanel.setOpaque(false);
            backgrundPanel.add((Component)buttonPanel, cc.xy(2, 4));
        }
        panel.add((Component)backgrundPanel, "Center");
        this.validate();
        this.pack();
        this.setSize(250, 200);
    }

    public void slideIn() {
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point startPoint = new Point(screenSize.width - 5 - screenInsets.left, screenSize.height - this.getHeight() - 5 - screenInsets.bottom);
        Point stopPoint = new Point(screenSize.width - this.getWidth() - 5 - screenInsets.left, screenSize.height - this.getHeight() - 5 - screenInsets.bottom);
        this.setLocation(startPoint.x, startPoint.y);
        this.setVisible(true);
        this.repaint();
        this.closeAfterAnimation = false;
        AnimatorThread animator = new AnimatorThread(this, startPoint, stopPoint, 50, 30L);
        animator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void slideOut() {
        SlideInWindow slideInWindow = this;
        synchronized (slideInWindow) {
            if (this.closeAfterAnimation) {
                return;
            }
            this.closeAfterAnimation = true;
        }
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point startPoint = new Point(screenSize.width - this.getWidth() - 5 - screenInsets.left, screenSize.height - this.getHeight() - 5 - screenInsets.bottom);
        Point stopPoint = new Point(screenSize.width - this.getWidth() - 5 - screenInsets.left, screenSize.height - screenInsets.bottom);
        AnimatorThread animator = new AnimatorThread(this, startPoint, stopPoint, 50, 30L);
        animator.start();
    }

    private void animationFinished() {
        if (this.closeAfterAnimation) {
            this.setVisible(false);
            this.dispose();
        } else if (this.autoCloseDelay > 0L) {
            ThreadPool.getInstance().addJob(new Runnable(){

                @Override
                public void run() {
                    long now = System.currentTimeMillis();
                    long closeTime = now + SlideInWindow.this.autoCloseDelay;
                    while (now < closeTime) {
                        int secLeft = (int)Math.round((double)(closeTime - now) / 1000.0);
                        SlideInWindow.this.hideBtn.setText(Localizer.getFormatedString("SlideInWindow_HideSec", new Integer(secLeft)));
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        now = System.currentTimeMillis();
                    }
                    SlideInWindow.this.slideOut();
                }
            }, "SlideInWindowHideBtnAnimator");
        }
    }

    private class AnimatorThread
    extends Thread {
        private Component comp;
        private long stepDelay;
        private int animationSteps;
        private Point startPoint;
        private Point stopPoint;

        public AnimatorThread(Component component, Point startPoint, Point stopPoint, int steps, long stepDelay) {
            super(ThreadTracking.rootThreadGroup, "AnimatorThread");
            this.comp = component;
            this.stepDelay = stepDelay;
            this.animationSteps = steps;
            this.startPoint = startPoint;
            this.stopPoint = stopPoint;
        }

        @Override
        public void run() {
            for (int i = 0; i <= this.animationSteps; ++i) {
                this.updateComponentAtStep(i);
                try {
                    Thread.sleep(this.stepDelay);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            SlideInWindow.this.animationFinished();
        }

        private void updateComponentAtStep(int step) {
            final int x = this.startPoint.x + (this.stopPoint.x - this.startPoint.x) * step / this.animationSteps;
            final int y = this.startPoint.y + (this.stopPoint.y - this.startPoint.y) * step / this.animationSteps;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnimatorThread.this.comp.setLocation(x, y);
                    AnimatorThread.this.comp.validate();
                }
            });
        }
    }
}

