/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang.SystemUtils;
import phex.common.log.NLogger;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.LookAndFeelFailedException;
import phex.utils.ClassUtils;

public class LookAndFeelUtils {
    private static final String[] themeNames = new String[]{"BrownSugar", "DarkStar", "DesertBlue", "DesertBluer", "DesertGreen", "DesertRed", "DesertYellow", "ExperienceBlue", "ExperienceGreen", "ExperienceRoyale", "LightGray", "Silver", "SkyBlue", "SkyBluer", "SkyGreen", "SkyKrupp", "SkyPink", "SkyRed", "SkyYellow"};
    private static ThemeInfo[] plasticThemes;

    public static UIManager.LookAndFeelInfo[] getAvailableLAFs() {
        Class<?> gtkLAFClass;
        ArrayList<UIManager.LookAndFeelInfo> list = new ArrayList<UIManager.LookAndFeelInfo>();
        if (SystemUtils.IS_OS_MAC_OSX) {
            list.add(new UIManager.LookAndFeelInfo("Macintosh", UIManager.getSystemLookAndFeelClassName()));
        }
        list.add(new UIManager.LookAndFeelInfo("PlasticXP (default)", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel"));
        list.add(new UIManager.LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel"));
        if (SystemUtils.IS_OS_WINDOWS) {
            list.add(new UIManager.LookAndFeelInfo("Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"));
        }
        try {
            gtkLAFClass = Class.forName("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        }
        catch (ClassNotFoundException e) {
            gtkLAFClass = null;
        }
        if (gtkLAFClass != null) {
            list.add(new UIManager.LookAndFeelInfo("GTK", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel"));
        }
        UIManager.LookAndFeelInfo[] lafs = new UIManager.LookAndFeelInfo[list.size()];
        list.toArray(lafs);
        return lafs;
    }

    public static ThemeInfo[] getAvailableThemes(String lafClassName) {
        if (lafClassName.equals("com.jgoodies.looks.plastic.PlasticXPLookAndFeel")) {
            LookAndFeelUtils.initPlasticThemes();
            return plasticThemes;
        }
        return new ThemeInfo[0];
    }

    public static ThemeInfo getCurrentTheme(String lafClassName) {
        if ("com.jgoodies.looks.plastic.PlasticXPLookAndFeel".equals(lafClassName)) {
            PlasticTheme myCurrentTheme = PlasticLookAndFeel.getPlasticTheme();
            if (myCurrentTheme == null) {
                return null;
            }
            Class<?> clazz = myCurrentTheme.getClass();
            String name = clazz.getName();
            return new ThemeInfo(name, name);
        }
        return null;
    }

    public static void setCurrentTheme(String lafClassName, Object theme) {
        if (lafClassName.equals("com.jgoodies.looks.plastic.PlasticXPLookAndFeel")) {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)theme);
            try {
                UIManager.setLookAndFeel(UIManager.getLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException exp) {
                NLogger.error(LookAndFeelUtils.class, (Object)exp, (Throwable)exp);
            }
        }
        GUIUtils.updateComponentsUI();
    }

    public static LookAndFeel determineLAF(String defaultClass) {
        String lafClass = defaultClass;
        LookAndFeel laf = (LookAndFeel)ClassUtils.newInstanceQuitly(ClassUtils.classForNameQuitly(lafClass));
        if (laf != null && laf.isSupportedLookAndFeel()) {
            return laf;
        }
        lafClass = LookAndFeelUtils.getDefaultLAFClassName();
        laf = (LookAndFeel)ClassUtils.newInstanceQuitly(ClassUtils.classForNameQuitly(lafClass));
        if (laf != null && laf.isSupportedLookAndFeel()) {
            return laf;
        }
        lafClass = UIManager.getCrossPlatformLookAndFeelClassName();
        laf = (LookAndFeel)ClassUtils.newInstanceQuitly(ClassUtils.classForNameQuitly(lafClass));
        return laf;
    }

    private static String getDefaultLAFClassName() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    }

    public static void setLookAndFeel(String className) throws LookAndFeelFailedException {
        try {
            Class<?> lnfClass = Class.forName(className);
            LookAndFeelUtils.setLookAndFeel((LookAndFeel)lnfClass.newInstance());
        }
        catch (ClassNotFoundException exp) {
            NLogger.error(LookAndFeelUtils.class, (Object)("Class not found: " + className), (Throwable)exp);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + exp, "Error", 0);
            throw new LookAndFeelFailedException("Class not found: " + className);
        }
        catch (IllegalAccessException exp) {
            NLogger.error(LookAndFeelUtils.class, (Object)("Illegal access: " + className), (Throwable)exp);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + exp, "Error", 0);
            throw new LookAndFeelFailedException("Illegal access: " + className);
        }
        catch (InstantiationException exp) {
            NLogger.error(LookAndFeelUtils.class, (Object)("Instantiation failed: " + className), (Throwable)exp);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + exp, "Error", 0);
            throw new LookAndFeelFailedException("Instantiation faield: " + className);
        }
        catch (Throwable th) {
            NLogger.error(LookAndFeelUtils.class, (Object)("Error loading LAF: " + className), th);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + th, "Error", 0);
        }
    }

    public static void setLookAndFeel(LookAndFeel laf) throws LookAndFeelFailedException {
        try {
            if (laf.getID().equals(UIManager.getLookAndFeel().getID())) {
                return;
            }
            UIManager.setLookAndFeel(laf);
            GUIUtils.updateComponentsUI();
        }
        catch (UnsupportedLookAndFeelException exp) {
            NLogger.error(LookAndFeelUtils.class, (Object)("Instantiation faield: " + laf.getName()), (Throwable)exp);
            throw new LookAndFeelFailedException("Instantiation faield: " + laf.getName());
        }
    }

    private static void initPlasticThemes() {
        if (plasticThemes == null) {
            PlasticTheme theme = PlasticLookAndFeel.createMyDefaultTheme();
            String defaultName = theme.getClass().getName();
            String classPrefix = "com.jgoodies.looks.plastic.theme.";
            plasticThemes = new ThemeInfo[themeNames.length];
            for (int i = 0; i < themeNames.length; ++i) {
                String name;
                String displayName = name = themeNames[i];
                if (defaultName.endsWith(name)) {
                    displayName = name + " (default)";
                }
                LookAndFeelUtils.plasticThemes[i] = new ThemeInfo(displayName, classPrefix + name);
            }
        }
    }

    public static class ThemeInfo {
        private String name;
        private String className;

        public ThemeInfo(String name, String className) {
            this.name = name;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ThemeInfo)) {
                return false;
            }
            return this.className.equals(((ThemeInfo)o).className);
        }
    }
}

