/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import phex.common.log.NLogger;
import phex.gui.common.GUIRegistry;
import phex.utils.IOUtil;
import phex.utils.Localizer;

public class IconPack {
    private static final String DEFAULT_ICON_PACK_RESOURCE = "phex.gui.resources.icons.phex.Icons";
    private static final ImageIcon MISSING_IMAGE = new ImageIcon(IconPack.class.getResource("/phex/gui/resources/image-failed.gif"));
    private static final String EMPTY_IMAGE_16_NAME = "EMPTY_IMAGE_16";
    public static final ImageIcon EMPTY_IMAGE_16;
    private static Map<String, String> iconPackDefinitions;
    private String name;
    private ResourceBundle resource;
    private Hashtable<String, Image> imageCache = new Hashtable();

    public IconPack(String resourceFileName) {
        this(null, resourceFileName);
    }

    public IconPack(String name, String resourceFileName) {
        this();
        this.name = name;
        this.resource = PropertyResourceBundle.getBundle(resourceFileName);
    }

    public String getName() {
        return this.name;
    }

    protected IconPack() {
    }

    public Icon getIcon(String key) {
        return new TKIcon(key);
    }

    public static IconPack createDefaultIconPack() {
        return new IconPack("Phex 3", DEFAULT_ICON_PACK_RESOURCE);
    }

    public static IconPack createIconPack(String name) {
        IconPack.initIconPackDefs();
        String res = iconPackDefinitions.get(name);
        if (res == null) {
            return null;
        }
        return new IconPack(name, res);
    }

    public static Set<String> getAllIconPackIds() {
        IconPack.initIconPackDefs();
        return Collections.unmodifiableSet(iconPackDefinitions.keySet());
    }

    private static void initIconPackDefs() {
        if (iconPackDefinitions != null) {
            return;
        }
        iconPackDefinitions = new LinkedHashMap<String, String>();
        Map<String, String> def = IconPack.loadIconPackDef("/iconpack.list");
        iconPackDefinitions.putAll(def);
        def = IconPack.loadIconPackDef("/phex/gui/resources/icons/iconpack.list");
        iconPackDefinitions.putAll(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadIconPackDef(String name) {
        InputStream stream = Localizer.class.getResourceAsStream(name);
        if (stream == null) {
            return Collections.emptyMap();
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "ISO-8859-1"));
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                String[] splitParts = line.split("=", 2);
                String packId = splitParts[0].trim();
                String packPath = splitParts[1].trim();
                map.put(packId, packPath);
            }
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
        catch (IOException exp) {
            NLogger.error(GUIRegistry.class, (Object)exp, (Throwable)exp);
        }
        finally {
            IOUtil.closeQuietly(stream);
        }
        return Collections.emptyMap();
    }

    static {
        BufferedImage bufImg = new BufferedImage(16, 16, 2);
        EMPTY_IMAGE_16 = new ImageIcon(bufImg);
    }

    class TKIcon
    extends ImageIcon {
        private String key;
        private boolean loaded;

        TKIcon(String aKey) {
            this.key = aKey;
            this.loaded = false;
        }

        @Override
        public Image getImage() {
            this.loadIcon();
            return super.getImage();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.loadIcon();
            super.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            this.loadIcon();
            return super.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            this.loadIcon();
            return super.getIconHeight();
        }

        private void loadIcon() {
            if (this.loaded) {
                return;
            }
            try {
                if (this.key != null) {
                    String imgURLStr = IconPack.this.resource.getString(this.key);
                    Image image = (Image)IconPack.this.imageCache.get(imgURLStr);
                    if (image == null) {
                        if (IconPack.EMPTY_IMAGE_16_NAME.equals(imgURLStr)) {
                            image = new BufferedImage(16, 16, 2);
                        } else {
                            URL imgURL = null;
                            if (imgURLStr != null && (imgURL = IconPack.class.getResource(imgURLStr)) != null) {
                                image = Toolkit.getDefaultToolkit().createImage(imgURL);
                            }
                        }
                        if (image != null) {
                            IconPack.this.imageCache.put(imgURLStr, image);
                        } else {
                            NLogger.warn(IconPack.class, (Object)("Can't find image for key: " + this.key + " - URL: " + imgURLStr));
                            image = MISSING_IMAGE.getImage();
                        }
                    }
                    super.setImage(image);
                    this.loaded = true;
                }
            }
            catch (Exception exp) {
                NLogger.error(IconPack.class, (Object)exp, (Throwable)exp);
            }
        }
    }
}

