/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import phex.common.address.AddressUtils;

public class IPTextField
extends JPanel {
    private JTextField part1;
    private JTextField part2;
    private JTextField part3;
    private JTextField part4;
    private TextFieldFocusHandler textFieldFocusHandler = new TextFieldFocusHandler();

    public IPTextField() {
        Border border = (Border)UIManager.get("TextField.border");
        this.setBorder(new BorderWrapping(border));
        this.part1 = this.createTextF(null);
        this.part2 = this.createTextF(this.part1);
        this.part3 = this.createTextF(this.part2);
        this.part4 = this.createTextF(this.part3);
        FormLayout layout = new FormLayout("d, d, d, d, d, d, d", "p");
        PanelBuilder panelBuilder = new PanelBuilder(layout, this);
        panelBuilder.add(this.part1);
        panelBuilder.nextColumn();
        panelBuilder.add(this.buildLabel());
        panelBuilder.nextColumn();
        panelBuilder.add(this.part2);
        panelBuilder.nextColumn();
        panelBuilder.add(this.buildLabel());
        panelBuilder.nextColumn();
        panelBuilder.add(this.part3);
        panelBuilder.nextColumn();
        panelBuilder.add(this.buildLabel());
        panelBuilder.nextColumn();
        panelBuilder.add(this.part4);
        this.setBackground(this.part1.getBackground());
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.part1.setEnabled(state);
        this.part2.setEnabled(state);
        this.part3.setEnabled(state);
        this.part4.setEnabled(state);
    }

    public boolean isInputValid() {
        if (!this.isFieldValid(this.part1)) {
            return false;
        }
        if (!this.isFieldValid(this.part2)) {
            return false;
        }
        if (!this.isFieldValid(this.part3)) {
            return false;
        }
        return this.isFieldValid(this.part4);
    }

    public boolean isFieldEmpty() {
        return this.part1.getText().trim().length() == 0 && this.part2.getText().trim().length() == 0 && this.part3.getText().trim().length() == 0 && this.part4.getText().trim().length() == 0;
    }

    private boolean isFieldValid(JTextField textField) {
        String str = textField.getText();
        if (str.length() == 0) {
            return false;
        }
        try {
            int result = Integer.parseInt(str);
            if (result > 255) {
                textField.setText("");
                return false;
            }
            return true;
        }
        catch (NumberFormatException exp) {
            textField.setText("");
            return false;
        }
    }

    public void setIPString(String ipString) {
        Document doc = this.part1.getDocument();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, ipString, new SimpleAttributeSet());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getIPString() {
        byte[] ip = this.getIP();
        return AddressUtils.ip2string(ip);
    }

    public byte[] getIP() {
        String p4;
        String p3;
        String p2;
        String p1 = this.part1.getText();
        if (p1.length() == 0) {
            p1 = "0";
        }
        if ((p2 = this.part2.getText()).length() == 0) {
            p2 = "0";
        }
        if ((p3 = this.part3.getText()).length() == 0) {
            p3 = "0";
        }
        if ((p4 = this.part4.getText()).length() == 0) {
            p4 = "0";
        }
        try {
            byte[] ip = new byte[]{(byte)Integer.parseInt(p1), (byte)Integer.parseInt(p2), (byte)Integer.parseInt(p3), (byte)Integer.parseInt(p4)};
            return ip;
        }
        catch (NumberFormatException exp) {
            return null;
        }
    }

    private JTextField createTextF(JTextField prevTextField) {
        IPDocument doc = new IPDocument();
        JTextField field = new JTextField(doc, null, 3);
        field.addFocusListener(this.textFieldFocusHandler);
        field.setBorder(null);
        field.setHorizontalAlignment(0);
        if (prevTextField != null) {
            ((IPDocument)prevTextField.getDocument()).setNextTextField(field);
        }
        return field;
    }

    private JLabel buildLabel() {
        JLabel label = new JLabel(".");
        label.setBackground(this.part1.getBackground());
        label.setForeground(this.part1.getForeground());
        return label;
    }

    private void addToNextTextField(String nextTextFieldStr, JTextField nextTF) {
        if (nextTF == null) {
            return;
        }
        nextTF.requestFocus();
        Document doc = nextTF.getDocument();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, nextTextFieldStr, new SimpleAttributeSet());
        }
        catch (BadLocationException exp) {
            // empty catch block
        }
    }

    private void selectNextTextField() {
        JTextField nextTF = this.getNextFocusTextField();
        if (nextTF == null) {
            return;
        }
        nextTF.requestFocus();
        nextTF.selectAll();
    }

    private JTextField getNextFocusTextField() {
        if (this.part1.hasFocus()) {
            return this.part2;
        }
        if (this.part2.hasFocus()) {
            return this.part3;
        }
        if (this.part3.hasFocus()) {
            return this.part4;
        }
        return null;
    }

    class IPDocument
    extends PlainDocument {
        protected JTextField nextTextField;

        IPDocument() {
        }

        public void setNextTextField(JTextField textField) {
            this.nextTextField = textField;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            int freeSpace = 3 - this.getLength();
            if (freeSpace == 0) {
                return;
            }
            char[] addCharArr = new char[freeSpace];
            int addCharCount = 0;
            int strLength = str.length();
            int i = 0;
            boolean continueToNextField = false;
            for (i = 0; i < strLength; ++i) {
                char c = str.charAt(i);
                if (Character.isDigit(c)) {
                    addCharArr[addCharCount] = c;
                    if (++addCharCount != freeSpace) continue;
                    break;
                }
                if (c != '.' || addCharCount <= 0) continue;
                continueToNextField = true;
                break;
            }
            super.insertString(offset, new String(addCharArr, 0, addCharCount), a);
            if (continueToNextField || offset + addCharCount == 3) {
                if (i + 1 < strLength) {
                    IPTextField.this.addToNextTextField(str.substring(i + 1), this.nextTextField);
                } else if (this.getLength() == 3) {
                    IPTextField.this.selectNextTextField();
                }
            }
        }
    }

    public class TextFieldFocusHandler
    extends FocusAdapter {
        @Override
        public void focusLost(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            JTextField textField = (JTextField)e.getSource();
            String text = textField.getText();
            if (text.length() == 0) {
                return;
            }
            try {
                int result = Integer.parseInt(text);
                if (result > 255) {
                    textField.setText("255");
                }
            }
            catch (NumberFormatException exp) {
                textField.setText("0");
            }
        }
    }

    public class BorderWrapping
    implements Border {
        private Border border;

        public BorderWrapping(Border border) {
            this.border = border;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.border.getBorderInsets(IPTextField.this.part1);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.border.isBorderOpaque();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.border.paintBorder(c, g, x, y, width, height);
        }
    }
}

