/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.EventQueue;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.event.PhexEventService;
import phex.gui.common.GUIUtils;
import phex.gui.dialogs.NewDownloadDialog;

public class GlobalGuiEventListeners {
    public GlobalGuiEventListeners(PhexEventService eventService) {
        eventService.processAnnotations(this);
    }

    @EventTopicSubscriber(topic="phex:incoming/uri")
    public void incomingUriDownload(String topic, String uri) {
        this.showDownloadDialog(uri, 1);
    }

    @EventTopicSubscriber(topic="phex:incoming/magma")
    public void incomingMagmaDownload(String topic, String uri) {
        this.showDownloadDialog(uri, 2);
    }

    @EventTopicSubscriber(topic="phex:incoming/rss")
    public void incomingRSSDownload(String topic, String uri) {
        this.showDownloadDialog(uri, 3);
    }

    private void showDownloadDialog(final String uri, final int type) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewDownloadDialog dialog = new NewDownloadDialog(uri, type);
                GUIUtils.showMainFrame();
                dialog.setVisible(true);
                dialog.toFront();
            }
        });
    }
}

