/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.EventQueue;
import phex.event.UserMessageListener;
import phex.gui.common.SlideInWindow;
import phex.utils.Localizer;

public class GUIUserMessageListener
implements UserMessageListener {
    private static final long DEFAULT_AUTO_CLOSE_DELAY = 30000L;

    @Override
    public void displayUserMessage(final String userMessageId, final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = GUIUserMessageListener.this.determineUserMsgTitle(userMessageId);
                String shortMessage = GUIUserMessageListener.this.determineUserMsgShortMessage(userMessageId, args);
                long autoCloseDelay = GUIUserMessageListener.this.determineUserMsgAutoCloseDelay(userMessageId);
                SlideInWindow window = new SlideInWindow(title, autoCloseDelay);
                window.setShortMessage(shortMessage, false);
                window.initializeComponent();
                window.slideIn();
            }
        });
    }

    private String determineUserMsgTitle(String userMessageId) {
        return Localizer.getString("UserMsg_" + userMessageId + "_Title");
    }

    private String determineUserMsgShortMessage(String userMessageId, String ... args) {
        if (args != null && args.length > 0) {
            return Localizer.getFormatedString("UserMsg_" + userMessageId + "_ShortMessage", args);
        }
        return Localizer.getString("UserMsg_" + userMessageId + "_ShortMessage");
    }

    private long determineUserMsgAutoCloseDelay(String userMessageId) {
        try {
            return Long.parseLong(Localizer.getString("UserMsg_" + userMessageId + "_AutoCloseDelay"));
        }
        catch (NumberFormatException exp) {
            return 30000L;
        }
    }
}

