/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Point;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.SystemUtils;
import phex.gui.common.SlideInWindow;
import phex.gui.macosx.MacOsxGUIUtils;
import phex.utils.DirectoryOnlyFileFilter;

public class FileDialogHandler {
    public static File openSingleDirectoryChooser(Component parent, String title, String approveBtnText, char approveBtnMnemonic, File currentDirectory) {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return FileDialogHandler.openMacDirectoryChooser(title, null, null);
        }
        return FileDialogHandler.openDefaultSingleChooser(parent, FileDialogHandler.initDefaultChooser(title, approveBtnText, approveBtnMnemonic, new DirectoryOnlyFileFilter(), 1, currentDirectory, null, null));
    }

    public static File[] openMultipleDirectoryChooser(Component parent, String title, String approveBtnText, char approveBtnMnemonic, File currentDirectory) {
        return FileDialogHandler.openMultipleDirectoryChooser(parent, title, approveBtnText, approveBtnMnemonic, currentDirectory, null, null);
    }

    public static File[] openMultipleDirectoryChooser(Component parent, String title, String approveBtnText, char approveBtnMnemonic, File currentDirectory, String notifyPopupTitle, String notifyPopupShortMessage) {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return new File[]{FileDialogHandler.openMacDirectoryChooser(title, notifyPopupTitle, notifyPopupShortMessage)};
        }
        return FileDialogHandler.openDefaultMultiChooser(parent, FileDialogHandler.initDefaultChooser(title, approveBtnText, approveBtnMnemonic, new DirectoryOnlyFileFilter(), 1, currentDirectory, notifyPopupTitle, notifyPopupShortMessage));
    }

    private static File openMacDirectoryChooser(String title, String notifyPopupTitle, String notifyPopupShortMessage) {
        FileDialog dia = MacOsxGUIUtils.createFolderDialog();
        dia.setTitle(title);
        DirectoryOnlyFileFilter filter = new DirectoryOnlyFileFilter();
        dia.setFilenameFilter(new FileFilterWrapper(filter));
        dia.setVisible(true);
        String dirStr = dia.getDirectory();
        String fileStr = dia.getFile();
        if (dirStr == null || fileStr == null) {
            return null;
        }
        File file = new File(dirStr, fileStr);
        if (!filter.accept(file)) {
            return null;
        }
        return file;
    }

    private static JFileChooser initDefaultChooser(String title, String approveBtnText, char approveBtnMnemonic, FileFilter filter, int mode, File currentDirectory, String notifyPopupTitle, String notifyPopupShortMessage) {
        JFileChooser chooser = new JFileChooser();
        if (notifyPopupTitle != null || notifyPopupShortMessage != null) {
            FileDialogHandler.displayNotificationPopup(chooser, notifyPopupTitle, notifyPopupShortMessage);
        }
        if (currentDirectory != null) {
            chooser.setCurrentDirectory(currentDirectory);
        }
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        chooser.setFileSelectionMode(mode);
        chooser.setDialogTitle(title);
        chooser.setApproveButtonText(approveBtnText);
        chooser.setApproveButtonMnemonic(approveBtnMnemonic);
        return chooser;
    }

    private static File[] openDefaultMultiChooser(Component parent, JFileChooser chooser) {
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal == 0) {
            return chooser.getSelectedFiles();
        }
        return null;
    }

    private static File openDefaultSingleChooser(Component parent, JFileChooser chooser) {
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private static void displayNotificationPopup(JComponent chooser, String title, String shortMessage) {
        final SlideInWindow window = new SlideInWindow(title, 0L);
        window.setShortMessage(shortMessage, true);
        window.setHideBtnShown(false);
        window.initializeComponent();
        window.setSize(200, 150);
        chooser.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                window.setVisible(true);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                window.setVisible(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                Container ancestor = event.getAncestor();
                Point loc = ancestor.getLocationOnScreen();
                int xPos = loc.x + ancestor.getWidth() + 5;
                int yPos = loc.y + ancestor.getHeight() - window.getHeight();
                window.setLocation(xPos, yPos);
            }
        });
    }

    private static class FileFilterWrapper
    implements FilenameFilter {
        private FileFilter filter;

        public FileFilterWrapper(FileFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.filter.accept(new File(dir, name));
        }
    }
}

