/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWToggleAction;

public class FWMenu
extends JMenu {
    public FWMenu(String name) {
        super(name);
    }

    @Override
    public JMenuItem add(Action a) {
        throw new UnsupportedOperationException("Use addAction( )");
    }

    public JMenuItem addAction(FWAction action) {
        return this.addAction(action, action.isToggleAction());
    }

    public JMenuItem addAction(Action a, boolean isToogleAction) {
        JMenuItem mi = this.createActionComponent(a, isToogleAction);
        mi.setAction(a);
        this.add(mi);
        return mi;
    }

    protected JMenuItem createActionComponent(Action action, boolean isToogleAction) {
        JMenuItem mi;
        if (isToogleAction) {
            mi = new JCheckBoxMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon")){

                @Override
                protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
                    PropertyChangeListener pcl = FWMenu.this.createActionChangeListener(this);
                    if (pcl == null) {
                        pcl = super.createActionPropertyChangeListener(a);
                    }
                    return pcl;
                }
            };
            mi.setSelected(((FWToggleAction)action).isSelected());
            this.registerActionChangeListener(mi, action);
            mi.setHorizontalTextPosition(11);
            mi.setVerticalTextPosition(0);
            mi.setEnabled(action.isEnabled());
        } else {
            mi = this.createActionComponent(action);
        }
        return mi;
    }

    private void registerActionChangeListener(JMenuItem mi, Action a) {
        ActionChangedListener actionPropertyChangeListener = new ActionChangedListener(mi);
        a.addPropertyChangeListener(actionPropertyChangeListener);
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
                this.menuItem.repaint();
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
                this.menuItem.repaint();
            } else if (propertyName.equals("MediumIcon")) {
                Icon icon = (Icon)e.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            } else if (propertyName.equals("IsSelected")) {
                Boolean state = (Boolean)e.getNewValue();
                this.menuItem.setSelected(state);
                this.menuItem.repaint();
            }
        }
    }
}

