/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class FWImagePanel
extends JPanel {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private int alignment = 1;
    private ImageIcon image = null;
    private boolean fillEntireArea = false;
    private boolean tileImage = false;

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setFillEntireArea(boolean b) {
        this.fillEntireArea = b;
        this.repaint();
    }

    public boolean getFillEntireArea() {
        return this.fillEntireArea;
    }

    public void setTileImage(boolean b) {
        this.tileImage = b;
        this.repaint();
    }

    public boolean getTileImage() {
        return this.tileImage;
    }

    public void setImage(ImageIcon i) {
        this.image = i;
        this.repaint();
    }

    public ImageIcon getImage() {
        return this.image;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            super.paintComponent(g);
            if (this.image != null) {
                int width = this.getWidth();
                int height = this.getHeight();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
                if (this.fillEntireArea) {
                    g.drawImage(this.image.getImage(), 0, 0, width, height, this);
                } else if (!this.tileImage) {
                    int y;
                    int x;
                    switch (this.alignment) {
                        case 0: {
                            x = 0;
                            y = 0;
                            break;
                        }
                        case 2: {
                            x = width - this.image.getIconWidth();
                            y = height - this.image.getIconHeight();
                            break;
                        }
                        default: {
                            x = (width - this.image.getIconWidth()) / 2;
                            y = (height - this.image.getIconHeight()) / 2;
                        }
                    }
                    g.drawImage(this.image.getImage(), x, y, this);
                } else {
                    int tileW = this.image.getIconWidth();
                    int tileH = this.image.getIconHeight();
                    int ypos = 0;
                    while (height - ypos > 0) {
                        int xpos = 0;
                        while (width - xpos > 0) {
                            this.image.paintIcon(null, g, xpos, ypos);
                            xpos += tileW;
                        }
                        ypos += tileH;
                    }
                }
            }
        }
    }
}

