/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import javax.swing.JComboBox;
import phex.utils.Localizer;

public class BandwidthComboBox
extends JComboBox {
    public static final SpeedDefinition[] SPEED_DEFINITIONS = new SpeedDefinition[]{new SpeedDefinition("Modem", 56), new SpeedDefinition("ISDN", 64), new SpeedDefinition("DualISDN", 128), new SpeedDefinition("DSLCable1", 1024), new SpeedDefinition("T1", 1544), new SpeedDefinition("DSLCable2", 2048), new SpeedDefinition("DSLCable3", 6144), new SpeedDefinition("10LAN", 10000), new SpeedDefinition("DSLCable4", 16384), new SpeedDefinition("T3", 44736), new SpeedDefinition("100LAN", 100000), new SpeedDefinition("1000LAN", 1000000)};

    public BandwidthComboBox() {
        super(SPEED_DEFINITIONS);
    }

    public SpeedDefinition getSelectedSpeedDefinition() {
        return (SpeedDefinition)this.getSelectedItem();
    }

    public static class SpeedDefinition {
        private String representation;
        private int speedInKbps;

        public SpeedDefinition(String aRepresentation, int aSpeedInKbps) {
            this.representation = Localizer.getString(aRepresentation);
            this.speedInKbps = aSpeedInKbps;
        }

        public double getSpeedInKB() {
            return this.speedInKbps / 8;
        }

        public int getSpeedInKbps() {
            return this.speedInKbps;
        }

        public String toString() {
            return this.representation;
        }
    }
}

