/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import phex.gui.actions.FWToggleAction;
import phex.gui.common.GUIRegistry;
import phex.gui.tabs.FWTab;
import phex.utils.Localizer;

public class ToggleTabViewAction
extends FWToggleAction {
    private FWTab tab;

    public ToggleTabViewAction(FWTab aTab) {
        this.tab = aTab;
        Object[] args = new Object[]{this.tab.getName()};
        this.setName(Localizer.getFormatedString("ToggleTabAction", args));
        this.setSmallIcon(this.tab.getIcon());
        this.putValue("MnemonicKey", new Integer(this.tab.getMnemonic()));
        this.putValue("AcceleratorKey", this.tab.getAccelerator());
        this.setSelected(this.tab.getParent() != null);
        this.updateTooltip();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.tab.isShowing() || !this.tab.isDisplayable()) {
            boolean state = !this.isSelected();
            this.setSelected(state);
            GUIRegistry.getInstance().getMainFrame().setTabVisible(this.tab, state);
            this.updateTooltip();
        } else {
            boolean state = !this.isSelected();
            this.setSelected(state);
            this.setSelected(!state);
            GUIRegistry.getInstance().getMainFrame().setSelectedTab(this.tab);
        }
    }

    private void updateTooltip() {
        Object[] args = new Object[]{this.tab.getName()};
        if (this.isSelected()) {
            this.setToolTipText(Localizer.getFormatedString("TTTToggleTabActionHide", args));
        } else {
            this.setToolTipText(Localizer.getFormatedString("TTTToggleTabActionShow", args));
        }
    }

    @Override
    public void refreshActionState() {
    }
}

