/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import phex.common.ManagerController;
import phex.common.log.NLogger;
import phex.gui.actions.FWAction;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.dialogs.CloseOptionsDialog;
import phex.gui.prefs.InterfacePrefs;
import phex.gui.prefs.PhexGuiPrefs;
import phex.prefs.core.PhexCorePrefs;
import phex.servent.Servent;
import phex.utils.Localizer;

public class ExitPhexAction
extends FWAction {
    public ExitPhexAction() {
        super(Localizer.getString("Exit"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Phex.Exit"), Localizer.getString("TTTExitPhex"), new Integer(Localizer.getChar("ExitMnemonic")), KeyStroke.getKeyStroke(Localizer.getString("ExitAccelerator")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            ExitPhexAction.performCloseGUIAction();
        }
        catch (Throwable th) {
            NLogger.error(ExitPhexAction.class, (Object)th, th);
        }
    }

    public static void performCloseGUIAction() {
        if (InterfacePrefs.ShowCloseOptionsDialog.get().booleanValue()) {
            CloseOptionsDialog dialog = new CloseOptionsDialog();
            dialog.setVisible(true);
            if (!dialog.isOkActivated()) {
                return;
            }
        }
        if (InterfacePrefs.MinimizeToBackground.get().booleanValue()) {
            ExitPhexAction.minimizeToBackground();
        } else {
            ExitPhexAction.shutdown();
        }
    }

    private static void minimizeToBackground() {
        GUIRegistry registry = GUIRegistry.getInstance();
        DesktopIndicator indicator = registry.getDesktopIndicator();
        MainFrame frame = registry.getMainFrame();
        if (frame.getState() != 1) {
            frame.setState(1);
        }
        if (indicator != null) {
            indicator.showIndicator();
            frame.setVisible(false);
        }
    }

    public static void shutdown() {
        try {
            ManagerController.shutdownManagers();
            Servent.getInstance().stop();
            PhexCorePrefs.save(true);
            PhexGuiPrefs.save(true);
        }
        catch (Exception exp) {
            NLogger.error(ExitPhexAction.class, (Object)exp, (Throwable)exp);
        }
        GUIRegistry registry = GUIRegistry.getInstance();
        try {
            DesktopIndicator indicator = registry.getDesktopIndicator();
            if (indicator != null) {
                indicator.hideIndicator();
                indicator.removeIndicator();
            }
        }
        catch (Exception exp) {
            NLogger.error(ExitPhexAction.class, (Object)exp, (Throwable)exp);
        }
        try {
            registry.saveGUISettings();
        }
        catch (Exception exp) {
            NLogger.error(ExitPhexAction.class, (Object)exp, (Throwable)exp);
        }
        registry.getMainFrame().dispose();
        try {
            ManagerController.shutdownManagers();
        }
        catch (Exception exp) {
            NLogger.error(ExitPhexAction.class, (Object)exp, (Throwable)exp);
        }
        System.exit(0);
    }

    @Override
    public void refreshActionState() {
    }
}

