/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TimerTask;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.AbstractManager;
import phex.common.AddressCounter;
import phex.common.Environment;
import phex.common.RunnerQueueWorker;
import phex.common.ThreadTracking;
import phex.common.URN;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.LogBuffer;
import phex.common.log.NLogger;
import phex.download.BufferVolumeTracker;
import phex.download.DownloadDataWriter;
import phex.download.MagnetData;
import phex.download.MemoryFile;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SWDownloadWorker;
import phex.event.ContainerEvent;
import phex.msg.QueryResponseMsg;
import phex.prefs.core.DownloadPrefs;
import phex.query.DownloadCandidateSnoop;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.utils.FileUtils;
import phex.utils.StringUtils;
import phex.utils.SubscriptionDownloader;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.downloads.DDownloadFile;
import phex.xml.sax.downloads.DDownloadScope;
import phex.xml.sax.downloads.DDownloadSegment;

public class SwarmingManager
extends AbstractManager {
    public static final short PRIORITY_MOVE_TO_TOP = 0;
    public static final short PRIORITY_MOVE_UP = 1;
    public static final short PRIORITY_MOVE_DOWN = 2;
    public static final short PRIORITY_MOVE_TO_BOTTOM = 3;
    private boolean isManagerShutingDown = false;
    private List<SWDownloadWorker> workerList;
    private List<SWDownloadFile> downloadList;
    private HashMap<URN, SWDownloadFile> urnToDownloadMap;
    private AddressCounter addressDownloadCounter;
    private SWDownloadWorker temporaryWorker;
    private DownloadWorkerLauncher workerLauncher;
    private DownloadDataWriter dataWriter;
    private BufferVolumeTracker downloadWriteBufferTracker;
    private RunnerQueueWorker downloadVerifyRunner;
    private static Object saveDownloadListLock = new Object();
    private SaveDownloadListJob saveDownloadListJob;
    private boolean downloadListChangedSinceSave = false;
    private LogBuffer downloadCandidateLogBuffer;
    private SharedFilesService sharedFilesService;
    private DownloadCandidateSnoop candidateSnoop;

    private SwarmingManager() {
    }

    public static SwarmingManager getInstance() {
        return Holder.manager;
    }

    @Override
    public boolean initialize() {
        this.workerList = new ArrayList<SWDownloadWorker>(5);
        this.downloadList = new ArrayList<SWDownloadFile>(5);
        this.urnToDownloadMap = new HashMap();
        this.addressDownloadCounter = new AddressCounter(DownloadPrefs.MaxDownloadsPerIP.get(), true);
        this.dataWriter = new DownloadDataWriter();
        this.downloadVerifyRunner = new RunnerQueueWorker(4);
        this.downloadWriteBufferTracker = new BufferVolumeTracker(DownloadPrefs.MaxTotalDownloadWriteBuffer.get(), this.dataWriter);
        if (DownloadPrefs.CandidateLogBufferSize.get() > 0) {
            this.downloadCandidateLogBuffer = new LogBuffer(DownloadPrefs.CandidateLogBufferSize.get().intValue());
        }
        return true;
    }

    @Override
    public boolean onPostInitialization() {
        Servent servent = Servent.getInstance();
        servent.getEventService().processAnnotations(this);
        this.sharedFilesService = servent.getSharedFilesService();
        LoadDownloadListJob job = new LoadDownloadListJob();
        job.start();
        this.candidateSnoop = new DownloadCandidateSnoop(this);
        servent.getMessageService().addMessageSubscriber(QueryResponseMsg.class, this.candidateSnoop);
        return true;
    }

    @Override
    public void startupCompletedNotify() {
        this.workerLauncher = new DownloadWorkerLauncher();
        this.workerLauncher.setDaemon(true);
        this.workerLauncher.start();
        this.dataWriter.start();
        Environment.getInstance().scheduleTimerTask(new SaveDownloadListTimer(), 60000L, 60000L);
        new SubscriptionDownloader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        SWDownloadWorker worker;
        int i;
        SwarmingManager swarmingManager = this;
        synchronized (swarmingManager) {
            this.isManagerShutingDown = true;
        }
        if (this.workerLauncher != null) {
            this.workerLauncher.triggerCycle();
        }
        SWDownloadWorker[] workers = new SWDownloadWorker[this.workerList.size()];
        this.workerList.toArray(workers);
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            if (worker == null) continue;
            worker.stopWorker();
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            if (worker == null || !worker.isInsideCriticalSection()) continue;
            worker.waitTillFinished();
        }
        if (this.dataWriter != null) {
            this.dataWriter.shutdown();
        }
        this.shutdownForceSaveDownloadList();
    }

    public DownloadDataWriter getDownloadDataWriter() {
        return this.dataWriter;
    }

    public BufferVolumeTracker getDownloadWriteBufferTracker() {
        return this.downloadWriteBufferTracker;
    }

    public RunnerQueueWorker getDownloadVerifyRunner() {
        return this.downloadVerifyRunner;
    }

    public MemoryFile createMemoryFile(SWDownloadFile file) {
        return new MemoryFile(file, this.downloadWriteBufferTracker, this.dataWriter, this.downloadVerifyRunner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(RemoteFile remoteFile, String filename, String searchTerm) {
        int pos;
        SWDownloadFile downloadFile = new SWDownloadFile(filename, searchTerm, remoteFile.getFileSize(), remoteFile.getURN());
        downloadFile.addDownloadCandidate(remoteFile);
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            pos = this.downloadList.size();
            this.downloadList.add(downloadFile);
            URN urn = downloadFile.getFileURN();
            if (urn != null) {
                this.urnToDownloadMap.put(urn, downloadFile);
            }
        }
        this.fireDownloadFileAdded(downloadFile, pos);
        downloadFile.setStatus(1);
        this.workerLauncher.triggerCycle();
        this.triggerSaveDownloadList(true);
        return downloadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(URI uri, boolean preventDuplicate) throws URIException {
        int pos;
        URN urn;
        MagnetData magnetData;
        if (preventDuplicate && (magnetData = MagnetData.parseFromURI(uri)) != null && (this.isURNDownloaded(urn = MagnetData.lookupSHA1URN(magnetData)) || this.sharedFilesService.isURNShared(urn))) {
            return null;
        }
        if (NLogger.isDebugEnabled(SwarmingManager.class)) {
            NLogger.debug(SwarmingManager.class, (Object)("Adding new download by URI: " + uri.toString()));
        }
        SWDownloadFile downloadFile = new SWDownloadFile(uri);
        urn = downloadFile.getFileURN();
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            pos = this.downloadList.size();
            this.downloadList.add(downloadFile);
            if (urn != null) {
                this.urnToDownloadMap.put(urn, downloadFile);
            }
        }
        this.fireDownloadFileAdded(downloadFile, pos);
        downloadFile.setStatus(1);
        this.workerLauncher.triggerCycle();
        this.triggerSaveDownloadList(true);
        return downloadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(URI uri, String relativeDownloadDir, boolean preventDuplicate) throws URIException {
        int pos;
        SWDownloadFile downloadFile;
        File destinationDir;
        String destDir;
        File destinationDirectory;
        URN urn;
        MagnetData magnetData;
        if (preventDuplicate && (magnetData = MagnetData.parseFromURI(uri)) != null && (this.isURNDownloaded(urn = MagnetData.lookupSHA1URN(magnetData)) || this.sharedFilesService.isURNShared(urn))) {
            return null;
        }
        if (NLogger.isDebugEnabled(SwarmingManager.class)) {
            NLogger.debug(SwarmingManager.class, (Object)("Adding new download by URI: " + uri.toString()));
        }
        if (!(destinationDirectory = new File(destDir = (destinationDir = (downloadFile = new SWDownloadFile(uri)).getDestinationDirectory()) != null ? downloadFile.getDestinationDirectory().toString() : DownloadPrefs.DestinationDirectory.get(), relativeDownloadDir)).exists()) {
            destinationDirectory.mkdir();
        }
        downloadFile.setDestinationDirectory(destinationDirectory);
        URN urn2 = downloadFile.getFileURN();
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            pos = this.downloadList.size();
            this.downloadList.add(downloadFile);
            if (urn2 != null) {
                this.urnToDownloadMap.put(urn2, downloadFile);
            }
        }
        this.fireDownloadFileAdded(downloadFile, pos);
        downloadFile.setStatus(1);
        this.workerLauncher.triggerCycle();
        this.triggerSaveDownloadList(true);
        return downloadFile;
    }

    public void removeDownloadFile(SWDownloadFile file) {
        this.removeDownloadFileInternal(file);
        this.triggerSaveDownloadList(true);
    }

    public void removeDownloadFiles(SWDownloadFile[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.removeDownloadFileInternal(files[i]);
        }
        this.triggerSaveDownloadList(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDownloadFileInternal(SWDownloadFile file) {
        if (!file.isFileCompletedOrMoved() && !file.isDownloadStopped()) {
            file.stopDownload();
        }
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            URN urn;
            int pos = this.downloadList.indexOf(file);
            if (pos >= 0) {
                this.downloadList.remove(pos);
                this.fireDownloadFileRemoved(file, pos);
            }
            if ((urn = file.getFileURN()) != null) {
                this.urnToDownloadMap.remove(urn);
            }
        }
        file.removeIncompleteDownloadFile();
    }

    public Integer getDownloadPriority(SWDownloadFile file) {
        int pos = this.downloadList.indexOf(file);
        if (pos >= 0) {
            return new Integer(pos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDownloadFilePriorities(SWDownloadFile[] files) {
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            for (int i = 0; i < files.length; ++i) {
                int pos = this.downloadList.indexOf(files[i]);
                if (pos < 0) continue;
                int newPos = i;
                if (newPos < 0 || newPos >= this.downloadList.size()) {
                    newPos = pos;
                }
                this.downloadList.remove(pos);
                this.downloadList.add(newPos, files[i]);
                this.fireDownloadFileRemoved(files[i], pos);
                this.fireDownloadFileAdded(files[i], newPos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveDownloadFilePriority(SWDownloadFile file, short moveDirection) {
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            int pos = this.downloadList.indexOf(file);
            if (pos >= 0) {
                int newPos = pos;
                switch (moveDirection) {
                    case 1: {
                        --newPos;
                        break;
                    }
                    case 2: {
                        ++newPos;
                        break;
                    }
                    case 0: {
                        newPos = 0;
                        break;
                    }
                    case 3: {
                        newPos = this.downloadList.size() - 1;
                    }
                }
                if (newPos < 0 || newPos >= this.downloadList.size()) {
                    return pos;
                }
                this.downloadList.remove(pos);
                this.downloadList.add(newPos, file);
                this.fireDownloadFileRemoved(file, pos);
                this.fireDownloadFileAdded(file, newPos);
                return newPos;
            }
            return pos;
        }
    }

    public int getDownloadFileCount() {
        return this.downloadList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadFileCount(int status) {
        int count = 0;
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            for (SWDownloadFile file : this.downloadList) {
                if (file.getStatus() != status) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActiveDownloadFileCount() {
        int count = 0;
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            block6: for (SWDownloadFile file : this.downloadList) {
                switch (file.getStatus()) {
                    case 4: 
                    case 6: {
                        continue block6;
                    }
                }
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadActive() {
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            block6: for (SWDownloadFile file : this.downloadList) {
                switch (file.getStatus()) {
                    case 4: 
                    case 6: {
                        continue block6;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public List<SWDownloadFile> getDownloadFileListCopy() {
        return new ArrayList<SWDownloadFile>(this.downloadList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFile(int index) {
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            if (index < 0 || index >= this.downloadList.size()) {
                return null;
            }
            return this.downloadList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile[] getDownloadFilesAt(int[] indices) {
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            int length = indices.length;
            SWDownloadFile[] files = new SWDownloadFile[length];
            for (int i = 0; i < length; ++i) {
                files[i] = indices[i] < 0 || indices[i] >= this.downloadList.size() ? null : this.downloadList.get(indices[i]);
            }
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFile(long fileSize, URN matchURN) {
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            SWDownloadFile file = this.getDownloadFileByURN(matchURN);
            if (file != null && file.getTotalDataSize() == fileSize) {
                return file;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFileByURN(URN matchURN) {
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            SWDownloadFile file = this.urnToDownloadMap.get(matchURN);
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isURNDownloaded(URN matchURN) {
        if (matchURN == null) {
            return false;
        }
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            return this.urnToDownloadMap.containsKey(matchURN);
        }
    }

    public void releaseCandidateAddress(SWDownloadCandidate candidate) {
        this.addressDownloadCounter.relaseAddress(candidate.getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<SWDownloadFile> getCompletedDownloadFiles() {
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            ArrayList<SWDownloadFile> list2 = new ArrayList<SWDownloadFile>(2);
            for (SWDownloadFile downloadFile : this.downloadList) {
                if (!downloadFile.isFileCompleted()) continue;
                list2.add(downloadFile);
            }
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadSet allocateDownloadSet(SWDownloadWorker worker) {
        List<SWDownloadFile> list = this.downloadList;
        synchronized (list) {
            SWDownloadCandidate downloadCandidate = null;
            for (SWDownloadFile downloadFile : this.downloadList) {
                boolean segmentAvailable;
                if (!downloadFile.isAbleToBeAllocated() || !(segmentAvailable = downloadFile.isScopeAllocateable(null))) continue;
                this.addressDownloadCounter.setMaxCount(DownloadPrefs.MaxDownloadsPerIP.get());
                downloadCandidate = downloadFile.allocateDownloadCandidate(worker, this.addressDownloadCounter);
                if (downloadCandidate == null) continue;
                boolean segmentAllocateable = downloadFile.isScopeAllocateable(downloadCandidate.getAvailableScopeList());
                if (!segmentAllocateable) {
                    downloadFile.releaseDownloadCandidate(downloadCandidate);
                    continue;
                }
                downloadFile.incrementWorkerCount();
                SWDownloadSet set = new SWDownloadSet(Servent.getInstance(), downloadFile, downloadCandidate);
                if (worker == this.temporaryWorker) {
                    this.unsetTemporaryWorker();
                }
                return set;
            }
        }
        return null;
    }

    public LogBuffer getCandidateLogBuffer() {
        return this.downloadCandidateLogBuffer;
    }

    public void notifyDownloadListChange() {
        this.downloadListChangedSinceSave = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerSaveDownloadList(boolean force) {
        if (!force && !this.downloadListChangedSinceSave) {
            return;
        }
        NLogger.debug(SwarmingManager.class, (Object)"Trigger save download list...");
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob != null) {
                this.saveDownloadListJob.triggerFollowUpSave();
            } else {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownForceSaveDownloadList() {
        NLogger.debug(SwarmingManager.class, (Object)"Force save download list...");
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob == null) {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            } else {
                this.saveDownloadListJob.triggerFollowUpSave();
            }
        }
        try {
            if (this.saveDownloadListJob != null) {
                try {
                    this.saveDownloadListJob.setPriority(10);
                    this.saveDownloadListJob.join();
                }
                catch (NullPointerException exp) {}
            }
        }
        catch (InterruptedException exp) {
            NLogger.error(SwarmingManager.class, (Object)exp, (Throwable)exp);
        }
    }

    private synchronized void unsetTemporaryWorker() {
        this.temporaryWorker.setTemporaryWorker(false);
        this.temporaryWorker = null;
        this.workerLauncher.triggerCycle();
    }

    public synchronized void notifyWaitingWorkers() {
        this.notifyAll();
    }

    public synchronized void waitForNotify() throws InterruptedException {
        this.wait(2000L);
    }

    private int getRequiredDownloadWorkerCount() {
        return Math.min(this.getActiveDownloadFileCount() * DownloadPrefs.MaxWorkerPerDownload.get(), DownloadPrefs.MaxTotalDownloadWorker.get());
    }

    public synchronized boolean checkToStopWorker(SWDownloadWorker worker) {
        int requiredCount = this.getRequiredDownloadWorkerCount();
        if (this.isManagerShutingDown || this.workerList.size() > requiredCount) {
            if (worker.isRunning()) {
                worker.stopWorker();
                this.workerList.remove(worker);
                if (worker.isTemporaryWorker()) {
                    this.temporaryWorker = null;
                }
            }
            return true;
        }
        return Thread.interrupted();
    }

    public void notifyWorkerShoutdown(SWDownloadWorker worker, boolean isExpected) {
        NLogger.debug(SwarmingManager.class, (Object)("Worker shutdown: " + worker + ", expected: " + isExpected));
        worker.stopWorker();
        this.workerList.remove(worker);
        if (worker.isTemporaryWorker()) {
            this.temporaryWorker = null;
        }
        this.workerLauncher.triggerCycle();
    }

    @EventTopicSubscriber(topic="phex:download/file/completed")
    public void onDownloadFileCompletedEvent(String topic, SWDownloadFile file) {
    }

    private void fireDownloadFileAdded(SWDownloadFile file, int position) {
        Servent.getInstance().getEventService().publish("phex:download/file", new ContainerEvent(ContainerEvent.Type.ADDED, file, this, position));
    }

    private void fireDownloadFileRemoved(SWDownloadFile file, int position) {
        Servent.getInstance().getEventService().publish("phex:download/file", new ContainerEvent(ContainerEvent.Type.REMOVED, file, this, position));
    }

    @Deprecated
    private static class SWDownloadSegmentComparatorByStartPosition
    implements Comparator<DDownloadSegment> {
        private SWDownloadSegmentComparatorByStartPosition() {
        }

        @Override
        public int compare(DDownloadSegment segment1, DDownloadSegment segment2) {
            long diff = segment1.getStartPos() - segment2.getStartPos();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private class SaveDownloadListJob
    extends Thread {
        private boolean isFollowUpSaveTriggered;

        public SaveDownloadListJob() {
            super(ThreadTracking.rootThreadGroup, "SaveDownloadListJob");
            this.setPriority(1);
        }

        public void triggerFollowUpSave() {
            this.isFollowUpSaveTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                NLogger.debug(SwarmingManager.class, (Object)"Start saving download list...");
                SwarmingManager.this.downloadListChangedSinceSave = false;
                this.isFollowUpSaveTriggered = false;
                try {
                    DPhex dPhex = new DPhex();
                    dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
                    DSubElementList<DDownloadFile> dList = this.createDDownloadList();
                    dPhex.setDownloadList(dList);
                    File downloadFile = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
                    File downloadFileBak = new File(downloadFile.getAbsolutePath() + ".bak");
                    ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(downloadFileBak);
                    XMLBuilder.saveToFile(managedFile, dPhex);
                    FileUtils.copyFile(downloadFileBak, downloadFile);
                }
                catch (ManagedFileException exp) {
                    NLogger.error(SwarmingManager.class, (Object)exp, (Throwable)exp);
                    Environment.getInstance().fireDisplayUserMessage("DownloadSettingsSaveFailed", new String[]{exp.toString()});
                }
                catch (IOException exp) {
                    NLogger.error(SwarmingManager.class, (Object)exp, (Throwable)exp);
                    Environment.getInstance().fireDisplayUserMessage("DownloadSettingsSaveFailed", new String[]{exp.toString()});
                }
            } while (this.isFollowUpSaveTriggered);
            NLogger.debug(SwarmingManager.class, (Object)"Finished saving download list...");
            Object object = saveDownloadListLock;
            synchronized (object) {
                SwarmingManager.this.saveDownloadListJob = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DSubElementList<DDownloadFile> createDDownloadList() {
            DSubElementList<DDownloadFile> dList = new DSubElementList<DDownloadFile>("swDownloadList");
            List list = SwarmingManager.this.downloadList;
            synchronized (list) {
                List<DDownloadFile> list2 = dList.getSubElementList();
                for (SWDownloadFile file : SwarmingManager.this.downloadList) {
                    try {
                        list2.add(file.createDDownloadFile());
                    }
                    catch (Throwable th) {
                        NLogger.error(SwarmingManager.class, (Object)th, th);
                    }
                }
            }
            return dList;
        }
    }

    private class SaveDownloadListTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveDownloadListTimer() {
        }

        @Override
        public void run() {
            try {
                SwarmingManager.this.triggerSaveDownloadList(false);
            }
            catch (Throwable th) {
                NLogger.error(SwarmingManager.class, (Object)th, th);
            }
        }
    }

    private class LoadDownloadListJob
    extends Thread {
        public LoadDownloadListJob() {
            super(ThreadTracking.rootThreadGroup, "LoadDownloadListJob");
        }

        @Override
        public void run() {
            try {
                this.loadDownloadList();
            }
            catch (Throwable th) {
                NLogger.error(SwarmingManager.class, (Object)th, th);
            }
        }

        private void loadDownloadList() {
            NLogger.debug(SwarmingManager.class, (Object)"Loading download list...");
            File downloadFile = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
            File downloadFileBak = new File(downloadFile.getAbsolutePath() + ".bak");
            if (!downloadFile.exists() && !downloadFileBak.exists()) {
                NLogger.debug(SwarmingManager.class, (Object)"No download list file found.");
                return;
            }
            try {
                NLogger.debug(SwarmingManager.class, (Object)"Try to load from default download list.");
                FileManager fileMgr = FileManager.getInstance();
                ManagedFile managedFile = fileMgr.getReadWriteManagedFile(downloadFile);
                DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
                if (dPhex == null) {
                    NLogger.debug(SwarmingManager.class, (Object)"Try to load from backup download list.");
                    ManagedFile managedFileBak = fileMgr.getReadWriteManagedFile(downloadFileBak);
                    dPhex = XMLBuilder.loadDPhexFromFile(managedFileBak);
                }
                if (dPhex == null) {
                    NLogger.debug(SwarmingManager.class, (Object)"No download settings file found.");
                    return;
                }
                DSubElementList<DDownloadFile> dDownloadList = dPhex.getDownloadList();
                if (dDownloadList != null) {
                    String phexVersion = dPhex.getPhexVersion();
                    if (VersionUtils.compare("2.6.4.89", phexVersion) >= 0) {
                        this.load2_6_4_89SWDownloadList(dDownloadList);
                    } else {
                        this.loadXJBSWDownloadList(dDownloadList);
                    }
                } else {
                    NLogger.debug(SwarmingManager.class, (Object)"No SWDownloadList found.");
                }
                SwarmingManager.this.notifyWaitingWorkers();
            }
            catch (IOException exp) {
                NLogger.error(SwarmingManager.class, (Object)exp, (Throwable)exp);
                Environment.getInstance().fireDisplayUserMessage("DownloadSettingsLoadFailed", new String[]{exp.toString()});
                return;
            }
            catch (ManagedFileException exp) {
                NLogger.error(SwarmingManager.class, (Object)exp, (Throwable)exp);
                Environment.getInstance().fireDisplayUserMessage("DownloadSettingsLoadFailed", new String[]{exp.toString()});
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadXJBSWDownloadList(DSubElementList<DDownloadFile> list) {
            List list2 = SwarmingManager.this.downloadList;
            synchronized (list2) {
                NLogger.debug(SwarmingManager.class, (Object)"Loading SWDownload xml");
                SwarmingManager.this.downloadList.clear();
                SwarmingManager.this.urnToDownloadMap.clear();
                for (DDownloadFile dFile : list.getSubElementList()) {
                    try {
                        SWDownloadFile file = new SWDownloadFile(dFile);
                        int pos = SwarmingManager.this.downloadList.size();
                        SwarmingManager.this.downloadList.add(file);
                        URN urn = file.getFileURN();
                        if (urn != null) {
                            SwarmingManager.this.urnToDownloadMap.put(urn, file);
                        }
                        NLogger.debug(SwarmingManager.class, (Object)("Loaded SWDownloadFile: " + file));
                        SwarmingManager.this.fireDownloadFileAdded(file, pos);
                    }
                    catch (Exception exp) {
                        NLogger.error(SwarmingManager.class, (Object)"Error loading a download file from XML.", (Throwable)exp);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        private void load2_6_4_89SWDownloadList(DSubElementList<DDownloadFile> list) {
            List list2 = SwarmingManager.this.downloadList;
            synchronized (list2) {
                NLogger.debug(SwarmingManager.class, (Object)"Loading old download xml.");
                SwarmingManager.this.downloadList.clear();
                SwarmingManager.this.urnToDownloadMap.clear();
                for (DDownloadFile dFile : list.getSubElementList()) {
                    try {
                        File incFile = SWDownloadFile.createIncompleteFile(dFile.getLocalFileName());
                        RandomAccessFile raFile = new RandomAccessFile(incFile, "rwd");
                        DDownloadFile dNewFile = new DDownloadFile();
                        dNewFile.setIncompleteFileName(incFile.getAbsolutePath());
                        dNewFile.setCreationTime(dFile.getCreationTime());
                        dNewFile.setFileSize(dFile.getFileSize());
                        dNewFile.setFileURN(dFile.getFileURN());
                        dNewFile.setLocalFileName(dFile.getLocalFileName());
                        dNewFile.setModificationTime(dFile.getModificationTime());
                        dNewFile.setSearchTerm(dFile.getSearchTerm());
                        dNewFile.setStatus(dFile.getStatus());
                        dNewFile.getCandidateList().getSubElementList().addAll(dFile.getCandidateList().getSubElementList());
                        List<DDownloadSegment> segmentList = dFile.getSegmentList().getSubElementList();
                        ArrayList<DDownloadSegment> tempSegmentList = new ArrayList<DDownloadSegment>(segmentList);
                        Collections.sort(tempSegmentList, new SWDownloadSegmentComparatorByStartPosition());
                        for (DDownloadSegment dSegment : tempSegmentList) {
                            try {
                                int len;
                                File incompleteFile;
                                long transferDataSize = dSegment.getLength();
                                long startPos = dSegment.getStartPos();
                                long transferredDataSize = 0L;
                                String incompleteFileName = dSegment.getIncompleteFileName();
                                if (StringUtils.isEmpty(incompleteFileName) || !(incompleteFile = new File(dSegment.getIncompleteFileName())).exists() || (transferredDataSize = incompleteFile.length()) == 0L) continue;
                                if (transferDataSize != -1L && transferredDataSize > transferDataSize) {
                                    try {
                                        FileUtils.truncateFile(incompleteFile, transferDataSize);
                                        transferredDataSize = transferDataSize;
                                    }
                                    catch (IOException exp) {
                                        NLogger.error(SwarmingManager.class, (Object)exp, (Throwable)exp);
                                    }
                                }
                                raFile.setLength(startPos + transferredDataSize);
                                raFile.seek(startPos);
                                FileInputStream fIn = new FileInputStream(incompleteFile);
                                byte[] buffer = new byte[16384];
                                while ((len = fIn.read(buffer, 0, buffer.length)) > 0) {
                                    raFile.write(buffer, 0, len);
                                }
                                fIn.close();
                                FileUtils.deleteFileMultiFallback(incompleteFile);
                                DDownloadScope scope = new DDownloadScope("unverified-scopes");
                                scope.setStart(startPos);
                                scope.setEnd(startPos + transferredDataSize - 1L);
                                dNewFile.getUnverifiedScopesList().getSubElementList().add(scope);
                            }
                            catch (Throwable th) {
                                NLogger.error(SwarmingManager.class, (Object)"Failed to convert segment.", th);
                            }
                        }
                        raFile.close();
                        SWDownloadFile file = new SWDownloadFile(dNewFile);
                        int pos = SwarmingManager.this.downloadList.size();
                        SwarmingManager.this.downloadList.add(file);
                        URN urn = file.getFileURN();
                        if (urn != null) {
                            SwarmingManager.this.urnToDownloadMap.put(urn, file);
                        }
                        NLogger.debug(SwarmingManager.class, (Object)("Converted SWDownloadFile: " + file));
                        SwarmingManager.this.fireDownloadFileAdded(file, pos);
                    }
                    catch (Exception exp) {
                        NLogger.error(SwarmingManager.class, (Object)"Failed to convert a download file from XML.", (Throwable)exp);
                    }
                }
            }
        }
    }

    private class DownloadWorkerLauncher
    extends Thread {
        public DownloadWorkerLauncher() {
            super(ThreadTracking.rootThreadGroup, "DownloadWorkerLauncher");
        }

        @Override
        public void run() {
            while (!SwarmingManager.this.isManagerShutingDown) {
                try {
                    this.createRequiredWorker();
                    this.waitForNextCycle();
                }
                catch (Throwable th) {
                    NLogger.error(SwarmingManager.class, (Object)th, th);
                }
            }
        }

        public synchronized void triggerCycle() {
            this.notify();
        }

        private synchronized void waitForNextCycle() throws InterruptedException {
            this.wait(2000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createRequiredWorker() {
            SwarmingManager swarmingManager = SwarmingManager.this;
            synchronized (swarmingManager) {
                int requiredCount = SwarmingManager.this.getRequiredDownloadWorkerCount();
                if (SwarmingManager.this.temporaryWorker == null && SwarmingManager.this.workerList.size() < requiredCount) {
                    SwarmingManager.this.temporaryWorker = new SWDownloadWorker();
                    SwarmingManager.this.temporaryWorker.setTemporaryWorker(true);
                    SwarmingManager.this.temporaryWorker.startWorker();
                    SwarmingManager.this.workerList.add(SwarmingManager.this.temporaryWorker);
                    NLogger.debug(SwarmingManager.class, (Object)("Creating new worker: " + SwarmingManager.this.temporaryWorker + " for a total of: " + SwarmingManager.this.workerList.size()));
                }
            }
        }
    }

    private static class Holder {
        protected static final SwarmingManager manager = new SwarmingManager();

        private Holder() {
        }
    }
}

