/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import phex.common.ThreadPool;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;
import phex.connection.ConnectionFailedException;
import phex.download.DownloadConnection;
import phex.download.DownloadEngine;
import phex.download.PushHandler;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SwarmingManager;
import phex.net.repres.SocketFacade;
import phex.prefs.core.NetworkPrefs;
import phex.servent.Servent;

public class SWDownloadWorker
implements Runnable {
    private volatile boolean isTemporaryWorker;
    private volatile boolean isRunning;
    private ThreadPool.Job threadJob;
    private DownloadEngine downloadEngine;
    private volatile boolean insideCriticalSection;
    private volatile boolean isDownloadStopped;

    public void setTemporaryWorker(boolean state) {
        this.isTemporaryWorker = state;
    }

    public boolean isTemporaryWorker() {
        return this.isTemporaryWorker;
    }

    public boolean isInsideCriticalSection() {
        return this.insideCriticalSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SwarmingManager swarmingMgr = SwarmingManager.getInstance();
        try {
            boolean isStopped;
            while (this.isRunning && !(isStopped = swarmingMgr.checkToStopWorker(this))) {
                this.isDownloadStopped = false;
                NLogger.debug(SWDownloadWorker.class, (Object)(" - Allocating DownloadSet - " + this));
                SWDownloadSet downloadSet = swarmingMgr.allocateDownloadSet(this);
                if (downloadSet == null) {
                    if (!this.isTemporaryWorker) break;
                    try {
                        swarmingMgr.waitForNotify();
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                NLogger.debug(SWDownloadWorker.class, (Object)("Allocated DownloadSet: " + downloadSet.toString() + " - " + this));
                try {
                    this.handleDownload(downloadSet);
                }
                finally {
                    NLogger.debug(SWDownloadWorker.class, (Object)("Releasing DownloadSet: " + downloadSet.toString() + " - " + this));
                    downloadSet.releaseDownloadSet();
                }
            }
            swarmingMgr.notifyWorkerShoutdown(this, !this.isRunning);
        }
        catch (Throwable throwable) {
            swarmingMgr.notifyWorkerShoutdown(this, !this.isRunning);
            NLogger.debug(SWDownloadWorker.class, (Object)("Download worker finished: " + this));
            throw throwable;
        }
        NLogger.debug(SWDownloadWorker.class, (Object)("Download worker finished: " + this));
    }

    public void startWorker() {
        this.isRunning = true;
        this.threadJob = ThreadPool.getInstance().addJob(this, "SWDownloadWorker-" + Integer.toHexString(this.hashCode()));
        NLogger.debug(SWDownloadWorker.class, (Object)("Started SWDownloadWorker " + this));
    }

    public void stopWorker() {
        Thread thread;
        NLogger.debug(SWDownloadWorker.class, (Object)("Download worker has been instructed to stop running: " + this));
        this.isRunning = false;
        this.isDownloadStopped = true;
        if (this.downloadEngine != null) {
            this.downloadEngine.abortDownload();
            this.downloadEngine = null;
        }
        if ((thread = this.threadJob.getAssociatedThread()) != null) {
            thread.interrupt();
        }
    }

    public void waitTillFinished() {
        while (this.threadJob.getAssociatedThread() != null) {
            this.threadJob.waitForAssociatedThreadRelease();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownload(SWDownloadSet downloadSet) {
        NLogger.debug(SWDownloadWorker.class, (Object)("handleDownload() with: " + downloadSet + " - " + this));
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        SWDownloadCandidate downloadCandidate = downloadSet.getCandidate();
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        if (downloadCandidate.isPushNeeded()) {
            this.connectDownloadEngineViaPush(downloadSet, false);
        } else {
            this.connectDownloadEngine(downloadSet);
        }
        if (this.downloadEngine == null) {
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        try {
            this.insideCriticalSection = true;
            this.startDownload(downloadSet);
        }
        finally {
            downloadFile.removeQueuedCandidate(downloadCandidate);
            this.downloadEngine = null;
            NLogger.debug(SWDownloadWorker.class, (Object)("Releasing DownloadSegment: " + downloadSet.toString() + " - " + this));
            downloadSet.releaseDownloadSegment();
            downloadFile.verifyStatus();
            this.insideCriticalSection = false;
        }
    }

    private void connectDownloadEngine(SWDownloadSet downloadSet) {
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        NLogger.debug(SWDownloadWorker.class, (Object)("connectDownloadEngine with: " + downloadSet + " - " + this));
        SWDownloadCandidate downloadCandidate = downloadSet.getCandidate();
        this.downloadEngine = null;
        try {
            DownloadConnection connection = new DownloadConnection(downloadCandidate);
            connection.connect(NetworkPrefs.TcpConnectTimeout.get());
            if (!this.isRunning || this.isDownloadStopped) {
                return;
            }
            this.downloadEngine = new DownloadEngine(downloadSet);
            this.downloadEngine.setConnection(connection);
        }
        catch (ConnectionFailedException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug(SWDownloadWorker.class, (Object)exp.toString());
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
        catch (SocketTimeoutException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug(SWDownloadWorker.class, (Object)exp.toString());
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
        catch (UnknownHostException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug(SWDownloadWorker.class, (Object)exp.toString());
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
        catch (IOException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.error(SWDownloadWorker.class, (Object)("HardError at Host: " + downloadCandidate.getHostAddress() + " Vendor: " + downloadCandidate.getVendor()), (Throwable)exp);
            assert (this.downloadEngine == null) : "Download Engine is initialized. If this can possible happen we need to stop it.";
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
    }

    private void connectDownloadEngineViaPush(SWDownloadSet downloadSet, boolean failedBefore) {
        boolean isLANReachable;
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        NLogger.debug(SWDownloadWorker.class, (Object)("connectDownloadEngineViaPush with: " + downloadSet + " - " + this));
        SWDownloadCandidate downloadCandidate = downloadSet.getCandidate();
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        this.downloadEngine = null;
        IpAddress ipAddress = downloadCandidate.getHostAddress().getIpAddress();
        boolean bl = isLANReachable = NetworkPrefs.ConnectedToLAN.get() != false && ipAddress != null && ipAddress.isSiteLocalIP();
        if (downloadCandidate.getStatus() == SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED) {
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTING, -1, "Forced status switch.");
        }
        if (downloadSet.getServent().isFirewalled() && !isLANReachable) {
            NLogger.debug(SWDownloadWorker.class, (Object)(this.toString() + downloadCandidate.toString() + " Cant PUSH -> I'm firewalled and candidate not reachable by LAN"));
            downloadCandidate.addToCandidateLog("Cant PUSH -> I'm firewalled and candidate not reachable by LAN");
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            if (downloadCandidate.isPushNeeded()) {
                downloadFile.markCandidateBad(downloadCandidate);
            }
            return;
        }
        if (downloadCandidate.getGUID() == null) {
            NLogger.debug(SWDownloadWorker.class, (Object)(this.toString() + downloadCandidate.toString() + " Cant PUSH -> No candidate GUID."));
            downloadCandidate.addToCandidateLog("Cant PUSH -> No candidate GUID.");
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            if (failedBefore) {
                downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            }
            return;
        }
        downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.PUSH_REQUEST);
        SocketFacade socket = PushHandler.requestSocketViaPush(Servent.getInstance(), downloadCandidate);
        if (socket == null) {
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            if (downloadCandidate.isPushNeeded()) {
                downloadFile.markCandidateIgnored(downloadCandidate, "CandidateStatusReason_PushRouteFailed");
            }
            NLogger.debug(SWDownloadWorker.class, (Object)("Push request fails for candidate: " + downloadCandidate));
            downloadCandidate.addToCandidateLog("Push request fails for candidate: " + downloadCandidate);
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        DownloadConnection connection = new DownloadConnection(downloadCandidate, socket);
        this.downloadEngine = new DownloadEngine(downloadSet);
        this.downloadEngine.setConnection(connection);
    }

    private void startDownload(SWDownloadSet downloadSet) {
        NLogger.debug(SWDownloadWorker.class, (Object)("startDownload with: " + downloadSet + " - " + this));
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        SWDownloadCandidate downloadCandidate = downloadSet.getCandidate();
        downloadCandidate.addToCandidateLog("Start download.");
        downloadFile.addGoodAltLoc(downloadCandidate);
        downloadFile.markCandidateGood(downloadCandidate);
        this.downloadEngine.runEngine();
    }

    public String toString() {
        return "[SWDownloadWorker@" + Integer.toHexString(this.hashCode()) + ":running:" + this.isRunning + ",tempWorker:" + this.isTemporaryWorker + ",engine:" + this.downloadEngine + "]";
    }
}

