/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.common.log.NLogger;
import phex.download.DownloadScope;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.servent.Servent;

public class SWDownloadSet {
    private final Servent servent;
    private final SWDownloadFile downloadFile;
    private final SWDownloadCandidate downloadCandidate;
    private DownloadScope downloadScope;
    private SWDownloadSegment downloadSegment;

    public SWDownloadSet(Servent servent, SWDownloadFile aDownloadFile, SWDownloadCandidate aDownloadCandidate) {
        this.servent = servent;
        this.downloadFile = aDownloadFile;
        this.downloadCandidate = aDownloadCandidate;
        this.downloadScope = null;
    }

    public Servent getServent() {
        return this.servent;
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    public SWDownloadCandidate getCandidate() {
        return this.downloadCandidate;
    }

    public SWDownloadSegment allocateSegment() {
        NLogger.debug(SWDownloadSet.class, (Object)("Allocate segment on set " + this));
        if (this.downloadScope == null) {
            this.downloadScope = this.downloadFile.allocateDownloadScope(this.downloadCandidate.getAvailableScopeList(), this.downloadCandidate.getPreferredSegmentSize(), this.downloadCandidate.getSpeed());
            if (this.downloadScope != null) {
                this.downloadSegment = this.downloadScope.getEnd() == Long.MAX_VALUE ? new SWDownloadSegment(this.downloadFile, this.downloadScope.getStart(), -1L) : new SWDownloadSegment(this.downloadFile, this.downloadScope.getStart(), this.downloadScope.getLength());
                this.downloadCandidate.associateDownloadSegment(this.downloadSegment);
            }
            NLogger.debug(SWDownloadSet.class, (Object)("Allocated segment: " + this.downloadSegment + " on set " + this));
            this.downloadCandidate.addToCandidateLog("Allocated segment: " + this.downloadSegment + " - " + this.downloadScope);
        }
        if (this.downloadSegment == null) {
            return null;
        }
        return this.downloadSegment;
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public void releaseDownloadSegment() {
        if (this.downloadSegment != null) {
            NLogger.debug(SWDownloadSet.class, (Object)("Release file download segment: " + this.downloadSegment + " on set " + this));
            this.downloadFile.releaseDownloadScope(this.downloadScope, this.downloadSegment.getTransferredDataSize());
            this.downloadCandidate.addToCandidateLog("Release segment: " + this.downloadSegment + " - " + this.downloadScope);
            this.downloadSegment = null;
            this.downloadScope = null;
        }
        NLogger.debug(SWDownloadSet.class, (Object)("Release candidate download segment on set " + this));
        this.downloadCandidate.releaseDownloadSegment();
    }

    public void releaseDownloadSet() {
        NLogger.debug(SWDownloadSet.class, (Object)("Release download set on set " + this));
        this.releaseDownloadSegment();
        this.downloadFile.releaseDownloadCandidate(this.downloadCandidate);
        this.downloadFile.decrementWorkerCount();
    }

    public String toString() {
        return "[DownloadSet@" + Integer.toHexString(this.hashCode()) + ": (Segment: " + this.downloadSegment + " - Candidate: " + this.downloadCandidate + " - File: " + this.downloadFile + ")]";
    }
}

