/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.LogRecord;
import phex.common.log.NLogger;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SwarmingManager;
import phex.http.HTTPRangeSet;
import phex.http.Range;
import phex.http.XQueueParameters;
import phex.msg.GUID;
import phex.net.repres.PresentationManager;
import phex.prefs.core.DownloadPrefs;
import phex.query.QueryHitHost;
import phex.utils.URLCodecUtils;
import phex.utils.URLUtil;
import phex.xml.XMLUtils;
import phex.xml.sax.downloads.DDownloadCandidate;

public class SWDownloadCandidate
implements SWDownloadConstants {
    private long lastConnectionTime;
    private int failedConnectionTries;
    private GUID guid;
    private long fileIndex;
    private URN resourceURN;
    private URI downloadURI;
    private ThexStatus thexStatus;
    private String thexUri;
    private String thexRoot;
    private String fileName;
    private int lastTransferRateBPS;
    private DestAddress hostAddress;
    private CandidateStatus status;
    private String statusReason;
    private CandidateStatus errorStatus;
    private long statusTimeout;
    private int errorStatusRepetition;
    private String vendor;
    private boolean isG2FeatureAdded;
    private boolean isPushNeeded;
    private DestAddress[] pushProxyAddresses;
    private boolean isChatSupported;
    private DownloadScopeList availableScopeList = null;
    private long availableRangeSetTime = 0L;
    private SWDownloadFile downloadFile;
    private SWDownloadSegment downloadSegment;
    private XQueueParameters xQueueParameters;
    private Set<AlternateLocation> sendAltLocSet;
    private long totalDownloadSize;

    public SWDownloadCandidate(RemoteFile remoteFile, SWDownloadFile aDownloadFile) {
        this.downloadFile = aDownloadFile;
        this.fileIndex = remoteFile.getFileIndex();
        this.fileName = remoteFile.getFilename();
        this.resourceURN = remoteFile.getURN();
        this.guid = remoteFile.getRemoteClientID();
        QueryHitHost qhHost = remoteFile.getQueryHitHost();
        this.vendor = qhHost.getVendor();
        this.isPushNeeded = qhHost.isPushNeeded();
        this.hostAddress = remoteFile.getHostAddress();
        this.isChatSupported = qhHost.isChatSupported();
        this.pushProxyAddresses = qhHost.getPushProxyAddresses();
        this.status = CandidateStatus.WAITING;
        this.thexStatus = ThexStatus.OPEN;
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        this.lastConnectionTime = 0L;
    }

    public SWDownloadCandidate(DestAddress aHostAddress, long aFileIndex, String aFileName, URN aResourceURN, SWDownloadFile aDownloadFile) {
        this.downloadFile = aDownloadFile;
        this.fileIndex = aFileIndex;
        this.fileName = aFileName;
        this.resourceURN = aResourceURN;
        this.guid = null;
        this.vendor = null;
        this.isPushNeeded = false;
        this.isChatSupported = true;
        this.hostAddress = aHostAddress;
        this.status = CandidateStatus.WAITING;
        this.thexStatus = ThexStatus.OPEN;
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        this.lastConnectionTime = 0L;
    }

    public SWDownloadCandidate(DestAddress address, URI downloadUri, SWDownloadFile file) throws URIException {
        this.downloadFile = file;
        this.fileName = URLUtil.getPathQueryFromUri(downloadUri);
        this.downloadURI = downloadUri;
        this.resourceURN = URLUtil.getQueryURN(downloadUri);
        this.guid = null;
        this.vendor = null;
        this.isPushNeeded = false;
        this.isChatSupported = true;
        this.hostAddress = address;
        this.status = CandidateStatus.WAITING;
        this.thexStatus = ThexStatus.OPEN;
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        this.lastConnectionTime = 0L;
    }

    public SWDownloadCandidate(DDownloadCandidate dCandidate, SWDownloadFile aDownloadFile) throws MalformedDestAddressException {
        String resourceUrnStr;
        String downloadUriStr;
        this.downloadFile = aDownloadFile;
        this.fileIndex = dCandidate.getFileIndex();
        this.fileName = dCandidate.getFileName();
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        String guidHexStr = dCandidate.getGuid();
        if (guidHexStr != null) {
            this.guid = new GUID(guidHexStr);
        }
        if ((downloadUriStr = dCandidate.getDownloadUri()) != null) {
            try {
                this.downloadURI = new URI(downloadUriStr, true);
            }
            catch (URIException exp) {
                NLogger.warn(SWDownloadCandidate.class, (Object)("Malformed URI in: " + aDownloadFile.toString() + " - " + downloadUriStr + " - " + this.toString()), (Throwable)exp);
            }
        }
        if ((resourceUrnStr = dCandidate.getResourceUrn()) != null) {
            this.resourceURN = new URN(resourceUrnStr);
        } else if (this.downloadURI == null) {
            this.resourceURN = aDownloadFile.getFileURN();
        }
        this.vendor = dCandidate.getVendor();
        this.isPushNeeded = dCandidate.isPushNeeded();
        this.isChatSupported = dCandidate.isChatSupported();
        this.lastConnectionTime = dCandidate.isSetLastConnectionTime() ? dCandidate.getLastConnectionTime() : 0L;
        try {
            this.hostAddress = PresentationManager.getInstance().createHostAddress(dCandidate.getRemoteHost(), 6346);
        }
        catch (MalformedDestAddressException exp) {
            NLogger.warn(SWDownloadCandidate.class, (Object)("Malformed host address in: " + aDownloadFile.toString() + " - " + dCandidate.getRemoteHost() + " - " + this.toString()), (Throwable)exp);
            throw exp;
        }
        if (dCandidate.getConnectionFailedRepetition() > 0) {
            this.errorStatus = CandidateStatus.CONNECTION_FAILED;
            this.status = CandidateStatus.CONNECTION_FAILED;
            this.failedConnectionTries = this.errorStatusRepetition = dCandidate.getConnectionFailedRepetition();
        } else {
            this.status = CandidateStatus.WAITING;
        }
        this.thexStatus = ThexStatus.OPEN;
    }

    public String getDownloadRequestUrl() {
        String requestUrl2;
        if (this.downloadURI != null) {
            try {
                String requestUrl2 = URLUtil.getPathQueryFromUri(this.downloadURI);
                return requestUrl2;
            }
            catch (URIException e) {
                NLogger.warn(SWDownloadCandidate.class, (Object)e, (Throwable)e);
            }
        }
        if (this.resourceURN != null) {
            requestUrl2 = URLUtil.buildName2ResourceURL(this.resourceURN);
        } else {
            String fileIndexStr = String.valueOf(this.fileIndex);
            StringBuffer urlBuffer = new StringBuffer(6 + fileIndexStr.length() + this.fileName.length());
            urlBuffer.append("/get/");
            urlBuffer.append(fileIndexStr);
            urlBuffer.append('/');
            urlBuffer.append(URLCodecUtils.encodeURL(this.fileName));
            requestUrl2 = urlBuffer.toString();
        }
        return requestUrl2;
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    public long getSpeed() {
        return this.lastTransferRateBPS;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URN getResourceURN() {
        return this.resourceURN;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public long getTotalDownloadSize() {
        return this.totalDownloadSize;
    }

    public void incTotalDownloadSize(int val) {
        this.totalDownloadSize += (long)val;
    }

    public long getStatusTimeLeft() {
        long timeLeft = this.statusTimeout - System.currentTimeMillis();
        if (timeLeft < 0L) {
            timeLeft = 0L;
        }
        return timeLeft;
    }

    public CandidateStatus getStatus() {
        return this.status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public int getFailedConnectionTries() {
        return this.failedConnectionTries;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String aVendor) {
        if (this.vendor == null || !this.vendor.equals(aVendor)) {
            for (int i = 0; i < aVendor.length(); ++i) {
                if (XMLUtils.isXmlChar(aVendor.charAt(i))) continue;
                return;
            }
            this.vendor = aVendor;
            this.addToCandidateLog("Set vendor to: " + this.vendor);
        }
    }

    public boolean isG2FeatureAdded() {
        return this.isG2FeatureAdded;
    }

    public void setG2FeatureAdded(boolean state) {
        this.isG2FeatureAdded = state;
    }

    public void updateXQueueParameters(XQueueParameters newXQueueParameters) {
        if (this.xQueueParameters == null) {
            this.xQueueParameters = newXQueueParameters;
        } else {
            this.xQueueParameters.update(newXQueueParameters);
        }
    }

    public XQueueParameters getXQueueParameters() {
        return this.xQueueParameters;
    }

    public boolean isPushNeeded() {
        return this.isPushNeeded;
    }

    public DestAddress[] getPushProxyAddresses() {
        return this.pushProxyAddresses;
    }

    public void setPushProxyAddresses(DestAddress[] addresses) {
        this.pushProxyAddresses = addresses;
    }

    public long getLastConnectionTime() {
        return this.lastConnectionTime;
    }

    public void setLastConnectionTime(long lastConnectionTime) {
        this.lastConnectionTime = lastConnectionTime;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setChatSupported(boolean state) {
        this.isChatSupported = state;
    }

    public boolean isRemotlyQueued() {
        return this.status == CandidateStatus.REMOTLY_QUEUED;
    }

    public boolean isBusyOrQueued() {
        return this.status == CandidateStatus.BUSY || this.status == CandidateStatus.REMOTLY_QUEUED;
    }

    public boolean isRangeUnavailable() {
        return this.status == CandidateStatus.RANGE_UNAVAILABLE;
    }

    public boolean isDownloading() {
        return this.status == CandidateStatus.DOWNLOADING;
    }

    public boolean isThexSupported() {
        return this.thexUri != null && this.thexRoot != null && this.thexStatus == ThexStatus.OPEN;
    }

    public String getThexUri() {
        return this.thexUri;
    }

    public String getThexRoot() {
        return this.thexRoot;
    }

    public void setThexUriRoot(String thexUri, String thexRoot) {
        this.thexUri = thexUri;
        this.thexRoot = thexRoot;
    }

    public void setThexStatus(ThexStatus thexStatus) {
        this.thexStatus = thexStatus;
    }

    public Set<AlternateLocation> getSendAltLocsSet() {
        if (this.sendAltLocSet == null) {
            this.sendAltLocSet = new HashSet<AlternateLocation>();
        }
        return this.sendAltLocSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailableRangeSet(HTTPRangeSet newRangeSet) {
        if ((newRangeSet == null || newRangeSet.size() == 0) && this.availableScopeList == null) {
            return;
        }
        long fileSize = this.downloadFile.getTotalDataSize();
        if (fileSize == -1L) {
            return;
        }
        if (newRangeSet == null) {
            this.availableScopeList = null;
            return;
        }
        SWDownloadCandidate sWDownloadCandidate = this;
        synchronized (sWDownloadCandidate) {
            this.availableScopeList = new DownloadScopeList();
            Iterator<Range> iterator = newRangeSet.getIterator();
            while (iterator.hasNext()) {
                Range range = iterator.next();
                long start = range.getStartOffset(fileSize);
                long end = range.getEndOffset(fileSize);
                if (end < start) {
                    NLogger.warn(SWDownloadCandidate.class, (Object)("Invalid range: " + range.buildHTTPRangeString() + " - " + start + " - " + end + " - " + fileSize + " - " + this.vendor));
                    continue;
                }
                DownloadScope scope = new DownloadScope(start, end);
                this.availableScopeList.add(scope);
            }
            this.availableRangeSetTime = System.currentTimeMillis();
        }
        NLogger.debug(SWDownloadCandidate.class, (Object)("Added new rangeset for " + this.downloadFile.getFileName() + ": " + newRangeSet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScopeList getAvailableScopeList() {
        if (System.currentTimeMillis() > this.availableRangeSetTime + 600000L) {
            this.setAvailableRangeSet(null);
        }
        SWDownloadCandidate sWDownloadCandidate = this;
        synchronized (sWDownloadCandidate) {
            return this.availableScopeList;
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 17;
        result = 31 * result + (this.hostAddress == null ? 0 : ((Object)this.hostAddress).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SWDownloadCandidate other = (SWDownloadCandidate)obj;
        return !(this.hostAddress == null ? other.hostAddress != null : !this.hostAddress.equals(other.hostAddress));
    }

    public void setStatus(CandidateStatus newStatus) {
        this.setStatus(newStatus, -1, null);
    }

    public void setStatus(CandidateStatus newStatus, int statusSeconds) {
        this.setStatus(newStatus, statusSeconds, null);
    }

    public void setStatus(CandidateStatus newStatus, int statusSeconds, String aStatusReason) {
        long newStatusTimeout;
        if (this.status == newStatus) {
            return;
        }
        CandidateStatus oldStatus = this.status;
        this.status = newStatus;
        if (System.currentTimeMillis() < this.statusTimeout && NLogger.isWarnEnabled(SWDownloadCandidate.class)) {
            NLogger.warn(SWDownloadCandidate.class, (Object)"Status timeout has not passed yet.");
        }
        this.statusTimeout = newStatusTimeout = System.currentTimeMillis();
        switch (this.status) {
            case BAD: {
                newStatusTimeout += 10800000L;
                break;
            }
            case IGNORED: {
                newStatusTimeout = Long.MAX_VALUE;
                break;
            }
            case CONNECTING: {
                break;
            }
            case CONNECTION_FAILED: {
                ++this.failedConnectionTries;
                if (this.failedConnectionTries >= 12) {
                    this.downloadFile.markCandidateIgnored(this, "CandidateStatusReason_ConnectionFailed");
                    newStatusTimeout = this.statusTimeout;
                    aStatusReason = this.statusReason;
                    break;
                }
                if (this.failedConnectionTries >= 3) {
                    this.downloadFile.markCandidateBad(this);
                    newStatusTimeout = this.statusTimeout;
                    break;
                }
                this.downloadFile.markCandidateMedium(this);
                newStatusTimeout += this.calculateConnectionFailedTimeout();
                break;
            }
            case REQUESTING: {
                this.failedConnectionTries = 0;
                break;
            }
            case BUSY: 
            case RANGE_UNAVAILABLE: 
            case REMOTLY_QUEUED: {
                this.failedConnectionTries = 0;
                if (statusSeconds > 0) {
                    newStatusTimeout += (long)(statusSeconds * 1000);
                    break;
                }
                newStatusTimeout += this.determineErrorStatusTimeout(this.status);
                break;
            }
            case PUSH_REQUEST: {
                newStatusTimeout += (long)DownloadPrefs.PushRequestTimeout.get().intValue();
                break;
            }
            case DOWNLOADING: {
                this.errorStatus = CandidateStatus.WAITING;
                this.failedConnectionTries = 0;
            }
        }
        this.statusReason = aStatusReason;
        NLogger.debug(SWDownloadCandidate.class, (Object)("Setting status from " + (Object)((Object)oldStatus) + " to " + (Object)((Object)newStatus) + " and raise timeout from " + this.statusTimeout + " to " + newStatusTimeout + "(" + (newStatusTimeout - this.statusTimeout) + ") Reason:" + aStatusReason + "."));
        this.addToCandidateLog("Setting status to " + SWDownloadInfo.getDownloadCandidateStatusString(this) + " and raise timeout from " + this.statusTimeout + " to " + newStatusTimeout + "(" + (newStatusTimeout - this.statusTimeout) + ") Reason:" + aStatusReason + ". OldStatus: " + (Object)((Object)oldStatus));
        this.statusTimeout = newStatusTimeout;
        this.downloadFile.candidateStatusChanged(this, oldStatus, newStatus);
    }

    private long calculateConnectionFailedTimeout() {
        return 120000L * (long)Math.pow(2.0, Math.min(this.failedConnectionTries - 1, 7)) + (long)((this.failedConnectionTries - 1) * 2);
    }

    private long determineErrorStatusTimeout(CandidateStatus aErrorStatus) {
        if (this.errorStatus == aErrorStatus) {
            ++this.errorStatusRepetition;
        } else {
            this.errorStatus = aErrorStatus;
            this.errorStatusRepetition = 0;
        }
        switch (this.errorStatus) {
            case BUSY: {
                return 60000L;
            }
            case RANGE_UNAVAILABLE: {
                return 60000L * (long)Math.pow(2.0, this.errorStatusRepetition);
            }
            case REMOTLY_QUEUED: {
                if (this.xQueueParameters == null) {
                    return 0L;
                }
                return this.xQueueParameters.getRequestSleepTime();
            }
        }
        NLogger.warn(SWDownloadCandidate.class, (Object)("Unknown error status: " + (Object)((Object)this.errorStatus)));
        return 0L;
    }

    public void manualConnectionRetry() {
        if (this.status != CandidateStatus.BUSY && this.status != CandidateStatus.CONNECTION_FAILED && this.status != CandidateStatus.RANGE_UNAVAILABLE && this.status != CandidateStatus.BAD && this.status != CandidateStatus.IGNORED) {
            return;
        }
        this.setStatus(CandidateStatus.WAITING);
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    public boolean isAbleToBeAllocated() {
        if (this.lastTransferRateBPS < DownloadPrefs.CandidateMinAllowedTransferRate.get() && this.lastTransferRateBPS > 0) {
            this.addToCandidateLog("Refusing candidate allocation as last transfer rate was only " + this.lastTransferRateBPS + " bps");
            NLogger.debug(SWDownloadCandidate.class, (Object)("Refusing candidate allocation as last transfer rate was only " + this.lastTransferRateBPS + " bps"));
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return this.statusTimeout <= currentTime;
    }

    public void associateDownloadSegment(SWDownloadSegment aSegment) {
        this.downloadSegment = aSegment;
    }

    public long getPreferredSegmentSize() {
        long result;
        if (this.lastTransferRateBPS == 0) {
            result = DownloadPrefs.SegmentInitialSize.get().intValue();
        } else {
            long remainder;
            result = Math.max(this.lastTransferRateBPS * DownloadPrefs.SegmentTransferTargetTime.get(), DownloadPrefs.SegmentMultiple.get());
            if ((result += (remainder = -result % (long)DownloadPrefs.SegmentMultiple.get().intValue())) > (long)DownloadPrefs.SegmentMaximumSize.get().intValue()) {
                result = DownloadPrefs.SegmentMaximumSize.get().intValue();
            }
        }
        if (result < 1L) {
            NLogger.warn(SWDownloadCandidate.class, (Object)("Preferred size looks strange. bps=" + this.lastTransferRateBPS + " and stt=" + DownloadPrefs.SegmentTransferTargetTime.get() + " res " + result + " res1 " + this.lastTransferRateBPS * DownloadPrefs.SegmentTransferTargetTime.get() + " res2 " + -result % (long)DownloadPrefs.SegmentMultiple.get().intValue()));
            result = DownloadPrefs.SegmentInitialSize.get().intValue();
        }
        NLogger.debug(SWDownloadCandidate.class, (Object)("Preferred segment size is " + result));
        return result;
    }

    public void releaseDownloadSegment() {
        if (this.downloadSegment != null) {
            this.lastTransferRateBPS = this.downloadSegment.getLongTermTransferRate();
            this.downloadSegment = null;
        }
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public DDownloadCandidate createDDownloadCandidate() {
        DDownloadCandidate dCandidate = new DDownloadCandidate();
        dCandidate.setFileIndex(this.fileIndex);
        dCandidate.setFileName(this.fileName);
        if (this.guid != null) {
            dCandidate.setGuid(this.guid.toHexString());
        }
        if (this.downloadURI != null) {
            dCandidate.setDownloadUri(this.downloadURI.getEscapedURI());
        }
        if (this.resourceURN != null) {
            dCandidate.setResourceUrn(this.resourceURN.getAsString());
        }
        dCandidate.setPushNeeded(this.isPushNeeded);
        dCandidate.setChatSupported(this.isChatSupported);
        dCandidate.setRemoteHost(this.hostAddress.getFullHostName());
        dCandidate.setVendor(this.vendor);
        if (this.lastConnectionTime > 0L) {
            dCandidate.setLastConnectionTime(this.lastConnectionTime);
        }
        if (this.failedConnectionTries > 0) {
            dCandidate.setConnectionFailedRepetition(this.failedConnectionTries);
        }
        return dCandidate;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[Candidate: ");
        if (this.vendor != null) {
            buffer.append(this.vendor);
            buffer.append(',');
        }
        buffer.append("Adr:");
        buffer.append(this.hostAddress);
        buffer.append(" ->");
        buffer.append(super.toString());
        buffer.append("]");
        return buffer.toString();
    }

    public void addToCandidateLog(String message) {
        if (DownloadPrefs.CandidateLogBufferSize.get() > 0) {
            LogRecord record = new LogRecord(this, message);
            SwarmingManager.getInstance().getCandidateLogBuffer().addLogRecord(record);
        }
    }

    public void addToCandidateLog(Throwable th) {
        if (DownloadPrefs.CandidateLogBufferSize.get() > 0) {
            StackTraceElement[] stackTrace = th.getStackTrace();
            if (stackTrace == null) {
                return;
            }
            for (int i = 0; i < 2 && i < stackTrace.length; ++i) {
                LogRecord record = new LogRecord(this, stackTrace[i].toString());
                SwarmingManager.getInstance().getCandidateLogBuffer().addLogRecord(record);
            }
        }
    }

    public static enum ThexStatus {
        OPEN,
        SUCCEDED,
        FAILED;

    }

    public static enum CandidateStatus {
        IGNORED,
        BAD,
        WAITING,
        CONNECTION_FAILED,
        BUSY,
        RANGE_UNAVAILABLE,
        CONNECTING,
        PUSH_REQUEST,
        REMOTLY_QUEUED,
        REQUESTING,
        DOWNLOADING;

    }
}

