/*
 * Decompiled with CFR 0.152.
 */
package phex.download.handler;

import com.bitzi.util.Base32;
import com.onionnetworks.dime.DimeParser;
import com.onionnetworks.dime.DimeRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.httpclient.ChunkedInputStream;
import phex.common.log.NLogger;
import phex.download.DownloadEngine;
import phex.download.HostBusyException;
import phex.download.RemotelyQueuedException;
import phex.download.ThexVerificationData;
import phex.download.handler.AbstractHttpDownload;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSet;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.HTTPRetryAfter;
import phex.http.XQueueParameters;
import phex.net.connection.Connection;
import phex.prefs.core.DownloadPrefs;
import phex.thex.TTHashCalcUtils;
import phex.utils.IOUtil;
import phex.utils.LengthLimitedInputStream;
import phex.xml.thex.ThexHashTree;
import phex.xml.thex.ThexHashTreeCodec;

public class HttpThexDownload
extends AbstractHttpDownload {
    private ThexVerificationData thexData;
    private InputStream inStream;
    private long replyContentLength;
    private boolean isDownloadSuccessful;

    public HttpThexDownload(DownloadEngine engine, ThexVerificationData thexData) {
        super(engine);
        if (thexData == null) {
            throw new NullPointerException("ThexData is null.");
        }
        this.thexData = thexData;
    }

    @Override
    public void preProcess() {
    }

    @Override
    public void processHandshake() throws IOException, HTTPMessageException {
        HTTPHeader header;
        this.isDownloadSuccessful = false;
        Connection connection = this.downloadEngine.getConnection();
        SWDownloadCandidate candidate = this.downloadEngine.getDownloadSet().getCandidate();
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        this.inStream = connection.getInputStream();
        String requestUrl = candidate.getThexUri();
        HTTPRequest request = new HTTPRequest("GET", requestUrl, true);
        request.addHeader(new HTTPHeader("Host", candidate.getHostAddress().getFullHostName()));
        request.addHeader(new HTTPHeader("X-Queue", "0.1"));
        request.addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        String httpRequestStr = request.buildHTTPRequestString();
        NLogger.debug(HttpThexDownload.class, (Object)("HTTP Request to: " + candidate.getHostAddress() + "\n" + httpRequestStr));
        candidate.addToCandidateLog("HTTP Request:\n" + httpRequestStr);
        writer.write(httpRequestStr);
        writer.flush();
        HTTPResponse response = HTTPProcessor.parseHTTPResponse(connection);
        if (NLogger.isDebugEnabled(HttpThexDownload.class)) {
            NLogger.debug(HttpThexDownload.class, (Object)("HTTP Response from: " + candidate.getHostAddress() + "\n" + response.buildHTTPResponseString()));
        }
        if (DownloadPrefs.CandidateLogBufferSize.get() > 0) {
            candidate.addToCandidateLog("HTTP Response:\n" + response.buildHTTPResponseString());
        }
        if ((header = response.getHeader("Server")) != null) {
            candidate.setVendor(header.getValue());
        }
        if ((header = response.getHeader("Transfer-Encoding")) != null && header.getValue().equals("chunked")) {
            this.inStream = new ChunkedInputStream((InputStream)connection.getInputStream());
        }
        this.replyContentLength = -1L;
        header = response.getHeader("Content-Length");
        if (header != null) {
            try {
                this.replyContentLength = header.longValue();
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
        }
        this.updateKeepAliveSupport(response);
        int httpCode = response.getStatusCode();
        if (httpCode >= 200 && httpCode < 300) {
            NLogger.debug(HttpThexDownload.class, (Object)"HTTP Handshake successfull.");
            return;
        }
        if (httpCode == 503) {
            int delta;
            header = response.getHeader("X-Queue");
            XQueueParameters xQueueParameters = null;
            if (header != null) {
                xQueueParameters = XQueueParameters.parseXQueueParameters(header.getValue());
            }
            if (xQueueParameters != null && this.isKeepAliveSupported) {
                throw new RemotelyQueuedException(xQueueParameters);
            }
            header = response.getHeader("Retry-After");
            if (header != null && (delta = HTTPRetryAfter.parseDeltaInSeconds(header)) > 0) {
                throw new HostBusyException(delta);
            }
            throw new HostBusyException();
        }
        throw new IOException("Unknown HTTP code: " + httpCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDownload() throws IOException {
        SWDownloadSet downloadSet = this.downloadEngine.getDownloadSet();
        SWDownloadCandidate candidate = downloadSet.getCandidate();
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        NLogger.debug(HttpThexDownload.class, (Object)"Download Engine starts download.");
        LengthLimitedInputStream downloadStream = null;
        try {
            long fileSize;
            ThexHashTree xmlTree;
            DimeParser dimeParser;
            List<DimeRecord> records;
            long downloadLengthLeft = Long.MAX_VALUE;
            if (this.replyContentLength != -1L) {
                downloadLengthLeft = Math.min(this.replyContentLength, downloadLengthLeft);
            }
            if ((records = DimeParser.getAllRecords(dimeParser = new DimeParser(downloadStream = new LengthLimitedInputStream(this.inStream, downloadLengthLeft)))).size() < 2) {
                throw new IOException("Required dime records not found.");
            }
            DimeRecord xmlRecord = records.get(0);
            DimeRecord hashRecord = records.get(1);
            byte[] xmlData = xmlRecord.getData();
            if (candidate.getVendor().toLowerCase().contains("bearshare")) {
                int idx = xmlData.length - 1;
                while (xmlData[idx] != 62) {
                    --idx;
                }
                if (idx < xmlData.length - 1) {
                    byte[] newXmlData = new byte[idx + 1];
                    System.arraycopy(xmlData, 0, newXmlData, 0, idx + 1);
                    xmlData = newXmlData;
                }
            }
            try {
                xmlTree = ThexHashTreeCodec.parseThexHashTreeXML(new ByteArrayInputStream(xmlData));
            }
            catch (MalformedURLException exp) {
                NLogger.error(HttpThexDownload.class, (Object)("Failed to parse: '" + new String(xmlData, "UTF-8") + "' from: " + candidate.getVendor()));
                candidate.addToCandidateLog("Failed to parse: '" + new String(xmlData, "UTF-8") + "'");
                NLogger.error(HttpThexDownload.class, (Object)exp);
                throw new IOException("Parsing Thex HashTree failed.");
            }
            try {
                fileSize = Long.parseLong(xmlTree.getFileSize());
            }
            catch (NumberFormatException exp) {
                throw new IOException("Invalid file size: " + xmlTree.getFileSize());
            }
            if (fileSize != downloadFile.getTotalDataSize()) {
                throw new IOException("Invalid file size: " + fileSize + "/" + downloadFile.getTotalDataSize());
            }
            byte[] hashData = hashRecord.getData();
            if (hashData.length < 24) {
                throw new IOException("Invalid hash data size.");
            }
            byte[] rootHash = new byte[24];
            System.arraycopy(hashData, 0, rootHash, 0, 24);
            String rootHashB32 = Base32.encode(rootHash);
            if (!candidate.getThexRoot().equals(rootHashB32) || !downloadFile.getThexVerificationData().getRootHash().equals(rootHashB32)) {
                throw new IOException("Root hash do not match.");
            }
            List<List<byte[]>> merkleNodes = TTHashCalcUtils.resolveMerkleNodes(hashData, fileSize);
            List<byte[]> lowestLevelNodes = merkleNodes.get(merkleNodes.size() - 1);
            this.thexData.setThexData(lowestLevelNodes, merkleNodes.size() - 1, fileSize);
            this.isDownloadSuccessful = true;
        }
        finally {
            boolean isAcceptingNextSegment = this.isAcceptingNextRequest();
            candidate.addToCandidateLog("Is accepting next segment: " + isAcceptingNextSegment);
            if (isAcceptingNextSegment && downloadStream != null) {
                downloadStream.close();
            } else {
                this.stopDownload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postProcess() {
        if (this.thexData != null) {
            SWDownloadSet downloadSet = this.downloadEngine.getDownloadSet();
            SWDownloadCandidate candidate = downloadSet.getCandidate();
            ThexVerificationData thexVerificationData = this.thexData;
            synchronized (thexVerificationData) {
                if (this.isDownloadSuccessful) {
                    candidate.setThexStatus(SWDownloadCandidate.ThexStatus.SUCCEDED);
                } else if (!candidate.isBusyOrQueued()) {
                    candidate.setThexStatus(SWDownloadCandidate.ThexStatus.FAILED);
                }
                this.thexData.setThexRequested(false);
                this.thexData = null;
            }
        }
    }

    @Override
    public void stopDownload() {
        IOUtil.closeQuietly(this.inStream);
    }

    @Override
    public boolean isAcceptingNextRequest() {
        return this.isDownloadSuccessful && this.isKeepAliveSupported && this.replyContentLength != -1L;
    }
}

