/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.List;
import phex.common.FileHandlingException;
import phex.common.RunnerQueueWorker;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.download.BufferVolumeTracker;
import phex.download.DataDownloadScope;
import phex.download.DownloadDataWriter;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.RatedDownloadScopeList;
import phex.download.ThexVerificationData;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategyProvider;
import phex.download.swarming.SWDownloadFile;
import phex.prefs.core.DownloadPrefs;
import phex.thex.TTHashCalcUtils;
import phex.xml.sax.downloads.DDownloadFile;
import phex.xml.sax.downloads.DDownloadScope;

public class MemoryFile {
    private ScopeSelectionStrategy scopeSelectionStrategy;
    private DownloadScopeList missingScopeList;
    private DownloadScopeList blockedScopeList;
    private List<DataDownloadScope> bufferedDataScopeList;
    private BufferVolumeTracker bufferedVolume;
    private DownloadScopeList unverifiedScopeList;
    private DownloadScopeList toBeVerifiedScopeList;
    private DownloadScopeList finishedScopeList;
    private RatedDownloadScopeList ratedScopeList;
    private long ratedScopeListBuildTime;
    private boolean isBufferWritingRequested;
    private final SWDownloadFile downloadFile;
    private final RunnerQueueWorker downloadVerifyRunner;

    public MemoryFile(SWDownloadFile downloadFile, BufferVolumeTracker globalBufferVolumeTracker, DownloadDataWriter downloadDataWriter, RunnerQueueWorker downloadVerifyRunner) {
        this.downloadFile = downloadFile;
        this.downloadVerifyRunner = downloadVerifyRunner;
        this.isBufferWritingRequested = false;
        this.missingScopeList = new DownloadScopeList();
        this.blockedScopeList = new DownloadScopeList();
        this.bufferedDataScopeList = new ArrayList<DataDownloadScope>();
        this.unverifiedScopeList = new DownloadScopeList();
        this.toBeVerifiedScopeList = new DownloadScopeList();
        this.finishedScopeList = new DownloadScopeList();
        this.bufferedVolume = new BufferVolumeTracker(globalBufferVolumeTracker, DownloadPrefs.MaxWriteBufferPerDownload.get(), downloadDataWriter);
        long fileSize = downloadFile.getTotalDataSize();
        if (fileSize == -1L) {
            this.missingScopeList.add(new DownloadScope(0L, Long.MAX_VALUE));
        } else {
            this.missingScopeList.add(new DownloadScope(0L, fileSize - 1L));
        }
        this.scopeSelectionStrategy = ScopeSelectionStrategyProvider.getAvailBeginRandSelectionStrategy();
    }

    public void setScopeSelectionStrategy(ScopeSelectionStrategy strategy) {
        this.scopeSelectionStrategy = strategy;
    }

    public ScopeSelectionStrategy getScopeSelectionStrategy() {
        return this.scopeSelectionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFileSize() {
        long fileSize = this.downloadFile.getTotalDataSize();
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            this.missingScopeList.remove(new DownloadScope(fileSize, Long.MAX_VALUE));
        }
        downloadScopeList = this.blockedScopeList;
        synchronized (downloadScopeList) {
            this.blockedScopeList.remove(new DownloadScope(fileSize, Long.MAX_VALUE));
        }
    }

    public DownloadScopeList getBlockedScopeList() {
        return this.blockedScopeList;
    }

    public DownloadScopeList getUnverifiedScopeList() {
        return this.unverifiedScopeList;
    }

    public DownloadScopeList getToBeVerifiedScopeList() {
        return this.toBeVerifiedScopeList;
    }

    public DownloadScopeList getFinishedScopeList() {
        return this.finishedScopeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadScope> getFinishedScopeListCopy() {
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            return this.finishedScopeList.getScopeListCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadScope> getUnverifiedScopeListCopy() {
        DownloadScopeList downloadScopeList = this.unverifiedScopeList;
        synchronized (downloadScopeList) {
            return this.unverifiedScopeList.getScopeListCopy();
        }
    }

    public int getDownloadedFragmentCount() {
        return this.finishedScopeList.size() + this.unverifiedScopeList.size() + this.toBeVerifiedScopeList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFinishedLength() {
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            return this.finishedScopeList.getAggregatedLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMissingLength() {
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            return this.missingScopeList.getAggregatedLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isComplete() {
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            return this.finishedScopeList.getAggregatedLength() == this.downloadFile.getTotalDataSize();
        }
    }

    public boolean isFileBeginningAvailable() {
        DownloadScope scope;
        if (this.unverifiedScopeList.size() > 0 && (scope = this.unverifiedScopeList.getScopeAt(0)).getStart() == 0L) {
            return true;
        }
        return this.finishedScopeList.size() > 0 && (scope = this.finishedScopeList.getScopeAt(0)).getStart() == 0L;
    }

    public long getFileBeginningScopeLength() {
        DownloadScope scope = this.finishedScopeList.getScopeAt(0);
        if (scope == null || scope.getStart() != 0L) {
            return 0L;
        }
        return scope.getEnd();
    }

    public RatedDownloadScopeList getRatedScopeList() {
        long now = System.currentTimeMillis();
        if (this.ratedScopeListBuildTime + 120000L > now) {
            return this.ratedScopeList;
        }
        if (this.ratedScopeList == null) {
            this.ratedScopeList = new RatedDownloadScopeList();
        } else {
            this.ratedScopeList.clear();
        }
        this.ratedScopeList.addAll(this.missingScopeList);
        this.downloadFile.rateDownloadScopeList(this.ratedScopeList);
        this.ratedScopeListBuildTime = System.currentTimeMillis();
        return this.ratedScopeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMissingScopeAllocateable(DownloadScopeList candidateScopeList) {
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            if (this.missingScopeList.size() == 0) {
                return false;
            }
            if (this.downloadFile.getTotalDataSize() != -1L && candidateScopeList != null) {
                DownloadScopeList wantedScopeList = (DownloadScopeList)this.missingScopeList.clone();
                wantedScopeList.retainAll(candidateScopeList);
                return wantedScopeList.size() > 0;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScope allocateMissingScope(long preferredSize) {
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            if (this.missingScopeList.isEmpty()) {
                return null;
            }
            DownloadScope scope = this.missingScopeList.getScopeAt(0);
            this.missingScopeList.remove(scope);
            Object object = scope;
            synchronized (object) {
                if (this.downloadFile.getTotalDataSize() != -1L && scope.getLength() > preferredSize) {
                    DownloadScope beforeScope = new DownloadScope(scope.getStart(), scope.getStart() + preferredSize - 1L);
                    DownloadScope afterScope = new DownloadScope(scope.getStart() + preferredSize, scope.getEnd());
                    this.missingScopeList.add(afterScope);
                    scope = beforeScope;
                }
            }
            object = this.blockedScopeList;
            synchronized (object) {
                this.blockedScopeList.add(scope);
            }
            return scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScope allocateMissingScopeForCandidate(DownloadScopeList candidateScopeList, long preferredSize) {
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            DownloadScopeList wantedScopeList = (DownloadScopeList)this.missingScopeList.clone();
            wantedScopeList.addAll(this.missingScopeList);
            wantedScopeList.retainAll(candidateScopeList);
            if (wantedScopeList.size() == 0) {
                return null;
            }
            DownloadScope scope = this.scopeSelectionStrategy.selectDownloadScope(this.downloadFile, wantedScopeList, preferredSize);
            if (scope == null) {
                return null;
            }
            this.missingScopeList.remove(scope);
            DownloadScopeList downloadScopeList2 = this.blockedScopeList;
            synchronized (downloadScopeList2) {
                this.blockedScopeList.add(scope);
            }
            return scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllocatedScope(DownloadScope downloadScope, long transferredSize) {
        if (downloadScope.getEnd() == Long.MAX_VALUE && this.downloadFile.getTotalDataSize() != -1L) {
            downloadScope = new DownloadScope(downloadScope.getStart(), this.downloadFile.getTotalDataSize() - 1L);
        }
        DownloadScope missingScope = null;
        if (transferredSize == 0L) {
            missingScope = downloadScope;
        } else if (transferredSize < downloadScope.getLength()) {
            missingScope = new DownloadScope(downloadScope.getStart() + transferredSize, downloadScope.getEnd());
        }
        DownloadScopeList downloadScopeList = this.blockedScopeList;
        synchronized (downloadScopeList) {
            this.blockedScopeList.remove(downloadScope);
        }
        downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            if (missingScope != null) {
                this.missingScopeList.add(missingScope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDownloadedLength() {
        long length = 0L;
        DownloadScopeList downloadScopeList = this.unverifiedScopeList;
        synchronized (downloadScopeList) {
            length += this.unverifiedScopeList.getAggregatedLength();
        }
        downloadScopeList = this.toBeVerifiedScopeList;
        synchronized (downloadScopeList) {
        }
        return (length += this.toBeVerifiedScopeList.getAggregatedLength()) + this.getFinishedLength() + (long)this.getBufferedDataLength();
    }

    public int getBufferedDataLength() {
        return this.bufferedVolume.getUsedBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferDataScope(DataDownloadScope dataScope) {
        List<DataDownloadScope> list = this.bufferedDataScopeList;
        synchronized (list) {
            this.bufferedDataScopeList.add(dataScope);
        }
        assert (dataScope.getLength() < Integer.MAX_VALUE);
        this.bufferedVolume.addBufferedSize((int)dataScope.getLength());
    }

    public boolean isBufferWritingRequested() {
        return this.isBufferWritingRequested;
    }

    public void requestBufferWriting() {
        NLogger.debug(MemoryFile.class, (Object)"MemoryFile requesting buffer write.");
        this.isBufferWritingRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuffersToDisk() {
        if (this.bufferedDataScopeList.isEmpty()) {
            return;
        }
        NLogger.debug(MemoryFile.class, (Object)"MemoryFile write buffers to disk.");
        this.isBufferWritingRequested = false;
        try {
            ArrayList<DataDownloadScope> list;
            ManagedFile destFile = this.downloadFile.getIncompleteDownloadFile();
            List<DataDownloadScope> list2 = this.bufferedDataScopeList;
            synchronized (list2) {
                list = new ArrayList<DataDownloadScope>(this.bufferedDataScopeList);
            }
            for (DataDownloadScope dataScope : list) {
                destFile.write(dataScope.getDataBuffer(), dataScope.getStart());
                Iterable<DataDownloadScope> iterable = this.bufferedDataScopeList;
                synchronized (iterable) {
                    this.bufferedDataScopeList.remove(dataScope);
                }
                assert (dataScope.getLength() < Integer.MAX_VALUE);
                this.bufferedVolume.reduceBufferedSize((int)dataScope.getLength());
                dataScope.releaseDataBuffer();
                iterable = this.unverifiedScopeList;
                synchronized (iterable) {
                    this.unverifiedScopeList.add(dataScope);
                }
            }
            this.findScopesToVerify();
            if (!this.downloadFile.isFileCompletedOrMoved() && this.isComplete()) {
                this.downloadFile.setStatus(3);
                this.downloadFile.moveToDestinationFile();
            }
        }
        catch (FileHandlingException exp) {
            NLogger.error(MemoryFile.class, (Object)exp, (Throwable)exp);
        }
        catch (ManagedFileException exp) {
            NLogger.error(MemoryFile.class, (Object)exp, (Throwable)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findScopesToVerify() {
        DownloadScopeList downloadScopeList = this.unverifiedScopeList;
        synchronized (downloadScopeList) {
            int nodeSize;
            ArrayList<DownloadScope> verifyableScopes = new ArrayList<DownloadScope>();
            ThexVerificationData.ThexData thexData = this.downloadFile.getThexVerificationData().getThexData();
            if (thexData == null) {
                if (this.unverifiedScopeList.getAggregatedLength() == this.downloadFile.getTotalDataSize()) {
                    List<DownloadScope> scopes = this.unverifiedScopeList.getScopeListCopy();
                    DownloadScopeList downloadScopeList2 = this.finishedScopeList;
                    synchronized (downloadScopeList2) {
                        for (DownloadScope scope : scopes) {
                            this.unverifiedScopeList.remove(scope);
                            this.finishedScopeList.add(scope);
                        }
                    }
                    if (!this.downloadFile.isFileCompletedOrMoved() && this.isComplete()) {
                        this.downloadFile.setStatus(3);
                        this.downloadFile.moveToDestinationFile();
                    }
                }
                return;
            }
            long totalFileSize = this.downloadFile.getTotalDataSize();
            long lastNodeStart = totalFileSize - totalFileSize % (long)(nodeSize = thexData.getNodeSize());
            if (lastNodeStart == totalFileSize) {
                lastNodeStart -= (long)nodeSize;
            }
            for (DownloadScope scope : this.unverifiedScopeList) {
                long nodeStart;
                boolean isLastScope;
                boolean bl = isLastScope = scope.getEnd() + 1L == totalFileSize;
                if (!isLastScope && scope.getLength() < (long)nodeSize) continue;
                if (scope.getStart() % (long)nodeSize == 0L) {
                    nodeStart = scope.getStart();
                } else if (isLastScope) {
                    nodeStart = totalFileSize - totalFileSize % (long)nodeSize;
                    if (nodeStart == totalFileSize) {
                        nodeStart -= (long)nodeSize;
                    }
                } else {
                    nodeStart = scope.getStart() + (long)nodeSize - scope.getStart() % (long)nodeSize;
                }
                long nodeEnd = (scope.getEnd() + 1L) % (long)nodeSize == 0L || isLastScope ? scope.getEnd() : scope.getEnd() - 1L - scope.getEnd() % (long)nodeSize;
                if (nodeEnd - nodeStart + 1L >= (long)nodeSize && (nodeEnd - nodeStart + 1L) % (long)nodeSize == 0L) {
                    long rangeEnd;
                    long rangeStart = nodeStart;
                    do {
                        rangeEnd = rangeStart + (long)nodeSize - 1L;
                        verifyableScopes.add(new DownloadScope(rangeStart, rangeEnd));
                    } while ((rangeStart = rangeEnd + 1L) < nodeEnd);
                    continue;
                }
                if (!isLastScope || scope.getStart() > nodeStart) continue;
                verifyableScopes.add(new DownloadScope(nodeStart, nodeEnd));
            }
            if (verifyableScopes.size() > 0) {
                DownloadScopeList downloadScopeList3 = this.toBeVerifiedScopeList;
                synchronized (downloadScopeList3) {
                    for (DownloadScope scope : verifyableScopes) {
                        this.unverifiedScopeList.remove(scope);
                        this.toBeVerifiedScopeList.add(scope);
                        this.downloadVerifyRunner.add(new DownloadVerificationWorker(scope));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyScope(DownloadScope scope) {
        block17: {
            try {
                ManagedFile destFile = this.downloadFile.getIncompleteDownloadFile();
                boolean succ = TTHashCalcUtils.verifyTigerTreeHash(this.downloadFile.getThexVerificationData().getThexData(), destFile, scope.getStart(), scope.getLength());
                if (succ) {
                    DownloadScopeList downloadScopeList = this.toBeVerifiedScopeList;
                    synchronized (downloadScopeList) {
                        this.toBeVerifiedScopeList.remove(scope);
                    }
                    downloadScopeList = this.finishedScopeList;
                    synchronized (downloadScopeList) {
                        this.finishedScopeList.add(scope);
                        break block17;
                    }
                }
                DownloadScopeList downloadScopeList = this.toBeVerifiedScopeList;
                synchronized (downloadScopeList) {
                    this.toBeVerifiedScopeList.remove(scope);
                }
                downloadScopeList = this.missingScopeList;
                synchronized (downloadScopeList) {
                    this.missingScopeList.add(scope);
                }
            }
            catch (FileHandlingException exp) {
                NLogger.error(MemoryFile.class, (Object)exp, (Throwable)exp);
            }
            catch (ManagedFileException exp) {
                NLogger.error(MemoryFile.class, (Object)exp, (Throwable)exp);
            }
        }
        if (!this.downloadFile.isFileCompletedOrMoved() && this.isComplete()) {
            this.downloadFile.setStatus(3);
            this.downloadFile.moveToDestinationFile();
        }
    }

    public void createDownloadScopes(DDownloadFile dFile) {
        DownloadScope downloadScope;
        this.missingScopeList.clear();
        this.blockedScopeList.clear();
        this.unverifiedScopeList.clear();
        this.toBeVerifiedScopeList.clear();
        this.finishedScopeList.clear();
        this.setScopeSelectionStrategy(ScopeSelectionStrategyProvider.getByClassName(dFile.getScopeSelectionStrategy()));
        for (DDownloadScope dScope : dFile.getUnverifiedScopesList().getSubElementList()) {
            downloadScope = new DownloadScope(dScope.getStart(), dScope.getEnd());
            this.unverifiedScopeList.add(downloadScope);
        }
        for (DDownloadScope dScope : dFile.getFinishedScopesList().getSubElementList()) {
            downloadScope = new DownloadScope(dScope.getStart(), dScope.getEnd());
            this.finishedScopeList.add(downloadScope);
        }
        long fileSize = this.downloadFile.getTotalDataSize();
        if (fileSize == -1L) {
            this.missingScopeList.add(new DownloadScope(0L, Long.MAX_VALUE));
        } else {
            this.missingScopeList.add(new DownloadScope(0L, fileSize - 1L));
        }
        this.missingScopeList.removeAll(this.unverifiedScopeList);
        this.missingScopeList.removeAll(this.finishedScopeList);
    }

    public void createXJBFinishedScopes(DDownloadFile dFile) {
        dFile.setScopeSelectionStrategy(this.scopeSelectionStrategy.getClass().getName());
        List<DDownloadScope> list = dFile.getUnverifiedScopesList().getSubElementList();
        List<DownloadScope> unvScopeListCopy = this.getUnverifiedScopeListCopy();
        for (DownloadScope scope : unvScopeListCopy) {
            DDownloadScope dScope = new DDownloadScope("unverified-scopes");
            dScope.setStart(scope.getStart());
            dScope.setEnd(scope.getEnd());
            list.add(dScope);
        }
        list = dFile.getFinishedScopesList().getSubElementList();
        List<DownloadScope> finScopeListCopy = this.getFinishedScopeListCopy();
        for (DownloadScope scope : finScopeListCopy) {
            DDownloadScope dScope = new DDownloadScope("finished-scopes");
            dScope.setStart(scope.getStart());
            dScope.setEnd(scope.getEnd());
            list.add(dScope);
        }
    }

    public class DownloadVerificationWorker
    implements Runnable {
        private DownloadScope scope;

        public DownloadVerificationWorker(DownloadScope scope) {
            this.scope = scope;
        }

        @Override
        public void run() {
            try {
                MemoryFile.this.verifyScope(this.scope);
            }
            catch (Throwable th) {
                NLogger.error(MemoryFile.class, (Object)"Download scope consistency in danger!");
                NLogger.error(MemoryFile.class, (Object)th, th);
            }
        }
    }
}

