/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.URN;
import phex.utils.URLCodecUtils;

public class MagnetData {
    private List<String> exactTopicList = new ArrayList<String>();
    private List<String> exactSubstituteList = new ArrayList<String>();
    private List<String> acceptableSubstituteList = new ArrayList<String>();
    private String displayName;
    private String keywordTopic;

    private MagnetData() {
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getKeywordTopic() {
        return this.keywordTopic;
    }

    public void setKeywordTopic(String keywordTopic) {
        this.keywordTopic = keywordTopic;
    }

    public List<String> getExactSubstituteList() {
        return this.exactSubstituteList;
    }

    public void addExactSubstitute(String exactSubstitute) {
        this.exactSubstituteList.add(exactSubstitute);
    }

    public List<String> getAcceptableSubstituteList() {
        return this.acceptableSubstituteList;
    }

    private void addAcceptableSubstitute(String acceptableSubstitutes) {
        this.acceptableSubstituteList.add(acceptableSubstitutes);
    }

    public List<String> getExactTopicList() {
        return this.exactTopicList;
    }

    public void addExactTopic(String exactTopicStr) {
        this.exactTopicList.add(exactTopicStr);
    }

    public static String lookupFileName(MagnetData magnetData) {
        if (magnetData.displayName != null) {
            return magnetData.displayName;
        }
        if (magnetData.keywordTopic != null) {
            return magnetData.keywordTopic;
        }
        URN urn = MagnetData.lookupSHA1URN(magnetData);
        if (urn != null) {
            return "Magnet download " + urn.getAsString();
        }
        return "Unknown Magnet download";
    }

    public static String lookupSearchName(MagnetData magnetData) {
        if (magnetData.keywordTopic != null) {
            return magnetData.keywordTopic;
        }
        if (magnetData.displayName != null) {
            return magnetData.displayName;
        }
        return "";
    }

    public static URN lookupSHA1URN(MagnetData magnetData) {
        for (String xt : magnetData.exactTopicList) {
            if (!URN.isValidURN(xt)) continue;
            return new URN(xt);
        }
        for (String xs : magnetData.exactSubstituteList) {
            if (!URN.isValidURN(xs)) continue;
            return new URN(xs);
        }
        for (String as : magnetData.acceptableSubstituteList) {
            if (!URN.isValidURN(as)) continue;
            return new URN(as);
        }
        return null;
    }

    public static List<URI> lookupHttpURIs(MagnetData magnetData) {
        ArrayList<URI> urlList = new ArrayList<URI>();
        for (String xt : magnetData.exactTopicList) {
            if (!xt.startsWith("http://")) continue;
            try {
                urlList.add(new URI(xt, false));
            }
            catch (URIException e) {}
        }
        for (String xs : magnetData.exactSubstituteList) {
            if (!xs.startsWith("http://")) continue;
            try {
                urlList.add(new URI(xs, false));
            }
            catch (URIException e) {}
        }
        for (String as : magnetData.acceptableSubstituteList) {
            if (!as.startsWith("http://")) continue;
            try {
                urlList.add(new URI(as, false));
            }
            catch (URIException e) {}
        }
        return urlList;
    }

    public static MagnetData parseFromURI(URI uri) {
        String protocol = uri.getScheme();
        if (!"magnet".equals(protocol)) {
            return null;
        }
        MagnetData magnetData = new MagnetData();
        String urlQuery = uri.getEscapedQuery();
        StringTokenizer tokenizer = new StringTokenizer(urlQuery, "&");
        while (tokenizer.hasMoreTokens()) {
            String param = tokenizer.nextToken().trim();
            int seperatorIdx = param.indexOf("=");
            if (seperatorIdx == -1) continue;
            String key = param.substring(0, seperatorIdx);
            String value = param.substring(seperatorIdx + 1);
            value = URLCodecUtils.decodeURL(value);
            if (key.equals("xt")) {
                magnetData.addExactTopic(value);
                continue;
            }
            if (key.equals("xs")) {
                magnetData.addExactSubstitute(value);
                continue;
            }
            if (key.equals("as")) {
                magnetData.addAcceptableSubstitute(value);
                continue;
            }
            if (key.equals("dn")) {
                magnetData.setDisplayName(value);
                continue;
            }
            if (!key.equals("kt")) continue;
            magnetData.setKeywordTopic(value);
        }
        return magnetData;
    }
}

