/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.List;
import java.util.ListIterator;
import phex.common.ThreadTracking;
import phex.common.log.NLogger;
import phex.download.MemoryFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.prefs.core.DownloadPrefs;

public class DownloadDataWriter
implements Runnable {
    private Thread thread;
    private boolean isShutingDown;
    private long lastCompleteWrite;
    private boolean isWriteCycleRequested;
    private SwarmingManager swarmingMgr;

    public void start() {
        this.isShutingDown = false;
        this.thread = new Thread(ThreadTracking.rootThreadGroup, this, "DownloadDataWriter");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void shutdown() {
        this.isShutingDown = true;
        this.triggerWriteCycle();
        try {
            this.thread.join();
        }
        catch (InterruptedException exp) {
            NLogger.error(DownloadDataWriter.class, (Object)exp, (Throwable)exp);
            Thread.currentThread().interrupt();
        }
        this.writeDownloadData();
    }

    @Override
    public void run() {
        this.swarmingMgr = SwarmingManager.getInstance();
        while (!this.isShutingDown) {
            try {
                do {
                    this.writeDownloadData();
                } while (this.isWriteCycleRequested);
                this.waitForNotify();
            }
            catch (Throwable th) {
                NLogger.error(DownloadDataWriter.class, (Object)th, th);
            }
        }
    }

    private synchronized void waitForNotify() {
        NLogger.debug(DownloadDataWriter.class, (Object)"Waiting...");
        try {
            this.wait(5000L);
        }
        catch (InterruptedException exp) {
            NLogger.error(DownloadDataWriter.class, (Object)exp, (Throwable)exp);
        }
        NLogger.debug(DownloadDataWriter.class, (Object)"Woke...");
    }

    public synchronized void triggerWriteCycle() {
        NLogger.debug(DownloadDataWriter.class, (Object)"Triggering write cycle.");
        this.isWriteCycleRequested = true;
        this.notifyAll();
    }

    private void writeDownloadData() {
        if (!this.swarmingMgr.isDownloadActive()) {
            return;
        }
        long bufferedDataWritten = 0L;
        long totalBufferedSize = 0L;
        boolean performCompleteWrite = false;
        if (this.isShutingDown || this.isWriteCycleRequested || this.lastCompleteWrite + 60000L < System.currentTimeMillis()) {
            NLogger.debug(DownloadDataWriter.class, (Object)"Time for complete write cycle.");
            this.isWriteCycleRequested = false;
            performCompleteWrite = true;
        }
        int maxPerDownloadBuffer = DownloadPrefs.MaxWriteBufferPerDownload.get();
        maxPerDownloadBuffer = (int)((double)maxPerDownloadBuffer * 0.9);
        List<SWDownloadFile> downloadList = this.swarmingMgr.getDownloadFileListCopy();
        ListIterator<SWDownloadFile> iterator = downloadList.listIterator();
        while (iterator.hasNext()) {
            SWDownloadFile downloadFile = iterator.next();
            MemoryFile memoryFile = downloadFile.getMemoryFile();
            long bufferedSize = memoryFile.getBufferedDataLength();
            totalBufferedSize += bufferedSize;
            if (!performCompleteWrite && !memoryFile.isBufferWritingRequested() && bufferedSize < (long)maxPerDownloadBuffer) continue;
            NLogger.debug(DownloadDataWriter.class, (Object)("Trigger buffer write for " + downloadFile + ", amount: " + bufferedSize));
            memoryFile.writeBuffersToDisk();
            bufferedDataWritten += bufferedSize;
            iterator.remove();
        }
        NLogger.debug(DownloadDataWriter.class, (Object)("Total buffered data was: " + totalBufferedSize));
        int maxTotalBuffer = DownloadPrefs.MaxTotalDownloadWriteBuffer.get();
        maxTotalBuffer = (int)((double)maxTotalBuffer * 0.9);
        if (!performCompleteWrite && totalBufferedSize >= (long)maxTotalBuffer) {
            performCompleteWrite = true;
            iterator = downloadList.listIterator();
            while (iterator.hasNext()) {
                SWDownloadFile downloadFile = iterator.next();
                MemoryFile memoryFile = downloadFile.getMemoryFile();
                long bufferedSize = memoryFile.getBufferedDataLength();
                NLogger.debug(DownloadDataWriter.class, (Object)("Trigger buffer write for " + downloadFile + ", amount: " + bufferedSize));
                memoryFile.writeBuffersToDisk();
                bufferedDataWritten += bufferedSize;
            }
        }
        if (performCompleteWrite) {
            this.lastCompleteWrite = System.currentTimeMillis();
        }
        if (bufferedDataWritten > 0L) {
            this.swarmingMgr.notifyDownloadListChange();
        }
    }
}

