/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.connection.ConnectionEngine;
import phex.connection.ConnectionRejectedException;
import phex.connection.ConnectionStatusEvent;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostStatus;
import phex.host.NetworkHostsContainer;
import phex.net.connection.Connection;
import phex.net.connection.ConnectionFactory;
import phex.servent.Servent;

public class OutgoingConnectionDispatcher
implements Runnable {
    private final NetworkHostsContainer networkHostsContainer;
    private final DestAddress hostAddress;

    public static void dispatchConnectToNextHost(CaughtHostsContainer caughtHostsCont, NetworkHostsContainer networkHostsCont) {
        OutgoingConnectionDispatcher.dispatchConnectToNextHosts(1, caughtHostsCont, networkHostsCont);
    }

    public static void dispatchConnectToNextHosts(int count, CaughtHostsContainer caughtHostsCont, NetworkHostsContainer networkHostsCont) {
        for (int i = 0; i < count; ++i) {
            DestAddress caughtHost;
            do {
                if ((caughtHost = caughtHostsCont.getNextCaughtHost()) != null) continue;
                return;
            } while (networkHostsCont.isConnectedToHost(caughtHost));
            OutgoingConnectionDispatcher.dispatchConnectToHost(caughtHost, networkHostsCont);
        }
    }

    public static void dispatchConnectToHost(DestAddress hostAddress, NetworkHostsContainer networkHostsContainer) {
        OutgoingConnectionDispatcher dispatcher = new OutgoingConnectionDispatcher(hostAddress, networkHostsContainer);
        ThreadPool.getInstance().addJob(dispatcher, "OutgoingConnectionDispatcher-" + Integer.toHexString(dispatcher.hashCode()));
    }

    private OutgoingConnectionDispatcher(DestAddress hostAddress, NetworkHostsContainer networkHostsContainer) {
        this.hostAddress = hostAddress;
        this.networkHostsContainer = networkHostsContainer;
    }

    @Override
    public void run() {
        try {
            this.connectToHostAddress();
        }
        catch (Throwable th) {
            NLogger.error(OutgoingConnectionDispatcher.class, (Object)th, th);
        }
    }

    private void connectToHostAddress() {
        ConnectionEngine engine;
        Connection connection;
        Host host = new Host(this.hostAddress);
        host.setType(Host.Type.OUTGOING);
        host.setStatus(HostStatus.CONNECTING);
        this.networkHostsContainer.addNetworkHost(host);
        try {
            connection = ConnectionFactory.createConnection(this.hostAddress);
        }
        catch (IOException exp) {
            this.reportStatus(ConnectionStatusEvent.Status.CONNECTION_FAILED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.debug(OutgoingConnectionDispatcher.class, (Object)exp);
            return;
        }
        catch (Exception exp) {
            this.reportStatus(ConnectionStatusEvent.Status.CONNECTION_FAILED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.warn(OutgoingConnectionDispatcher.class, (Object)exp, (Throwable)exp);
            return;
        }
        host.setConnection(connection);
        try {
            engine = new ConnectionEngine(Servent.getInstance(), host);
            engine.initHostHandshake();
        }
        catch (ConnectionRejectedException exp) {
            this.reportStatus(ConnectionStatusEvent.Status.HANDSHAKE_REJECTED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.debug(OutgoingConnectionDispatcher.class, (Object)exp);
            return;
        }
        catch (IOException exp) {
            this.reportStatus(ConnectionStatusEvent.Status.HANDSHAKE_FAILED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.debug(OutgoingConnectionDispatcher.class, (Object)exp);
            return;
        }
        catch (Exception exp) {
            this.reportStatus(ConnectionStatusEvent.Status.HANDSHAKE_FAILED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.warn(OutgoingConnectionDispatcher.class, (Object)exp, (Throwable)exp);
            return;
        }
        this.reportStatus(ConnectionStatusEvent.Status.SUCCESSFUL);
        try {
            engine.processIncomingData();
        }
        catch (IOException exp) {
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.debug(OutgoingConnectionDispatcher.class, (Object)exp);
        }
        catch (Exception exp) {
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.warn(OutgoingConnectionDispatcher.class, (Object)exp, (Throwable)exp);
        }
    }

    private void reportStatus(ConnectionStatusEvent.Status status) {
        Servent.getInstance().getEventService().publish("phex:net/connectionStatus", new ConnectionStatusEvent(this.hostAddress, status));
    }
}

