/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.concurrent.locks.ReentrantLock;
import phex.common.file.FileManager;
import phex.common.file.ManagedFileException;
import phex.common.file.ReadOnlyManagedFile;
import phex.common.log.NLogger;
import phex.io.buffer.ByteBuffer;
import phex.utils.FileUtils;

public class ManagedFile
implements ReadOnlyManagedFile {
    private static final int MAX_WRITE_TRIES = 10;
    private static final int WRITE_RETRY_DELAY = 100;
    private ReentrantLock lock;
    private File fsFile;
    private AccessMode accessMode;
    private RandomAccessFile raFile;
    private StackTraceElement[] lastStackTraceElem;

    public ManagedFile(File file) {
        this.fsFile = file;
        this.lock = new ReentrantLock();
    }

    public void acquireFileLock() {
        NLogger.debug(ManagedFile.class, (Object)("Acquire file lock " + this));
        this.lock.lock();
        NLogger.debug(ManagedFile.class, (Object)("Acquired file lock " + this));
    }

    public void releaseFileLock() {
        NLogger.debug(ManagedFile.class, (Object)("Releasing " + this));
        this.lock.unlock();
    }

    public File getFile() {
        return this.fsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessMode(AccessMode newMode) throws ManagedFileException {
        this.lock.lock();
        try {
            if (newMode == AccessMode.READ_ONLY_ACCESS && this.accessMode == AccessMode.READ_WRITE_ACCESS) {
                return;
            }
            if (newMode == AccessMode.READ_WRITE_ACCESS && this.accessMode == AccessMode.READ_ONLY_ACCESS) {
                this.closeFile();
            }
            this.accessMode = newMode;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpenFile() throws ManagedFileException {
        this.lock.lock();
        try {
            if (this.raFile != null) {
                FileManager.getInstance().trackFileInUse(this);
                return;
            }
            FileManager.getInstance().trackFileOpen(this);
            try {
                this.raFile = new RandomAccessFile(this.fsFile, this.accessMode.fileMode);
            }
            catch (Exception exp) {
                throw new ManagedFileException("failed to open", exp);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile() throws ManagedFileException {
        if (this.raFile == null) {
            return;
        }
        this.lock.lock();
        try {
            try {
                NLogger.debug(ManagedFile.class, (Object)"Closing file.");
                this.raFile.close();
            }
            catch (Exception exp) {
                throw new ManagedFileException("failed to close", exp);
            }
        }
        finally {
            this.raFile = null;
            FileManager.getInstance().trackFileClose(this);
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(ByteBuffer buffer, long pos) throws ManagedFileException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("write failes: interrupted", exp);
        }
        try {
            this.checkOpenFile();
            if (this.raFile == null) {
                throw new ManagedFileException("write failes: raFile null");
            }
            FileChannel channel = this.raFile.getChannel();
            if (!channel.isOpen()) {
                throw new ManagedFileException("write failes: not open");
            }
            channel.position(pos);
            int tryCount = 0;
            while (buffer.position() != buffer.limit()) {
                int written = channel.write(buffer.internalBuffer());
                if (written > 0) {
                    tryCount = 0;
                    continue;
                }
                if (tryCount >= 10) {
                    throw new ManagedFileException("write failes: max retries");
                }
                try {
                    Thread.sleep(100 * tryCount);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ManagedFileException("write failes: interrupted");
                    return;
                }
            }
        }
        catch (Exception exp) {
            throw new ManagedFileException("write fails", exp);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int read(ByteBuffer buffer, long pos) throws ManagedFileException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("read failes: interrupted", exp);
        }
        try {
            this.checkOpenFile();
            if (this.raFile == null) {
                throw new ManagedFileException("read failes: raFile null");
            }
            FileChannel channel = this.raFile.getChannel();
            if (!channel.isOpen()) {
                throw new ManagedFileException("read failes: not open");
            }
            channel.position(pos);
            int totalRead = 0;
            while (channel.position() < channel.size() && buffer.hasRemaining()) {
                int read = channel.read(buffer.internalBuffer());
                if (read <= 0) continue;
                totalRead += read;
            }
            int n = totalRead;
            return n;
        }
        catch (Exception exp) {
            throw new ManagedFileException("read fails", exp);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLength(long newLength) throws ManagedFileException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("read failes: interrupted", exp);
        }
        try {
            this.checkOpenFile();
            if (this.raFile == null) {
                throw new ManagedFileException("read failes: raFile null");
            }
            this.raFile.setLength(newLength);
        }
        catch (Exception exp) {
            throw new ManagedFileException("read fails", exp);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void renameFile(File destFile) throws ManagedFileException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("rename failes: interrupted", exp);
        }
        try {
            if (this.fsFile.exists()) {
                this.closeFile();
                FileUtils.renameFileMultiFallback(this.fsFile, destFile);
            }
            this.fsFile = destFile;
        }
        catch (Exception exp) {
            throw new ManagedFileException("rename failed", exp);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deleteFile() throws ManagedFileException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("delete failes: interrupted", exp);
        }
        try {
            if (this.fsFile.exists()) {
                this.closeFile();
                FileUtils.deleteFileMultiFallback(this.fsFile);
            }
        }
        catch (Exception exp) {
            throw new ManagedFileException("delete failed", exp);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getLength() {
        return this.fsFile.length();
    }

    public String getAbsolutePath() {
        return this.fsFile.getAbsolutePath();
    }

    public boolean exists() {
        return this.fsFile.exists();
    }

    public String toString() {
        return super.toString() + ",File:" + this.fsFile + ",access:" + (Object)((Object)this.accessMode);
    }

    public void finalize() {
        if (this.raFile != null) {
            long p = -1L;
            try {
                p = this.raFile.getFilePointer();
            }
            catch (IOException exp) {
                NLogger.error(ManagedFile.class, (Object)exp);
            }
            NLogger.error(ManagedFile.class, (Object)("raFile != null - " + p));
            for (StackTraceElement el : this.lastStackTraceElem) {
                NLogger.error(ManagedFile.class, (Object)el);
            }
        }
    }

    public static enum AccessMode {
        READ_ONLY_ACCESS("r"),
        READ_WRITE_ACCESS("rwd");

        private String fileMode;

        private AccessMode(String fileMode) {
            this.fileMode = fileMode;
        }
    }
}

