/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import phex.common.AbstractManager;
import phex.common.bandwidth.BandwidthController;
import phex.prefs.core.BandwidthPrefs;

public class BandwidthManager
extends AbstractManager {
    private BandwidthController phexBandwidthController;
    private BandwidthController networkBandwidthController;
    private BandwidthController downloadBandwidthController;
    private BandwidthController uploadBandwidthController;

    public void setDownloadBandwidth(int newDownloadBwInBytes) {
        BandwidthPrefs.MaxDownloadBandwidth.set(new Integer(newDownloadBwInBytes));
        this.downloadBandwidthController.setThrottlingRate(newDownloadBwInBytes);
    }

    public void setNetworkBandwidth(int newNetworkBwInBytes) {
        BandwidthPrefs.MaxNetworkBandwidth.set(new Integer(newNetworkBwInBytes));
        this.networkBandwidthController.setThrottlingRate(newNetworkBwInBytes);
    }

    public void setPhexTotalBandwidth(int newPhexBwInBytes) {
        BandwidthPrefs.MaxTotalBandwidth.set(new Integer(newPhexBwInBytes));
        this.phexBandwidthController.setThrottlingRate(newPhexBwInBytes);
    }

    public void setUploadBandwidth(int newUploadBwInBytes) {
        BandwidthPrefs.MaxUploadBandwidth.set(new Integer(newUploadBwInBytes));
        this.uploadBandwidthController.setThrottlingRate(newUploadBwInBytes);
    }

    public BandwidthController getPhexBandwidthController() {
        return this.phexBandwidthController;
    }

    public BandwidthController getNetworkBandwidthController() {
        return this.networkBandwidthController;
    }

    public BandwidthController getDownloadBandwidthController() {
        return this.downloadBandwidthController;
    }

    public BandwidthController getUploadBandwidthController() {
        return this.uploadBandwidthController;
    }

    public static BandwidthManager getInstance() {
        return Holder.manager;
    }

    @Override
    public boolean initialize() {
        this.phexBandwidthController = BandwidthController.acquireBandwidthController("PhexThrottle", BandwidthPrefs.MaxTotalBandwidth.get().intValue());
        this.phexBandwidthController.activateShortTransferAvg(1000, 5);
        this.phexBandwidthController.activateLongTransferAvg(2000, 90);
        this.networkBandwidthController = BandwidthController.acquireBandwidthController("NetworkThrottle", BandwidthPrefs.MaxNetworkBandwidth.get().intValue());
        this.networkBandwidthController.activateShortTransferAvg(1000, 5);
        this.networkBandwidthController.activateLongTransferAvg(2000, 90);
        this.networkBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        this.downloadBandwidthController = BandwidthController.acquireBandwidthController("DownloadThrottle", BandwidthPrefs.MaxDownloadBandwidth.get().intValue());
        this.downloadBandwidthController.activateShortTransferAvg(1000, 5);
        this.downloadBandwidthController.activateLongTransferAvg(2000, 90);
        this.downloadBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        this.uploadBandwidthController = BandwidthController.acquireBandwidthController("UploadThrottle", BandwidthPrefs.MaxUploadBandwidth.get().intValue());
        this.uploadBandwidthController.activateShortTransferAvg(1000, 5);
        this.uploadBandwidthController.activateLongTransferAvg(2000, 90);
        this.uploadBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        return true;
    }

    @Override
    public boolean onPostInitialization() {
        return true;
    }

    @Override
    public void startupCompletedNotify() {
    }

    @Override
    public void shutdown() {
        BandwidthController.releaseController(this.downloadBandwidthController);
        BandwidthController.releaseController(this.uploadBandwidthController);
        BandwidthController.releaseController(this.networkBandwidthController);
        BandwidthController.releaseController(this.phexBandwidthController);
    }

    private static class Holder {
        protected static final BandwidthManager manager = new BandwidthManager();

        private Holder() {
        }
    }
}

