/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.event.ChangeEvent;
import phex.net.Server;
import phex.servent.Servent;

public class LocalServentAddress
implements DestAddress {
    private final Server server;
    private DestAddress forcedAddress;
    private DestAddress localAddress;

    public LocalServentAddress(Server server) {
        this.server = server;
        this.localAddress = null;
    }

    public void updateLocalAddress(DestAddress updateAddress) {
        if (this.forcedAddress != null) {
            return;
        }
        if (this.localAddress == null || !this.localAddress.equals(updateAddress)) {
            this.localAddress = updateAddress;
            this.fireNetworkIPChanged(this.localAddress);
        }
    }

    public void setForcedHostIP(IpAddress forcedHostIP) {
    }

    private void fireNetworkIPChanged(DestAddress newAddress) {
        Servent.getInstance().getEventService().publish("phex:servent/localAddress", new ChangeEvent(this, null, newAddress));
    }

    protected DestAddress getEffectiveAddress() {
        return this.forcedAddress != null ? this.forcedAddress : this.localAddress;
    }

    @Override
    public boolean equals(DestAddress address) {
        return this.getEffectiveAddress().equals(address);
    }

    @Override
    public boolean equals(byte[] ipAddress, int port) {
        return this.getEffectiveAddress().equals(ipAddress, port);
    }

    @Override
    public String getCountryCode() {
        return this.getEffectiveAddress().getCountryCode();
    }

    @Override
    public String getFullHostName() {
        return this.getEffectiveAddress().getFullHostName();
    }

    @Override
    public String getHostName() {
        return this.getEffectiveAddress().getHostName();
    }

    @Override
    public IpAddress getIpAddress() {
        return this.getEffectiveAddress().getIpAddress();
    }

    @Override
    public int getPort() {
        return this.getEffectiveAddress().getPort();
    }

    @Override
    public boolean isIpHostName() {
        return this.getEffectiveAddress().isIpHostName();
    }

    @Override
    public boolean isLocalHost() {
        return this.getEffectiveAddress().isLocalHost();
    }

    @Override
    public boolean isSiteLocalAddress() {
        return this.getEffectiveAddress().isSiteLocalAddress();
    }

    @Override
    public boolean isValidAddress() {
        return this.getEffectiveAddress().isValidAddress();
    }

    @Override
    @Deprecated
    public void setPort(int port) {
        this.getEffectiveAddress().setPort(port);
    }
}

