/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;
import phex.servent.Servent;

public class I2PDestAddress
implements DestAddress {
    public static final int INVALID_PORT = -1;
    private int hash = 0;
    private Destination destination;

    public I2PDestAddress(String aDestination, int aPort) {
        if (aDestination == null) {
            NLogger.error(I2PDestAddress.class, (Object)"Tried creating I2PDestAddress from null destination string");
            throw new NullPointerException("Tried creating I2PDestAddress from null destination string");
        }
        if (aPort != -1) {
            NLogger.error(I2PDestAddress.class, (Object)"Tried creating I2PDestAddress with valid port");
            throw new NullPointerException("Tried creating I2PDestAddress with valid port");
        }
        try {
            this.destination = new Destination(aDestination);
        }
        catch (DataFormatException e) {
            NLogger.error(I2PDestAddress.class, (Object)"Tried creating I2PDestAddress from invalid data");
            throw new NullPointerException("Tried creating I2PDestAddress from invalid data");
        }
    }

    public I2PDestAddress(Destination aDestination) {
        if (aDestination == null) {
            NLogger.error(I2PDestAddress.class, (Object)"Tried creating I2PDestAddress from null destination");
            throw new NullPointerException("Tried creating I2PDestAddress from null destination");
        }
        this.destination = aDestination;
    }

    @Override
    public String getHostName() {
        return this.destination.toBase64();
    }

    @Override
    public String getFullHostName() {
        return this.destination.toBase64();
    }

    @Override
    public boolean isIpHostName() {
        return false;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public void setPort(int newPort) {
        if (newPort != -1) {
            NLogger.error(I2PDestAddress.class, (Object)"Tried setting a valid port on an I2P destination");
        }
    }

    @Override
    public IpAddress getIpAddress() {
        return null;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DestAddress) {
            return this.equals((DestAddress)obj);
        }
        return false;
    }

    @Override
    public boolean equals(DestAddress address) {
        if (address instanceof I2PDestAddress) {
            return this.equals((I2PDestAddress)address);
        }
        return false;
    }

    public boolean equals(I2PDestAddress address) {
        if (address != null) {
            return this.destination.equals((Object)address.getDestination());
        }
        return false;
    }

    @Override
    public boolean equals(byte[] testIp, int testPort) {
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.destination.hashCode();
            return this.hash;
        }
        return this.hash;
    }

    @Override
    public String getCountryCode() {
        return null;
    }

    @Override
    public boolean isLocalHost() {
        DestAddress localAddress = Servent.getInstance().getLocalAddress();
        return localAddress.equals(this);
    }

    @Override
    public boolean isSiteLocalAddress() {
        return false;
    }

    @Override
    public boolean isValidAddress() {
        return this.destination != null;
    }

    public String toString() {
        return this.getFullHostName();
    }
}

