/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import phex.common.log.NLogger;

public class ThreadTracking {
    public static ThreadGroup threadPoolGroup;
    public static ThreadGroup rootThreadGroup;
    private static ThreadGroup systemGroup;

    public static void initialize() {
        systemGroup = Thread.currentThread().getThreadGroup();
        while (systemGroup.getParent() != null) {
            systemGroup = systemGroup.getParent();
        }
        ThreadTracking.prepareUncaughtExceptionHandler();
        rootThreadGroup = new PhexThreadGroup("PhexRoot");
        threadPoolGroup = new PhexThreadGroup("PhexThreadPool");
    }

    private static void prepareUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler ucExpHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                NLogger.error(ThreadTracking.class, (Object)("Uncaught exception: " + throwable.getMessage() + " in Thread: " + thread.getName()), throwable);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(ucExpHandler);
    }

    private static class PhexThreadGroup
    extends ThreadGroup {
        public PhexThreadGroup(String name) {
            super(systemGroup, name);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            super.uncaughtException(t, e);
            NLogger.error(PhexThreadGroup.class, (Object)("Uncaught exception: " + e.getMessage() + " in Thread: " + t.getName()), e);
        }
    }
}

