/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import phex.common.collections.PriorityQueue;
import phex.msg.PongMsg;
import phex.servent.ServentInfo;

public class PongCache {
    private static final int PONGS_PER_HOP = 1;
    private static final int MAX_HOPS = 6;
    private static final int EXPIRE_TIME_MILLIS = 60000;
    private final PriorityQueue pongQueue;
    private final ServentInfo serventInfo;

    public PongCache(ServentInfo serventInfo) {
        this.serventInfo = serventInfo;
        int[] capacities = new int[6];
        Arrays.fill(capacities, 1);
        this.pongQueue = new PriorityQueue(capacities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PongMsg> getPongs() {
        PriorityQueue priorityQueue = this.pongQueue;
        synchronized (priorityQueue) {
            LinkedList<PongMsg> pongList = new LinkedList<PongMsg>();
            LinkedList<PongMsg> removeList = null;
            long now = System.currentTimeMillis();
            Iterator iterator = this.pongQueue.iterator();
            while (iterator.hasNext()) {
                PongMsg pong = (PongMsg)iterator.next();
                if (now - pong.getCreationTime() > 60000L) {
                    if (removeList == null) {
                        removeList = new LinkedList<PongMsg>();
                    }
                    removeList.add(pong);
                    continue;
                }
                pongList.add(pong);
            }
            this.removePongs(removeList);
            return pongList;
        }
    }

    private void removePongs(List<PongMsg> pongList) {
        if (pongList == null) {
            return;
        }
        for (PongMsg pong : pongList) {
            this.pongQueue.removeFromAll(pong);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPong(PongMsg pong) {
        if (!pong.isUltrapeerMarked()) {
            return;
        }
        if (!this.serventInfo.isUltrapeer()) {
            return;
        }
        int hops = pong.getHeader().getHopsTaken() - 1;
        if (hops >= 6) {
            return;
        }
        PriorityQueue priorityQueue = this.pongQueue;
        synchronized (priorityQueue) {
            this.pongQueue.addToHead(pong, hops);
        }
    }
}

