/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultipleException
extends Exception {
    private List<Throwable> list;

    public MultipleException() {
        super("Multiple exceptions");
    }

    public void add(Throwable th) {
        if (this.list == null) {
            this.list = new ArrayList<Throwable>();
        }
        this.list.add(th);
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public List<Throwable> getThrowables() {
        if (this.list == null) {
            return Collections.emptyList();
        }
        return this.list;
    }

    public Throwable getThrowable(int i) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.list.get(i);
    }

    public void throwPossibleExp() throws Exception {
        if (this.list == null) {
            return;
        }
        if (this.list.size() == 1) {
            Throwable th = this.list.get(0);
            if (th instanceof Error) {
                throw (Error)th;
            }
            if (th instanceof Exception) {
                throw (Exception)th;
            }
        }
        throw this;
    }

    public void throwPossibleExpAsRuntime() throws Error {
        if (this.list == null) {
            return;
        }
        if (this.list.size() == 1) {
            Throwable th = this.list.get(0);
            if (th instanceof Error) {
                throw (Error)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
        throw new RuntimeException(this);
    }

    @Override
    public String toString() {
        if (this.list == null) {
            return "phex.common.MultipleException[]";
        }
        return "phex.common.MultipleException" + this.list.toString();
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.list == null) {
            return;
        }
        for (Throwable th : this.list) {
            th.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        if (this.list == null) {
            return;
        }
        for (Throwable th : this.list) {
            th.printStackTrace(out);
        }
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        if (this.list == null) {
            return;
        }
        for (Throwable th : this.list) {
            th.printStackTrace(out);
        }
    }
}

