/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import phex.common.AbstractManager;
import phex.common.Manager;
import phex.common.bandwidth.BandwidthManager;
import phex.common.log.NLogger;
import phex.download.swarming.SwarmingManager;
import phex.net.repres.PresentationManager;
import phex.prefs.core.ConnectionPrefs;
import phex.security.PhexSecurityManager;
import phex.servent.OnlineStatus;
import phex.servent.Servent;
import phex.statistic.StatisticsManager;

public final class ManagerController {
    private static final List<Manager> MANAGER_LIST;

    public static void initializeManagers() {
        for (Manager manager : MANAGER_LIST) {
            long start = System.currentTimeMillis();
            NLogger.debug(ManagerController.class, (Object)("Initializing " + manager.getClass().getName()));
            boolean succ = manager.initialize();
            if (!succ) {
                NLogger.error(ManagerController.class, (Object)("Failed to initialize " + manager.getClass().getName()));
                throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
            }
            long end = System.currentTimeMillis();
            NLogger.debug(ManagerController.class, (Object)("Initialization time: " + (end - start) + " - " + manager.getClass().getName()));
        }
        ManagerController.postInitializeManagers();
    }

    private static void postInitializeManagers() {
        for (Manager manager : MANAGER_LIST) {
            long start = System.currentTimeMillis();
            NLogger.debug(ManagerController.class, (Object)("On post initialization " + manager.getClass().getName()));
            boolean succ = manager.onPostInitialization();
            if (!succ) {
                NLogger.error(ManagerController.class, (Object)("Failed to initialize " + manager.getClass().getName()));
                throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
            }
            long end = System.currentTimeMillis();
            NLogger.debug(ManagerController.class, (Object)("Post-Initialization time: " + (end - start) + " - " + manager.getClass().getName()));
        }
    }

    public static void startupCompletedNotify() {
        for (Manager manager : MANAGER_LIST) {
            long start = System.currentTimeMillis();
            NLogger.debug(ManagerController.class, (Object)("StartupCompletedNotify " + manager.getClass().getName()));
            manager.startupCompletedNotify();
            long end = System.currentTimeMillis();
            NLogger.debug(ManagerController.class, (Object)("StartupCompletedNotify time: " + (end - start) + " - " + manager.getClass().getName()));
        }
    }

    public static void shutdownManagers() {
        for (Manager manager : MANAGER_LIST) {
            try {
                long start = System.currentTimeMillis();
                NLogger.debug(ManagerController.class, (Object)("Shutdown " + manager.getClass().getName()));
                manager.shutdown();
                long end = System.currentTimeMillis();
                NLogger.debug(ManagerController.class, (Object)("Shutdown time: " + (end - start) + " - " + manager.getClass().getName()));
            }
            catch (Exception exp) {
                NLogger.error(ManagerController.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    static {
        ArrayList<AbstractManager> tmpList = new ArrayList<AbstractManager>();
        tmpList.add(SwarmingManager.getInstance());
        tmpList.add(PresentationManager.getInstance());
        tmpList.add(PhexSecurityManager.getInstance());
        tmpList.add(StatisticsManager.getInstance());
        tmpList.add(BandwidthManager.getInstance());
        MANAGER_LIST = Collections.unmodifiableList(tmpList);
        if (ConnectionPrefs.AutoConnectOnStartup.get().booleanValue()) {
            Servent.getInstance().setOnlineStatus(OnlineStatus.ONLINE);
        } else {
            Servent.getInstance().setOnlineStatus(OnlineStatus.OFFLINE);
        }
    }
}

