/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import phex.common.ThreadPool;
import phex.common.address.AddressUtils;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;
import phex.utils.IOUtil;

public class Ip2CountryDB {
    private boolean isLoaded = false;
    private List<IpCountryRange> ipCountryRangeList = new ArrayList<IpCountryRange>();

    private Ip2CountryDB() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Ip2CountryDB.this.loadIp2CountryDB();
            }
        };
        ThreadPool.getInstance().addJob(runnable, "IP2CountryLoader");
    }

    public static String getCountryCode(IpAddress address) {
        return Holder.manager.getCountryCodeInt(address);
    }

    private String getCountryCodeInt(IpAddress address) {
        if (!this.isLoaded) {
            return null;
        }
        IpCountryRange range = this.binarySearch(address.getHostIP());
        if (range == null) {
            return "";
        }
        return range.countryCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIp2CountryDB() {
        InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/ip2country.csv");
        if (inStream == null) {
            NLogger.debug(Ip2CountryDB.class, (Object)"Default GWebCache file not found.");
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        ArrayList<IpCountryRange> initialList = new ArrayList<IpCountryRange>(5000);
        try {
            String line = reader.readLine();
            while (line != null) {
                IpCountryRange range = new IpCountryRange(line);
                initialList.add(range);
                line = reader.readLine();
            }
        }
        catch (IOException exp) {
            NLogger.error(Ip2CountryDB.class, (Object)exp, (Throwable)exp);
        }
        finally {
            IOUtil.closeQuietly(reader);
        }
        initialList.trimToSize();
        Collections.sort(initialList);
        this.ipCountryRangeList = Collections.unmodifiableList(initialList);
        this.isLoaded = true;
    }

    private IpCountryRange binarySearch(byte[] hostIp) {
        int low = 0;
        int high = this.ipCountryRangeList.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            IpCountryRange midVal = this.ipCountryRangeList.get(mid);
            int cmp = midVal.compareHostAddress(hostIp);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    private static class IpCountryRange
    implements Comparable<IpCountryRange> {
        byte[] from;
        byte[] to;
        String countryCode;

        public IpCountryRange(String line) {
            int startIdx = 0;
            int endIdx = line.indexOf(44, startIdx);
            this.from = AddressUtils.parseIntIP(line.substring(startIdx, endIdx));
            startIdx = endIdx + 1;
            endIdx = line.indexOf(44, startIdx);
            this.to = AddressUtils.parseIntIP(line.substring(startIdx, endIdx));
            startIdx = endIdx + 1;
            String subCode = line.substring(startIdx);
            this.countryCode = subCode.intern();
        }

        public int compareHostAddress(byte[] hostIp) {
            long fromIpL;
            long hostIpL = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(hostIp, 0));
            long cmp = hostIpL - (fromIpL = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(this.from, 0)));
            if (cmp == 0L) {
                return 0;
            }
            if (cmp < 0L) {
                return 1;
            }
            long toIpL = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(this.to, 0));
            cmp = hostIpL - toIpL;
            if (cmp == 0L || cmp < 0L) {
                return 0;
            }
            return -1;
        }

        @Override
        public int compareTo(IpCountryRange range) {
            long ip2l;
            if (range == this) {
                return 0;
            }
            byte[] ip1 = this.from;
            byte[] ip2 = range.from;
            long ip1l = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(ip1, 0));
            if (ip1l < (ip2l = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(ip2, 0)))) {
                return -1;
            }
            return 1;
        }
    }

    private static class Holder {
        protected static final Ip2CountryDB manager = new Ip2CountryDB();

        private Holder() {
        }
    }
}

