/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.msg.PongMsg;

public class HorizonTracker {
    private static final int MAX_PONG_COUNT = 10000;
    private static HorizonTracker instance = new HorizonTracker();
    private boolean useLastCountValues;
    private Set<DestAddress> trackedAddresses;
    private int currentHostCount;
    private long currentFileCount;
    private long currentFileSize;
    private int lastHostCount;
    private long lastFileCount;
    private long lastFileSize;

    private HorizonTracker() {
        Environment.getInstance().scheduleTimerTask(new TrackerRefreshTimer(), 900000L, 900000L);
        this.useLastCountValues = false;
        this.trackedAddresses = new HashSet<DestAddress>();
    }

    public static HorizonTracker getInstance() {
        return instance;
    }

    public long getTotalFileCount() {
        return this.useLastCountValues ? this.lastFileCount : this.currentFileCount;
    }

    public long getTotalFileSize() {
        return this.useLastCountValues ? this.lastFileSize : this.currentFileSize;
    }

    public int getTotalHostCount() {
        return this.useLastCountValues ? this.lastHostCount : this.currentHostCount;
    }

    public synchronized void trackPong(PongMsg pong) {
        if (this.trackedAddresses.size() > 10000) {
            return;
        }
        boolean isAdded = this.trackedAddresses.add(pong.getPongAddress());
        if (isAdded) {
            this.currentFileCount += pong.getFileCount();
            this.currentFileSize += pong.getFileSizeInKB();
            ++this.currentHostCount;
        }
    }

    private synchronized void refreshTrackerStats() {
        this.lastHostCount = this.currentHostCount;
        this.lastFileCount = this.currentFileCount;
        this.lastFileSize = this.currentFileSize;
        this.useLastCountValues = true;
        this.currentFileCount = 0L;
        this.currentFileSize = 0L;
        this.currentHostCount = 0;
        this.trackedAddresses.clear();
    }

    private class TrackerRefreshTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 900000L;

        private TrackerRefreshTimer() {
        }

        @Override
        public void run() {
            try {
                HorizonTracker.this.refreshTrackerStats();
            }
            catch (Throwable th) {
                NLogger.error(TrackerRefreshTimer.class, (Object)th, th);
            }
        }
    }
}

