/*
 * Decompiled with CFR 0.152.
 */
package phex.chat;

import java.io.IOException;
import phex.chat.ChatEvent;
import phex.chat.ChatService;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.common.log.NLogger;
import phex.io.buffer.ByteBuffer;
import phex.net.connection.Connection;
import phex.net.connection.SocketFactory;
import phex.net.repres.SocketFacade;
import phex.prefs.core.NetworkPrefs;
import phex.servent.Servent;
import phex.utils.GnutellaInputStream;

public final class ChatEngine {
    private final ChatService chatMgr;
    private final boolean isOutgoingConnection;
    private GnutellaInputStream chatReader;
    private Connection connection;
    private String chatNick;
    private final DestAddress hostAddress;

    protected ChatEngine(ChatService chatMgr, Connection connection) throws IOException {
        this.chatMgr = chatMgr;
        this.connection = connection;
        this.hostAddress = connection.getSocket().getRemoteAddress();
        this.chatReader = connection.getInputStream();
        this.chatNick = this.hostAddress.getFullHostName();
        this.finalizeHandshake();
        this.isOutgoingConnection = false;
    }

    protected ChatEngine(ChatService chatMgr, DestAddress aHostAddress) {
        this.chatMgr = chatMgr;
        this.hostAddress = aHostAddress;
        this.isOutgoingConnection = true;
        this.chatNick = this.hostAddress.getFullHostName();
    }

    public void startChat() {
        ChatReadWorker worker = new ChatReadWorker();
        ThreadPool.getInstance().addJob(worker, "ChatReadWorker-" + Integer.toHexString(worker.hashCode()));
    }

    public void stopChat() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        this.chatMgr.chatClosed(this);
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getChatNick() {
        return this.chatNick;
    }

    public void sendChatMessage(String message) {
        if (this.connection == null) {
            this.chatMgr.fireChatConnectionFailed(this);
        }
        try {
            this.connection.write(ByteBuffer.wrap((message + "\n").getBytes()));
        }
        catch (IOException exp) {
            NLogger.warn(ChatEngine.class, (Object)exp, (Throwable)exp);
            this.stopChat();
        }
    }

    private void finalizeHandshake() throws IOException {
        String line;
        this.connection.getSocket().setSoTimeout(NetworkPrefs.TcpRWTimeout.get());
        do {
            line = this.chatReader.readLine();
            NLogger.debug(ChatEngine.class, (Object)("Read Chat header: " + line));
            if (line == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String upLine = line.toUpperCase();
            if (!upLine.startsWith("X-NICKNAME:")) continue;
            this.chatNick = line.substring(11).trim();
            NLogger.debug(ChatEngine.class, (Object)("Chat Nick: " + this.chatNick));
        } while (line.length() > 0);
        NLogger.debug(ChatEngine.class, (Object)"Sending: CHAT/0.1 200 OK");
        this.connection.write(ByteBuffer.wrap(("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "\r\n").getBytes()));
        do {
            line = this.chatReader.readLine();
            NLogger.debug(ChatEngine.class, (Object)("Read Chat response: " + line));
            if (line != null) continue;
            throw new IOException("No handshake response from chat partner.");
        } while (line.length() > 0);
        this.connection.getSocket().setSoTimeout(0);
    }

    private void connectOutgoingChat() throws IOException {
        String line;
        NLogger.debug(ChatEngine.class, (Object)("Connect outgoing to: " + this.hostAddress));
        SocketFacade socket = SocketFactory.connect(this.hostAddress);
        BandwidthController bwController = BandwidthManager.getInstance().getNetworkBandwidthController();
        this.connection = new Connection(socket, bwController);
        String message = "CHAT CONNECT/0.1\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "\r\n";
        NLogger.debug(ChatEngine.class, (Object)("Sending: " + message));
        this.connection.write(ByteBuffer.wrap(message.getBytes()));
        this.chatReader = this.connection.getInputStream();
        do {
            line = this.chatReader.readLine();
            NLogger.debug(ChatEngine.class, (Object)("Read Chat header: " + line));
            if (line == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String upLine = line.toUpperCase();
            if (!upLine.startsWith("X-NICKNAME:")) continue;
            this.chatNick = line.substring(11).trim();
        } while (line.length() > 0);
        this.connection.write(ByteBuffer.wrap(("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n\r\n").getBytes()));
        socket.setSoTimeout(0);
    }

    private class ChatReadWorker
    implements Runnable {
        private ChatReadWorker() {
        }

        @Override
        public void run() {
            if (ChatEngine.this.isOutgoingConnection) {
                try {
                    ChatEngine.this.connectOutgoingChat();
                }
                catch (IOException exp) {
                    ChatEngine.this.stopChat();
                    return;
                }
            }
            try {
                while (true) {
                    String str;
                    if ((str = ChatEngine.this.chatReader.readLine()) == null) {
                        throw new IOException("Remote host diconnected chat.");
                    }
                    if (str.length() == 0) continue;
                    NLogger.debug(ChatEngine.class, (Object)("Reading chat message: " + str));
                    Servent.getInstance().getEventService().publish("phex:chat/update", new ChatEvent(ChatEvent.Type.MSG_REC, ChatEngine.this, str));
                }
            }
            catch (IOException exp) {
                NLogger.debug(ChatEngine.class, (Object)exp, (Throwable)exp);
                ChatEngine.this.stopChat();
                return;
            }
        }
    }
}

