/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bushe.swing.event.CleanupEvent;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.ProxySubscriber;
import org.bushe.swing.event.SubscriberTimingEvent;
import org.bushe.swing.event.VetoEventListener;
import org.bushe.swing.event.VetoTopicEventListener;
import org.bushe.swing.event.annotation.ReferenceStrength;
import org.bushe.swing.exception.SwingException;

public class ThreadSafeEventService
implements EventService {
    public static final Integer CLEANUP_START_THRESHOLD_DEFAULT = 250;
    public static final Integer CLEANUP_STOP_THRESHOLD_DEFAULT = 100;
    public static final Long CLEANUP_PERIOD_MS_DEFAULT = 1200000L;
    protected static final Logger LOG = Logger.getLogger(EventService.class.getName());
    private Map subscribersByEventType = new HashMap();
    private Map subscribersByEventClass = new HashMap();
    private Map subscribersByExactEventClass = new HashMap();
    private Map subscribersByTopic = new HashMap();
    private Map subscribersByTopicPattern = new HashMap();
    private Map vetoListenersByClass = new HashMap();
    private Map vetoListenersByExactClass = new HashMap();
    private Map vetoListenersByTopic = new HashMap();
    private Map vetoListenersByTopicPattern = new HashMap();
    private Object listenerLock = new Object();
    private Object cacheLock = new Object();
    private Long timeThresholdForEventTimingEventPublication;
    private Map cacheByEvent = new HashMap();
    private int defaultCacheSizePerClassOrTopic = 0;
    private Map cacheSizesForEventClass;
    private Map rawCacheSizesForEventClass;
    private boolean rawCacheSizesForEventClassChanged;
    private Map cacheByTopic = new HashMap();
    private Map cacheSizesForTopic;
    private Map rawCacheSizesForTopic;
    private boolean rawCacheSizesForTopicChanged;
    private Map rawCacheSizesForPattern;
    private boolean rawCacheSizesForPatternChanged;
    private Integer cleanupStartThreshhold;
    private Integer cleanupStopThreshold;
    private Long cleanupPeriodMS;
    private int weakRefPlusProxySubscriberCount;
    private Timer cleanupTimer;
    private TimerTask cleanupTimerTask;

    public ThreadSafeEventService() {
        this(null, false, null, null, null);
    }

    public ThreadSafeEventService(Long timeThresholdForEventTimingEventPublication) {
        this(timeThresholdForEventTimingEventPublication, false, null, null, null);
    }

    public ThreadSafeEventService(Long timeThresholdForEventTimingEventPublication, boolean subscribeTimingEventsInternally) {
        this(timeThresholdForEventTimingEventPublication, subscribeTimingEventsInternally, null, null, null);
    }

    public ThreadSafeEventService(Integer cleanupStartThreshold, Integer cleanupStopThreshold, Long cleanupPeriodMS) {
        this(null, false, cleanupStartThreshold, cleanupStopThreshold, cleanupPeriodMS);
    }

    public ThreadSafeEventService(Long timeThresholdForEventTimingEventPublication, boolean subscribeTimingEventsInternally, Integer cleanupStartThreshold, Integer cleanupStopThreshold, Long cleanupPeriodMS) {
        if (timeThresholdForEventTimingEventPublication == null && subscribeTimingEventsInternally) {
            throw new IllegalArgumentException("null, true in constructor is not valid.  If you want to send timing messages for all events and subscribe them internally, pass 0, true");
        }
        this.timeThresholdForEventTimingEventPublication = timeThresholdForEventTimingEventPublication;
        if (subscribeTimingEventsInternally) {
            this.subscribeStrongly(SubscriberTimingEvent.class, new EventSubscriber(){

                public void onEvent(Object event) {
                    ThreadSafeEventService.this.subscribeTiming((SubscriberTimingEvent)event);
                }
            });
        }
        this.cleanupStartThreshhold = cleanupStartThreshold == null ? CLEANUP_START_THRESHOLD_DEFAULT : cleanupStartThreshold;
        this.cleanupStopThreshold = cleanupStopThreshold == null ? CLEANUP_STOP_THRESHOLD_DEFAULT : cleanupStopThreshold;
        this.cleanupPeriodMS = cleanupPeriodMS == null ? CLEANUP_PERIOD_MS_DEFAULT : cleanupPeriodMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCleanupStartThreshhold() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.cleanupStartThreshhold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupStartThreshhold(Integer cleanupStartThreshhold) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.cleanupStartThreshhold = cleanupStartThreshhold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCleanupStopThreshold() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.cleanupStopThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupStopThreshold(Integer cleanupStopThreshold) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.cleanupStopThreshold = cleanupStopThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getCleanupPeriodMS() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.cleanupPeriodMS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupPeriodMS(Long cleanupPeriodMS) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.cleanupPeriodMS = cleanupPeriodMS;
        }
    }

    @Override
    public boolean subscribe(Class cl, EventSubscriber eh) {
        if (cl == null) {
            throw new IllegalArgumentException("Event class must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subscribing by class, class:" + cl + ", subscriber:" + eh);
        }
        return this.subscribe(cl, this.subscribersByEventClass, new WeakReference<EventSubscriber>(eh));
    }

    @Override
    public boolean subscribe(Type type, EventSubscriber eh) {
        return this.subscribe(type, this.subscribersByEventType, new WeakReference<EventSubscriber>(eh));
    }

    @Override
    public boolean subscribeExactly(Class cl, EventSubscriber eh) {
        if (cl == null) {
            throw new IllegalArgumentException("Event class must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subscribing by class, class:" + cl + ", subscriber:" + eh);
        }
        return this.subscribe(cl, this.subscribersByExactEventClass, new WeakReference<EventSubscriber>(eh));
    }

    @Override
    public boolean subscribe(String topic, EventTopicSubscriber eh) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event topic subscriber must not be null");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subscribing by topic name, name:" + topic + ", subscriber:" + eh);
        }
        return this.subscribe(topic, this.subscribersByTopic, new WeakReference<EventTopicSubscriber>(eh));
    }

    @Override
    public boolean subscribe(Pattern pat, EventTopicSubscriber eh) {
        if (pat == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subscribing by pattern, pattern:" + pat + ", subscriber:" + eh);
        }
        return this.subscribe(pat, this.subscribersByTopicPattern, new WeakReference<EventTopicSubscriber>(eh));
    }

    @Override
    public boolean subscribeStrongly(Class cl, EventSubscriber eh) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subscribing weakly by class, class:" + cl + ", subscriber:" + eh);
        }
        if (eh == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        return this.subscribe(cl, this.subscribersByEventClass, eh);
    }

    @Override
    public boolean subscribeExactlyStrongly(Class cl, EventSubscriber eh) {
        if (cl == null) {
            throw new IllegalArgumentException("Event class must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subscribing by class, class:" + cl + ", subscriber:" + eh);
        }
        return this.subscribe(cl, this.subscribersByExactEventClass, eh);
    }

    @Override
    public boolean subscribeStrongly(String name, EventTopicSubscriber eh) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subscribing weakly by topic name, name:" + name + ", subscriber:" + eh);
        }
        if (eh == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        return this.subscribe(name, this.subscribersByTopic, eh);
    }

    @Override
    public boolean subscribeStrongly(Pattern pat, EventTopicSubscriber eh) {
        if (pat == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subscribing by pattern, pattern:" + pat + ", subscriber:" + eh);
        }
        return this.subscribe(pat, this.subscribersByTopicPattern, eh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllSubscribers() {
        Object object = this.listenerLock;
        synchronized (object) {
            this.unsubscribeAllInMap(this.subscribersByEventType);
            this.unsubscribeAllInMap(this.subscribersByEventClass);
            this.unsubscribeAllInMap(this.subscribersByExactEventClass);
            this.unsubscribeAllInMap(this.subscribersByTopic);
            this.unsubscribeAllInMap(this.subscribersByTopicPattern);
            this.unsubscribeAllInMap(this.vetoListenersByClass);
            this.unsubscribeAllInMap(this.vetoListenersByExactClass);
            this.unsubscribeAllInMap(this.vetoListenersByTopic);
            this.unsubscribeAllInMap(this.vetoListenersByTopicPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeAllInMap(Map subscriberMap) {
        Object object = this.listenerLock;
        synchronized (object) {
            Set subscriptionKeys = subscriberMap.keySet();
            for (Object key : subscriptionKeys) {
                List subscribers = (List)subscriberMap.get(key);
                while (!subscribers.isEmpty()) {
                    this.unsubscribe(key, subscriberMap, subscribers.get(0));
                }
            }
        }
    }

    @Override
    public boolean subscribeVetoListener(Class eventClass, VetoEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(eventClass, this.vetoListenersByClass, new WeakReference<VetoEventListener>(vetoListener));
    }

    @Override
    public boolean subscribeVetoListenerExactly(Class eventClass, VetoEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(eventClass, this.vetoListenersByExactClass, new WeakReference<VetoEventListener>(vetoListener));
    }

    @Override
    public boolean subscribeVetoListener(String topic, VetoTopicEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (topic == null) {
            throw new IllegalArgumentException("topic cannot be null.");
        }
        return this.subscribeVetoListener(topic, this.vetoListenersByTopic, new WeakReference<VetoTopicEventListener>(vetoListener));
    }

    @Override
    public boolean subscribeVetoListener(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (topicPattern == null) {
            throw new IllegalArgumentException("topicPattern cannot be null.");
        }
        return this.subscribeVetoListener(topicPattern, this.vetoListenersByTopicPattern, new WeakReference<VetoTopicEventListener>(vetoListener));
    }

    @Override
    public boolean subscribeVetoListenerStrongly(Class eventClass, VetoEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(eventClass, this.vetoListenersByClass, vetoListener);
    }

    @Override
    public boolean subscribeVetoListenerExactlyStrongly(Class eventClass, VetoEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(eventClass, this.vetoListenersByExactClass, vetoListener);
    }

    @Override
    public boolean subscribeVetoListenerStrongly(String topic, VetoTopicEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (topic == null) {
            throw new IllegalArgumentException("topic cannot be null.");
        }
        return this.subscribeVetoListener(topic, this.vetoListenersByTopic, vetoListener);
    }

    @Override
    public boolean subscribeVetoListenerStrongly(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (topicPattern == null) {
            throw new IllegalArgumentException("topicPattern cannot be null.");
        }
        return this.subscribeVetoListener(topicPattern, this.vetoListenersByTopicPattern, vetoListener);
    }

    protected boolean subscribeVetoListener(Object subscription, Map vetoListenerMap, Object vetoListener) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("subscribeVetoListener(" + subscription + "," + vetoListener + ")");
        }
        if (vetoListener == null) {
            throw new IllegalArgumentException("Can't subscribe null veto listener to " + subscription);
        }
        if (subscription == null) {
            throw new IllegalArgumentException("Can't subscribe veto listener to null.");
        }
        return this.subscribe(subscription, vetoListenerMap, vetoListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean subscribe(Object topicOrClass, Map subscriberMap, Object subscriber) {
        if (topicOrClass == null) {
            throw new IllegalArgumentException("Can't subscribe to null.");
        }
        if (subscriber == null) {
            throw new IllegalArgumentException("Can't subscribe null subscriber to " + topicOrClass);
        }
        boolean alreadyExists = false;
        boolean isWeakRef = subscriber instanceof WeakReference;
        boolean isWeakProxySubscriber = subscriber instanceof ProxySubscriber && ((ProxySubscriber)subscriber).getReferenceStrength() == ReferenceStrength.WEAK;
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<Object> currentSubscribers = (ArrayList<Object>)subscriberMap.get(topicOrClass);
            if (currentSubscribers == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Creating new subscriber map for :" + topicOrClass);
                }
                currentSubscribers = new ArrayList<Object>();
                subscriberMap.put(topicOrClass, currentSubscribers);
            } else {
                Object realSubscriber = subscriber;
                if (isWeakRef) {
                    realSubscriber = ((WeakReference)subscriber).get();
                    if (isWeakProxySubscriber) {
                        throw new IllegalArgumentException("ProxySubscribers should always be subscribed strongly.");
                    }
                }
                if (isWeakProxySubscriber) {
                    realSubscriber = ((ProxySubscriber)subscriber).getProxiedSubscriber();
                }
                if (realSubscriber == null) {
                    return false;
                }
                Iterator iterator = currentSubscribers.iterator();
                while (iterator.hasNext()) {
                    Object currentSubscriber = iterator.next();
                    Object realCurrentSubscriber = this.getRealSubscriberAndCleanStaleSubscriberIfNecessary(iterator, currentSubscriber);
                    if (!realSubscriber.equals(realCurrentSubscriber)) continue;
                    iterator.remove();
                    alreadyExists = true;
                }
            }
            currentSubscribers.add(subscriber);
            if (isWeakProxySubscriber || isWeakRef) {
                this.incWeakRefPlusProxySubscriberCount();
            }
            return !alreadyExists;
        }
    }

    @Override
    public boolean unsubscribe(Class cl, EventSubscriber eh) {
        return this.unsubscribe(cl, this.subscribersByEventClass, eh);
    }

    @Override
    public boolean unsubscribeExactly(Class cl, EventSubscriber eh) {
        return this.unsubscribe(cl, this.subscribersByExactEventClass, eh);
    }

    @Override
    public boolean unsubscribe(String name, EventTopicSubscriber eh) {
        return this.unsubscribe(name, this.subscribersByTopic, eh);
    }

    @Override
    public boolean unsubscribe(Pattern topicPattern, EventTopicSubscriber eh) {
        return this.unsubscribe(topicPattern, this.subscribersByTopicPattern, eh);
    }

    @Override
    public boolean unsubscribe(Class eventClass, Object subcribedByProxy) {
        EventSubscriber subscriber = (EventSubscriber)((Object)this.getProxySubscriber(eventClass, subcribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribe(eventClass, subscriber);
    }

    @Override
    public boolean unsubscribeExactly(Class eventClass, Object subcribedByProxy) {
        ProxySubscriber subscriber = this.getProxySubscriber(eventClass, subcribedByProxy);
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribeExactly(eventClass, subscriber);
    }

    @Override
    public boolean unsubscribe(String topic, Object subcribedByProxy) {
        EventTopicSubscriber subscriber = (EventTopicSubscriber)((Object)this.getProxySubscriber(topic, subcribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribe(topic, subscriber);
    }

    @Override
    public boolean unsubscribe(Pattern pattern, Object subcribedByProxy) {
        EventTopicSubscriber subscriber = (EventTopicSubscriber)((Object)this.getProxySubscriber(pattern, subcribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribe(pattern, subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unsubscribe(Object o, Map subscriberMap, Object subscriber) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("unsubscribe(" + o + "," + subscriber + ")");
        }
        if (o == null) {
            throw new IllegalArgumentException("Can't unsubscribe to null.");
        }
        if (subscriber == null) {
            throw new IllegalArgumentException("Can't unsubscribe null subscriber to " + o);
        }
        Object object = this.listenerLock;
        synchronized (object) {
            return this.removeFromSetResolveWeakReferences(subscriberMap, o, subscriber);
        }
    }

    private ProxySubscriber getProxySubscriber(Class eventClass, Object subcribedByProxy) {
        List subscribers = this.getSubscribers(eventClass);
        return this.getProxySubscriber(subscribers, subcribedByProxy);
    }

    private ProxySubscriber getProxySubscriber(String topic, Object subcribedByProxy) {
        List subscribers = this.getSubscribers(topic);
        return this.getProxySubscriber(subscribers, subcribedByProxy);
    }

    private ProxySubscriber getProxySubscriber(Pattern pattern, Object subcribedByProxy) {
        List subscribers = this.getSubscribersToPattern(pattern);
        return this.getProxySubscriber(subscribers, subcribedByProxy);
    }

    private ProxySubscriber getProxySubscriber(List subscribers, Object subcribedByProxy) {
        for (Object subscriber : subscribers) {
            ProxySubscriber proxy;
            if (subscriber instanceof WeakReference) {
                WeakReference wr = (WeakReference)subscriber;
                subscriber = wr.get();
            }
            if (!(subscriber instanceof ProxySubscriber) || (subscriber = (proxy = (ProxySubscriber)subscriber).getProxiedSubscriber()) != subcribedByProxy) continue;
            return proxy;
        }
        return null;
    }

    @Override
    public boolean unsubscribeVetoListener(Class eventClass, VetoEventListener vetoListener) {
        return this.unsubscribeVetoListener(eventClass, this.vetoListenersByClass, vetoListener);
    }

    @Override
    public boolean unsubscribeVetoListenerExactly(Class eventClass, VetoEventListener vetoListener) {
        return this.unsubscribeVetoListener(eventClass, this.vetoListenersByExactClass, vetoListener);
    }

    @Override
    public boolean unsubscribeVetoListener(String topic, VetoTopicEventListener vetoListener) {
        return this.unsubscribeVetoListener(topic, this.vetoListenersByTopic, vetoListener);
    }

    @Override
    public boolean unsubscribeVetoListener(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        return this.unsubscribeVetoListener(topicPattern, this.vetoListenersByTopicPattern, vetoListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unsubscribeVetoListener(Object o, Map vetoListenerMap, Object vl) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("unsubscribeVetoListener(" + o + "," + vl + ")");
        }
        if (o == null) {
            throw new IllegalArgumentException("Can't unsubscribe veto listener to null.");
        }
        if (vl == null) {
            throw new IllegalArgumentException("Can't unsubscribe null veto listener to " + o);
        }
        Object object = this.listenerLock;
        synchronized (object) {
            return this.removeFromSetResolveWeakReferences(vetoListenerMap, o, vl);
        }
    }

    @Override
    public void publish(Object event) {
        if (event == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publish(event, null, null, this.getSubscribers(event.getClass()), this.getVetoSubscribers(event.getClass()), null);
    }

    @Override
    public void publish(Type genericType, Object event) {
        if (genericType == null) {
            throw new IllegalArgumentException("genericType must not be null.");
        }
        if (event == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publish(event, null, null, this.getSubscribers(genericType), null, null);
    }

    @Override
    public void publish(String topicName, Object eventObj) {
        this.publish(null, topicName, eventObj, this.getSubscribers(topicName), this.getVetoSubscribers(topicName), null);
    }

    protected void publish(Object event, String topic, Object eventObj, List subscribers, List vetoSubscribers, StackTraceElement[] callingStack) {
        if (event == null && topic == null) {
            throw new IllegalArgumentException("Can't publish to null topic/event.");
        }
        if (LOG.isLoggable(Level.FINE)) {
            if (event != null) {
                LOG.fine("Publishing event: class=" + event.getClass() + ", event=" + event);
            } else if (topic != null) {
                LOG.fine("Publishing event: topic=" + topic + ", eventObj=" + eventObj);
            }
        }
        if (vetoSubscribers != null && !vetoSubscribers.isEmpty()) {
            for (Object vetoer : vetoSubscribers) {
                VetoEventListener vl = null;
                VetoTopicEventListener vtl = null;
                if (event == null) {
                    vtl = (VetoTopicEventListener)vetoer;
                } else {
                    vl = (VetoEventListener)vetoer;
                }
                long start = System.currentTimeMillis();
                try {
                    boolean shouldVeto = false;
                    shouldVeto = event == null ? vtl.shouldVeto(topic, eventObj) : vl.shouldVeto(event);
                    if (!shouldVeto) continue;
                    this.handleVeto(vl, event, vtl, topic, eventObj);
                    this.checkTimeLimit(start, event, null, vl);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Publication vetoed. Event:" + event + ", Topic:" + topic + ", veto subscriber:" + vl);
                    }
                    return;
                }
                catch (Throwable ex) {
                    this.checkTimeLimit(start, event, null, vl);
                    this.subscribeVetoException(event, topic, eventObj, ex, callingStack, vl);
                }
            }
        }
        this.addEventToCache(event, topic, eventObj);
        if (subscribers == null || subscribers.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No subscribers for event or topic. Event:" + event + ", Topic:" + topic);
            }
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Publishing to subscribers :" + subscribers);
        }
        for (int i = 0; i < subscribers.size(); ++i) {
            Object eh = subscribers.get(i);
            if (event != null) {
                EventSubscriber eventSubscriber = (EventSubscriber)eh;
                long start = System.currentTimeMillis();
                try {
                    eventSubscriber.onEvent(event);
                    this.checkTimeLimit(start, event, eventSubscriber, null);
                }
                catch (Throwable e) {
                    this.checkTimeLimit(start, event, eventSubscriber, null);
                    this.handleException(event, e, callingStack, eventSubscriber);
                }
                continue;
            }
            EventTopicSubscriber eventTopicSubscriber = (EventTopicSubscriber)eh;
            try {
                eventTopicSubscriber.onEvent(topic, eventObj);
                continue;
            }
            catch (Throwable e) {
                this.onEventException(topic, eventObj, e, callingStack, eventTopicSubscriber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventToCache(Object event, String topic, Object eventObj) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (event != null) {
                int cacheSizeForEventClass = this.getCacheSizeForEventClass(event.getClass());
                LinkedList<Object> eventClassCache = (LinkedList<Object>)this.cacheByEvent.get(event.getClass());
                if (cacheSizeForEventClass <= 0) {
                    if (eventClassCache != null) {
                        this.cacheByEvent.remove(event.getClass());
                    }
                } else {
                    if (eventClassCache == null) {
                        eventClassCache = new LinkedList<Object>();
                        this.cacheByEvent.put(event.getClass(), eventClassCache);
                    }
                    eventClassCache.add(0, event);
                    while (eventClassCache.size() > cacheSizeForEventClass) {
                        eventClassCache.remove(eventClassCache.size() - 1);
                    }
                }
            } else {
                int cacheSizeForTopic = this.getCacheSizeForTopic(topic);
                LinkedList<Object> topicCache = (LinkedList<Object>)this.cacheByTopic.get(topic);
                if (cacheSizeForTopic <= 0) {
                    if (topicCache != null) {
                        topicCache.remove(topic);
                    }
                } else {
                    if (topicCache == null) {
                        topicCache = new LinkedList<Object>();
                        this.cacheByTopic.put(topic, topicCache);
                    }
                    topicCache.add(0, eventObj);
                    while (topicCache.size() > cacheSizeForTopic) {
                        topicCache.remove(topicCache.size() - 1);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribers(Class eventClass) {
        Object object = this.listenerLock;
        synchronized (object) {
            List hierarchyMatches = this.getSubscribersToClass(eventClass);
            List exactMatches = this.getSubscribersToExactClass(eventClass);
            ArrayList result = new ArrayList();
            if (exactMatches != null) {
                result.addAll(exactMatches);
            }
            if (hierarchyMatches != null) {
                result.addAll(hierarchyMatches);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribersToClass(Class eventClass) {
        Object object = this.listenerLock;
        synchronized (object) {
            Map classMap = this.subscribersByEventClass;
            return this.getEventOrVetoSubscribersToClass(classMap, eventClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribersToExactClass(Class eventClass) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(eventClass, this.subscribersByExactEventClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSubscribers(Type eventType) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getEventOrVetoSubscribersToType(this.subscribersByEventType, eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribers(String topic) {
        Object object = this.listenerLock;
        synchronized (object) {
            List exactMatches = this.getSubscribersToTopic(topic);
            List patternMatches = this.getSubscribersByPattern(topic);
            ArrayList result = new ArrayList();
            if (exactMatches != null) {
                result.addAll(exactMatches);
            }
            if (patternMatches != null) {
                result.addAll(patternMatches);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribersToTopic(String topic) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(topic, this.subscribersByTopic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribersByPattern(String topic) {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList result = new ArrayList();
            Set keys = this.subscribersByTopicPattern.keySet();
            for (Pattern patternKey : keys) {
                if (!patternKey.matcher(topic).matches()) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Pattern " + patternKey + " matched topic name " + topic);
                }
                Collection subscribers = (Collection)this.subscribersByTopicPattern.get(patternKey);
                result.addAll(this.createCopyOfContentsRemoveWeakRefs(subscribers));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getSubscribersToPattern(Pattern topicPattern) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(topicPattern, this.subscribersByTopicPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribers(Class eventClass) {
        Object object = this.listenerLock;
        synchronized (object) {
            List exactMatches = this.getVetoSubscribersToClass(eventClass);
            List hierarchyMatches = this.getVetoSubscribersToExactClass(eventClass);
            ArrayList result = new ArrayList();
            if (exactMatches != null) {
                result.addAll(exactMatches);
            }
            if (hierarchyMatches != null) {
                result.addAll(hierarchyMatches);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribersToClass(Class eventClass) {
        Object object = this.listenerLock;
        synchronized (object) {
            Map classMap = this.vetoListenersByClass;
            return this.getEventOrVetoSubscribersToClass(classMap, eventClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribersToExactClass(Class eventClass) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(eventClass, this.vetoListenersByExactClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribers(String topic) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(topic, this.vetoListenersByTopic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribers(Pattern topicPattern) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(topicPattern, this.vetoListenersByTopicPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSubscribers(Object classOrTopic, Map subscriberMap) {
        Object object = this.listenerLock;
        synchronized (object) {
            List subscribers = (List)subscriberMap.get(classOrTopic);
            return this.createCopyOfContentsRemoveWeakRefs(subscribers);
        }
    }

    private List getEventOrVetoSubscribersToClass(Map classMap, Class eventClass) {
        ArrayList result = new ArrayList();
        Set keys = classMap.keySet();
        for (Class cl : keys) {
            if (!cl.isAssignableFrom(eventClass)) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Hierachical match " + cl + " matched event of class " + eventClass);
            }
            Collection subscribers = (Collection)classMap.get(cl);
            result.addAll(this.createCopyOfContentsRemoveWeakRefs(subscribers));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getEventOrVetoSubscribersToType(Map typeMap, Type eventType) {
        ArrayList result = new ArrayList();
        Set mapKeySet = typeMap.keySet();
        for (Object mapKey : mapKeySet) {
            Collection subscribers;
            Type subscriberType = (Type)mapKey;
            if (!(eventType instanceof ParameterizedType) || !(subscriberType instanceof ParameterizedType)) continue;
            ParameterizedType subscriberPT = (ParameterizedType)subscriberType;
            ParameterizedType eventPT = (ParameterizedType)eventType;
            if (!eventPT.getRawType().equals(subscriberPT.getRawType())) continue;
            Type[] mapTypeArgs = subscriberPT.getActualTypeArguments();
            Type[] eventTypeArgs = eventPT.getActualTypeArguments();
            if (mapTypeArgs == null || eventTypeArgs == null || mapTypeArgs.length != eventTypeArgs.length) continue;
            boolean parameterArgsMatch = true;
            for (int argCount = 0; argCount < mapTypeArgs.length; ++argCount) {
                Type eventTypeArg = eventTypeArgs[argCount];
                if (eventTypeArg instanceof WildcardType) {
                    throw new IllegalArgumentException("Only simple Class parameterized types can be published, not wildcards, etc.  Published attempt made for:" + eventTypeArg);
                }
                Type subscriberTypeArg = mapTypeArgs[argCount];
                if (subscriberTypeArg instanceof WildcardType) {
                    WildcardType wildcardSubscriberTypeArg = (WildcardType)subscriberTypeArg;
                    Type[] upperBound = wildcardSubscriberTypeArg.getUpperBounds();
                    Type[] lowerBound = wildcardSubscriberTypeArg.getLowerBounds();
                    if (upperBound != null && upperBound.length > 0) {
                        if (!(upperBound[0] instanceof Class)) throw new IllegalArgumentException("Only Class and Interface types are supported as types of wildcard subscriptions.  Type:" + upperBound[0]);
                        Class upper = (Class)upperBound[0];
                        if (eventTypeArg instanceof Class) {
                            if (!upper.isAssignableFrom((Class)eventTypeArg)) {
                                parameterArgsMatch = false;
                                break;
                            }
                        } else {
                            parameterArgsMatch = false;
                            break;
                        }
                    }
                    if (lowerBound == null || lowerBound.length <= 0) continue;
                    if (!(lowerBound[0] instanceof Class)) throw new IllegalArgumentException("Only Class and Interface types are supported as types of wildcard subscriptions.  Type:" + upperBound[0]);
                    Class lower = (Class)lowerBound[0];
                    if (eventTypeArg instanceof Class) {
                        if (((Class)eventTypeArg).isAssignableFrom(lower)) continue;
                        parameterArgsMatch = false;
                        break;
                    }
                    parameterArgsMatch = false;
                    break;
                }
                if (subscriberTypeArg.equals(eventTypeArg)) continue;
                parameterArgsMatch = false;
                break;
            }
            if (!parameterArgsMatch) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Exact parameterized subscriberType match for event subscriberType " + eventType);
            }
            if ((subscribers = (Collection)typeMap.get(subscriberType)) == null) continue;
            result.addAll(this.createCopyOfContentsRemoveWeakRefs(subscribers));
        }
        return result;
    }

    private void checkTimeLimit(long start, Object event, EventSubscriber subscriber, VetoEventListener l) {
        if (this.timeThresholdForEventTimingEventPublication == null) {
            return;
        }
        long end = System.currentTimeMillis();
        if (end - start > this.timeThresholdForEventTimingEventPublication) {
            this.publish(new SubscriberTimingEvent(this, new Long(start), new Long(end), this.timeThresholdForEventTimingEventPublication, event, subscriber, l));
        }
    }

    protected void subscribeTiming(SubscriberTimingEvent event) {
        LOG.log(Level.WARNING, event + "");
    }

    protected void handleVeto(VetoEventListener vl, Object event, VetoTopicEventListener vtl, String topic, Object eventObj) {
        if (LOG.isLoggable(Level.FINE)) {
            if (event != null) {
                LOG.fine("Vetoing event: class=" + event.getClass() + ", event=" + event + ", vetoer:" + vl);
            } else {
                LOG.fine("Vetoing event: topic=" + topic + ", eventObj=" + eventObj + ", vetoer:" + vtl);
            }
        }
    }

    private boolean removeFromSetResolveWeakReferences(Map map, Object key, Object toRemove) {
        List subscribers = (List)map.get(key);
        if (subscribers == null) {
            return false;
        }
        if (subscribers.remove(toRemove)) {
            if (toRemove instanceof WeakReference) {
                this.decWeakRefPlusProxySubscriberCount();
            }
            if (toRemove instanceof ProxySubscriber) {
                ((ProxySubscriber)toRemove).proxyUnsubscribed();
                this.decWeakRefPlusProxySubscriberCount();
            }
            return true;
        }
        Iterator iter = subscribers.iterator();
        while (iter.hasNext()) {
            ProxySubscriber proxy;
            ProxySubscriber proxy2;
            Object existingSubscriber = iter.next();
            if (existingSubscriber instanceof ProxySubscriber && (existingSubscriber = (proxy2 = (ProxySubscriber)existingSubscriber).getProxiedSubscriber()) == toRemove) {
                this.removeProxySubscriber(proxy2, iter);
                return true;
            }
            if (!(existingSubscriber instanceof WeakReference)) continue;
            WeakReference wr = (WeakReference)existingSubscriber;
            Object realRef = wr.get();
            if (realRef == null) {
                iter.remove();
                this.decWeakRefPlusProxySubscriberCount();
                return true;
            }
            if (realRef == toRemove) {
                iter.remove();
                this.decWeakRefPlusProxySubscriberCount();
                return true;
            }
            if (!(realRef instanceof ProxySubscriber) || (existingSubscriber = (proxy = (ProxySubscriber)realRef).getProxiedSubscriber()) != toRemove) continue;
            this.removeProxySubscriber(proxy, iter);
            return true;
        }
        return false;
    }

    private List createCopyOfContentsRemoveWeakRefs(Collection subscribersOrVetoListeners) {
        if (subscribersOrVetoListeners == null) {
            return null;
        }
        ArrayList<ProxySubscriber> copyOfSubscribersOrVetolisteners = new ArrayList<ProxySubscriber>(subscribersOrVetoListeners.size());
        Iterator iter = subscribersOrVetoListeners.iterator();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (elem instanceof ProxySubscriber) {
                ProxySubscriber proxy = (ProxySubscriber)elem;
                if ((elem = proxy.getProxiedSubscriber()) == null) {
                    this.removeProxySubscriber(proxy, iter);
                    continue;
                }
                copyOfSubscribersOrVetolisteners.add(proxy);
                continue;
            }
            if (elem instanceof WeakReference) {
                Object hardRef = ((WeakReference)elem).get();
                if (hardRef == null) {
                    iter.remove();
                    this.decWeakRefPlusProxySubscriberCount();
                    continue;
                }
                copyOfSubscribersOrVetolisteners.add((ProxySubscriber)hardRef);
                continue;
            }
            copyOfSubscribersOrVetolisteners.add((ProxySubscriber)elem);
        }
        return copyOfSubscribersOrVetolisteners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultCacheSizePerClassOrTopic(int defaultCacheSizePerClassOrTopic) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.defaultCacheSizePerClassOrTopic = defaultCacheSizePerClassOrTopic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultCacheSizePerClassOrTopic() {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.defaultCacheSizePerClassOrTopic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheSizeForEventClass(Class eventClass, int cacheSize) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.rawCacheSizesForEventClass == null) {
                this.rawCacheSizesForEventClass = new HashMap();
            }
            this.rawCacheSizesForEventClass.put(eventClass, new Integer(cacheSize));
            this.rawCacheSizesForEventClassChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSizeForEventClass(Class eventClass) {
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass must not be null.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            Integer size;
            if (this.rawCacheSizesForEventClass == null || this.rawCacheSizesForEventClass.size() == 0) {
                return this.getDefaultCacheSizePerClassOrTopic();
            }
            if (this.cacheSizesForEventClass == null) {
                this.cacheSizesForEventClass = new HashMap();
            }
            if (this.rawCacheSizesForEventClassChanged) {
                this.cacheSizesForEventClass.clear();
                this.cacheSizesForEventClass.putAll(this.rawCacheSizesForEventClass);
                this.rawCacheSizesForEventClassChanged = false;
            }
            if ((size = (Integer)this.cacheSizesForEventClass.get(eventClass)) != null) {
                return size;
            }
            for (Class parent = eventClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
                Integer parentSize = (Integer)this.cacheSizesForEventClass.get(parent);
                if (parentSize == null) continue;
                this.cacheSizesForEventClass.put(eventClass, parentSize);
                return parentSize;
            }
            Class<?>[] interfaces = eventClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> anInterface = interfaces[i];
                Integer interfaceSize = (Integer)this.cacheSizesForEventClass.get(anInterface);
                if (interfaceSize == null) continue;
                this.cacheSizesForEventClass.put(eventClass, interfaceSize);
                return interfaceSize;
            }
            return this.getDefaultCacheSizePerClassOrTopic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheSizeForTopic(String topicName, int cacheSize) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.rawCacheSizesForTopic == null) {
                this.rawCacheSizesForTopic = new HashMap();
            }
            this.rawCacheSizesForTopic.put(topicName, new Integer(cacheSize));
            this.rawCacheSizesForTopicChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheSizeForTopic(Pattern pattern, int cacheSize) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.rawCacheSizesForPattern == null) {
                this.rawCacheSizesForPattern = new HashMap();
            }
            this.rawCacheSizesForPattern.put(pattern, new Integer(cacheSize));
            this.rawCacheSizesForPatternChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSizeForTopic(String topic) {
        if (topic == null) {
            throw new IllegalArgumentException("topic must not be null.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            Integer size;
            if ((this.rawCacheSizesForTopic == null || this.rawCacheSizesForTopic != null && this.rawCacheSizesForTopic.size() == 0) && (this.rawCacheSizesForPattern == null || this.rawCacheSizesForPattern != null && this.rawCacheSizesForPattern.size() == 0)) {
                return this.getDefaultCacheSizePerClassOrTopic();
            }
            if (this.cacheSizesForTopic == null) {
                this.cacheSizesForTopic = new HashMap();
            }
            if (this.rawCacheSizesForTopicChanged || this.rawCacheSizesForPatternChanged) {
                this.cacheSizesForTopic.clear();
                this.cacheSizesForTopic.putAll(this.rawCacheSizesForTopic);
                this.rawCacheSizesForTopicChanged = false;
                this.rawCacheSizesForPatternChanged = false;
            }
            if ((size = (Integer)this.cacheSizesForTopic.get(topic)) != null) {
                return size;
            }
            if (this.rawCacheSizesForPattern != null) {
                Set patterns = this.rawCacheSizesForPattern.keySet();
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(topic).matches()) continue;
                    size = (Integer)this.rawCacheSizesForPattern.get(pattern);
                    this.cacheSizesForTopic.put(topic, size);
                    return size;
                }
            }
            return this.getDefaultCacheSizePerClassOrTopic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLastEvent(Class eventClass) {
        if (eventClass.isInterface()) {
            throw new IllegalArgumentException("Interfaces are not accepted in get last event, use a specific event class.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List eventCache = (List)this.cacheByEvent.get(eventClass);
            if (eventCache == null || eventCache.size() == 0) {
                return null;
            }
            return eventCache.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCachedEvents(Class eventClass) {
        if (eventClass.isInterface()) {
            throw new IllegalArgumentException("Interfaces are not accepted in get last event, use a specific event class.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List eventCache = (List)this.cacheByEvent.get(eventClass);
            if (eventCache == null || eventCache.size() == 0) {
                return null;
            }
            return eventCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLastTopicData(String topic) {
        Object object = this.cacheLock;
        synchronized (object) {
            List topicCache = (List)this.cacheByTopic.get(topic);
            if (topicCache == null || topicCache.size() == 0) {
                return null;
            }
            return topicCache.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCachedTopicData(String topic) {
        Object object = this.cacheLock;
        synchronized (object) {
            List topicCache = (List)this.cacheByTopic.get(topic);
            if (topicCache == null || topicCache.size() == 0) {
                return null;
            }
            return topicCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(Class eventClassToClear) {
        Object object = this.cacheLock;
        synchronized (object) {
            Set classes = this.cacheByEvent.keySet();
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class cachedClass = (Class)iterator.next();
                if (!eventClassToClear.isAssignableFrom(cachedClass)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(String topic) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheByTopic.remove(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(Pattern pattern) {
        Object object = this.cacheLock;
        synchronized (object) {
            Set classes = this.cacheByTopic.keySet();
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                String cachedTopic = (String)iterator.next();
                if (!pattern.matcher(cachedTopic).matches()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheByEvent.clear();
            this.cacheByTopic.clear();
        }
    }

    protected void subscribeVetoException(Object event, String topic, Object eventObj, Throwable e, StackTraceElement[] callingStack, VetoEventListener vetoer) {
        String str = "EventService veto event listener r:" + vetoer;
        if (vetoer != null) {
            str = str + ".  Vetoer class:" + vetoer.getClass();
        }
        this.handleException("vetoing", event, topic, eventObj, e, callingStack, str);
    }

    protected void onEventException(String topic, Object eventObj, Throwable e, StackTraceElement[] callingStack, EventTopicSubscriber eventTopicSubscriber) {
        String str = "EventService topic subscriber:" + eventTopicSubscriber;
        if (eventTopicSubscriber != null) {
            str = str + ".  Subscriber class:" + eventTopicSubscriber.getClass();
        }
        this.handleException("handling event", null, topic, eventObj, e, callingStack, str);
    }

    protected void handleException(Object event, Throwable e, StackTraceElement[] callingStack, EventSubscriber eventSubscriber) {
        String str = "EventService subscriber:" + eventSubscriber;
        if (eventSubscriber != null) {
            str = str + ".  Subscriber class:" + eventSubscriber.getClass();
        }
        this.handleException("handling event topic", event, null, null, e, callingStack, str);
    }

    protected void handleException(String action, Object event, String topic, Object eventObj, Throwable e, StackTraceElement[] callingStack, String sourceString) {
        String eventClassString = event == null ? "none" : event.getClass().getName();
        String eventString = event + "";
        String contextMsg = "Exception " + action + " event class=" + eventClassString + ", event=" + eventString + ", topic=" + topic + ", eventObj=" + eventObj;
        SwingException clientEx = new SwingException(contextMsg, e, callingStack);
        String msg = "Exception thrown by;" + sourceString;
        LOG.log(Level.WARNING, msg, clientEx);
    }

    protected Object getRealSubscriberAndCleanStaleSubscriberIfNecessary(Iterator iterator, Object existingSubscriber) {
        ProxySubscriber existingProxySubscriber = null;
        if (existingSubscriber instanceof WeakReference && (existingSubscriber = ((WeakReference)existingSubscriber).get()) == null) {
            iterator.remove();
            this.decWeakRefPlusProxySubscriberCount();
        }
        if (existingSubscriber instanceof ProxySubscriber) {
            existingProxySubscriber = (ProxySubscriber)existingSubscriber;
            existingSubscriber = existingProxySubscriber.getProxiedSubscriber();
            if (existingProxySubscriber == null) {
                this.removeProxySubscriber(existingProxySubscriber, iterator);
            }
        }
        return existingSubscriber;
    }

    protected void removeProxySubscriber(ProxySubscriber proxy, Iterator iter) {
        iter.remove();
        proxy.proxyUnsubscribed();
        this.decWeakRefPlusProxySubscriberCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incWeakRefPlusProxySubscriberCount() {
        Object object = this.listenerLock;
        synchronized (object) {
            ++this.weakRefPlusProxySubscriberCount;
            if (this.cleanupStartThreshhold == null || this.cleanupPeriodMS == null) {
                return;
            }
            if (this.weakRefPlusProxySubscriberCount >= this.cleanupStartThreshhold) {
                this.startCleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decWeakRefPlusProxySubscriberCount() {
        Object object = this.listenerLock;
        synchronized (object) {
            --this.weakRefPlusProxySubscriberCount;
            if (this.weakRefPlusProxySubscriberCount < 0) {
                this.weakRefPlusProxySubscriberCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleanup() {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.cleanupTimer == null) {
                this.cleanupTimer = new Timer();
            }
            if (this.cleanupTimerTask == null) {
                this.cleanupTimerTask = new CleanupTimerTask();
                this.cleanupTimer.schedule(this.cleanupTimerTask, 0L, (long)this.cleanupPeriodMS);
            }
        }
    }

    class CleanupTimerTask
    extends TimerTask {
        CleanupTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ThreadSafeEventService.this.listenerLock;
            synchronized (object) {
                ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.STARTING, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, null));
                if (ThreadSafeEventService.this.weakRefPlusProxySubscriberCount <= ThreadSafeEventService.this.cleanupStopThreshold) {
                    this.cancel();
                    ThreadSafeEventService.this.cleanupTimer = null;
                    ThreadSafeEventService.this.cleanupTimerTask = null;
                    ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.UNDER_STOP_THRESHOLD_CLEANING_CANCELLED, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, null));
                    return;
                }
                ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.OVER_STOP_THRESHOLD_CLEANING_BEGUN, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, null));
                ArrayList<Map> allSubscriberMaps = new ArrayList<Map>();
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByEventType);
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByEventClass);
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByExactEventClass);
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByTopic);
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByTopicPattern);
                allSubscriberMaps.add(ThreadSafeEventService.this.vetoListenersByClass);
                allSubscriberMaps.add(ThreadSafeEventService.this.vetoListenersByExactClass);
                allSubscriberMaps.add(ThreadSafeEventService.this.vetoListenersByTopic);
                allSubscriberMaps.add(ThreadSafeEventService.this.vetoListenersByTopicPattern);
                int staleCount = 0;
                for (Map subscriberMap : allSubscriberMaps) {
                    Set subscriptions = subscriberMap.keySet();
                    for (Object subscription : subscriptions) {
                        List subscribers = (List)subscriberMap.get(subscription);
                        Iterator iter = subscribers.iterator();
                        while (iter.hasNext()) {
                            Object subscriber = iter.next();
                            Object realSubscriber = ThreadSafeEventService.this.getRealSubscriberAndCleanStaleSubscriberIfNecessary(iter, subscriber);
                            if (realSubscriber != null) continue;
                            ++staleCount;
                        }
                    }
                }
                ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.FINISHED_CLEANING, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, staleCount));
            }
        }
    }
}

