/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.util.HashMap;
import java.util.Map;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceExistsException;
import org.bushe.swing.event.SwingEventService;

public class EventServiceLocator {
    public static final String SERVICE_NAME_EVENT_BUS = "EventBus";
    public static final String SWING_EVENT_SERVICE_CLASS = "org.bushe.swing.event.swingEventServiceClass";
    private static EventService SWING_EVENT_SERVICE;
    private static final Map EVENT_SERVICES;

    public static synchronized EventService getSwingEventService() {
        if (SWING_EVENT_SERVICE == null) {
            String swingEventServiceClass = System.getProperty(SWING_EVENT_SERVICE_CLASS);
            if (swingEventServiceClass != null) {
                Object service;
                Class<?> sesClass;
                try {
                    sesClass = Class.forName(swingEventServiceClass);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not find class specified in the property org.bushe.swing.event.swingEventServiceClass.  Class=" + swingEventServiceClass, e);
                }
                try {
                    service = sesClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("InstantiationException creating instance of class set from Java propertyorg.bushe.swing.event.swingEventServiceClass.  Class=" + swingEventServiceClass, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("IllegalAccessException creating instance of class set from Java propertyorg.bushe.swing.event.swingEventServiceClass.  Class=" + swingEventServiceClass, e);
                }
                try {
                    SWING_EVENT_SERVICE = (EventService)service;
                }
                catch (ClassCastException ex) {
                    throw new RuntimeException("ClassCastException casting to " + EventService.class + " from instance of class set from Java property" + SWING_EVENT_SERVICE_CLASS + ".  Class=" + swingEventServiceClass, ex);
                }
            }
            SWING_EVENT_SERVICE = new SwingEventService();
            EVENT_SERVICES.put(SERVICE_NAME_EVENT_BUS, SWING_EVENT_SERVICE);
        }
        return SWING_EVENT_SERVICE;
    }

    public static synchronized EventService getEventService(String serviceName) {
        EventService es = (EventService)EVENT_SERVICES.get(serviceName);
        if (es == null && SERVICE_NAME_EVENT_BUS.equals(serviceName)) {
            es = EventServiceLocator.getSwingEventService();
        }
        return es;
    }

    public static synchronized void setEventService(String serviceName, EventService es) throws EventServiceExistsException {
        if (EVENT_SERVICES.get(serviceName) != null && es != null) {
            throw new EventServiceExistsException("An event service by the name " + serviceName + "already exists.  Perhaps multiple threads tried to create a service about the same time?");
        }
        if (SERVICE_NAME_EVENT_BUS.equals(serviceName)) {
            throw new EventServiceExistsException("You cannot use this method to set the EventBus implementation.  Set the Java property org.bushe.swing.event.swingEventServiceClass to the implementation class instead.");
        }
        EVENT_SERVICES.put(serviceName, es);
    }

    static {
        EVENT_SERVICES = new HashMap();
    }
}

