/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.bushe.swing.event.ContainerEventServiceFinder;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;

public class ContainerEventServiceRegistrar {
    private JComponent jComp;
    private EventSubscriber eventSubscriber;
    private Class[] eventClasses;
    private EventTopicSubscriber eventTopicSubscriber;
    private String[] topics;
    private EventService containerEventService;

    public ContainerEventServiceRegistrar(JComponent jComp) {
        this(jComp, null, null, null, null);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, EventSubscriber eventSubscriber, Class eventClass) {
        this(jComp, eventSubscriber, new Class[]{eventClass}, null, null);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, EventTopicSubscriber eventTopicSubscriber, String topic) {
        this(jComp, null, null, eventTopicSubscriber, new String[]{topic});
    }

    public ContainerEventServiceRegistrar(JComponent jComp, EventSubscriber eventSubscriber, Class[] eventClasses) {
        this(jComp, eventSubscriber, eventClasses, null, null);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, EventTopicSubscriber eventTopicSubscriber, String[] topics) {
        this(jComp, null, null, eventTopicSubscriber, topics);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, EventSubscriber eventSubscriber, Class[] eventClasses, EventTopicSubscriber eventTopicSubscriber, String[] topics) {
        this.jComp = jComp;
        this.eventSubscriber = eventSubscriber;
        this.eventClasses = eventClasses;
        this.eventTopicSubscriber = eventTopicSubscriber;
        this.topics = topics;
        if (jComp == null) {
            throw new NullPointerException("JComponent is null");
        }
        this.updateContainerEventService();
        jComp.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }
        });
        jComp.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }
        });
        jComp.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }
        });
    }

    protected void updateContainerEventService() {
        String topic;
        Class eventClass;
        int i;
        if (this.containerEventService != null) {
            if (this.eventClasses != null) {
                for (i = 0; i < this.eventClasses.length; ++i) {
                    eventClass = this.eventClasses[i];
                    this.containerEventService.unsubscribe(eventClass, this.eventSubscriber);
                }
            }
            if (this.topics != null) {
                for (i = 0; i < this.topics.length; ++i) {
                    topic = this.topics[i];
                    this.containerEventService.unsubscribe(topic, this.eventTopicSubscriber);
                }
            }
        }
        this.containerEventService = ContainerEventServiceFinder.getEventService(this.jComp);
        if (this.containerEventService != null) {
            if (this.eventClasses != null) {
                for (i = 0; i < this.eventClasses.length; ++i) {
                    eventClass = this.eventClasses[i];
                    this.containerEventService.subscribe(eventClass, this.eventSubscriber);
                }
            }
            if (this.topics != null) {
                for (i = 0; i < this.topics.length; ++i) {
                    topic = this.topics[i];
                    this.containerEventService.subscribe(topic, this.eventTopicSubscriber);
                }
            }
        }
    }

    public EventService getContainerEventService() {
        if (this.containerEventService != null) {
            return this.containerEventService;
        }
        this.updateContainerEventService();
        return this.containerEventService;
    }
}

